/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.ant;

import com.sshtools.ant.Sftp;
import com.sshtools.ant.SshSubTask;
import com.sshtools.j2ssh.SshClient;
import com.sshtools.j2ssh.authentication.PasswordAuthenticationClient;
import com.sshtools.j2ssh.authentication.PublicKeyAuthenticationClient;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.configuration.SshConnectionProperties;
import com.sshtools.j2ssh.session.PseudoTerminal;
import com.sshtools.j2ssh.session.SessionChannelClient;
import com.sshtools.j2ssh.session.SessionOutputEcho;
import com.sshtools.j2ssh.session.SessionOutputReader;
import com.sshtools.j2ssh.transport.AbstractKnownHostsKeyVerification;
import com.sshtools.j2ssh.transport.HostKeyVerification;
import com.sshtools.j2ssh.transport.InvalidHostFileException;
import com.sshtools.j2ssh.transport.cipher.SshCipherFactory;
import com.sshtools.j2ssh.transport.hmac.SshHmacFactory;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKey;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKeyFile;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class Ssh
extends Task {
    protected String host;
    protected int port = 22;
    protected String username;
    protected String password;
    protected String keyfile;
    protected String passphrase;
    protected String cipher;
    protected String mac;
    protected String fingerprint;
    protected String logfile = null;
    protected boolean verifyhost = true;
    protected boolean always = false;
    protected SshClient ssh;
    protected Vector tasks = new Vector();
    protected String sshtoolsHome;
    protected String newline = "\n";
    static /* synthetic */ Class class$0;

    protected void validate() throws BuildException {
        if (this.host == null) {
            throw new BuildException("You must provide a host to connect to!");
        }
        if (this.username == null) {
            throw new BuildException("You must supply a username for authentication!");
        }
        if (this.password == null && this.keyfile == null) {
            throw new BuildException("You must supply either a password or keyfile/passphrase to authenticate!");
        }
        if (this.verifyhost && this.fingerprint == null) {
            throw new BuildException("Public key fingerprint required to verify the host");
        }
    }

    protected void connectAndAuthenticate() throws BuildException {
        block17: {
            if (this.sshtoolsHome != null) {
                System.setProperty("sshtools.home", this.sshtoolsHome);
            }
            this.log("Initializing J2SSH");
            try {
                int result;
                ConfigurationLoader.initialize(false);
                this.log("Creating connection to " + this.host + ":" + String.valueOf(this.port));
                if (this.ssh != null) break block17;
                this.ssh = new SshClient();
                SshConnectionProperties properties = new SshConnectionProperties();
                properties.setHost(this.host);
                properties.setPort(this.port);
                properties.setUsername(this.username);
                if (this.cipher != null) {
                    if (SshCipherFactory.getSupportedCiphers().contains(this.cipher)) {
                        properties.setPrefSCEncryption(this.cipher);
                        properties.setPrefCSEncryption(this.cipher);
                    } else {
                        this.log(String.valueOf(this.cipher) + " is not a supported cipher, using default " + SshCipherFactory.getDefaultCipher());
                    }
                }
                if (this.mac != null) {
                    if (SshHmacFactory.getSupportedMacs().contains(this.mac)) {
                        properties.setPrefCSMac(this.mac);
                        properties.setPrefSCMac(this.mac);
                    } else {
                        this.log(String.valueOf(this.mac) + " is not a supported mac, using default " + SshHmacFactory.getDefaultHmac());
                    }
                }
                this.log("Connecting....");
                this.ssh.connect(properties, (HostKeyVerification)new AbstractKnownHostsKeyVerification(new File(System.getProperty("user.home"), ".ssh" + File.separator + "known_hosts").getAbsolutePath()){

                    public void onUnknownHost(String hostname, SshPublicKey key) throws InvalidHostFileException {
                        if (Ssh.this.verifyhost) {
                            if (key.getFingerprint().equalsIgnoreCase(Ssh.this.fingerprint)) {
                                this.allowHost(hostname, key, Ssh.this.always);
                            }
                        } else {
                            this.allowHost(hostname, key, Ssh.this.always);
                        }
                    }

                    public void onHostKeyMismatch(String hostname, SshPublicKey allowed, SshPublicKey supplied) throws InvalidHostFileException {
                        if (Ssh.this.verifyhost) {
                            if (supplied.getFingerprint().equalsIgnoreCase(Ssh.this.fingerprint)) {
                                this.allowHost(hostname, supplied, Ssh.this.always);
                            }
                        } else {
                            this.allowHost(hostname, supplied, Ssh.this.always);
                        }
                    }

                    public void onDeniedHost(String host) {
                        Ssh.this.log("The server host key is denied!");
                    }
                });
                boolean authenticated = false;
                this.log("Authenticating " + this.username);
                if (this.keyfile != null) {
                    this.log("Performing public key authentication");
                    PublicKeyAuthenticationClient pk = new PublicKeyAuthenticationClient();
                    SshPrivateKeyFile file = SshPrivateKeyFile.parse(new File(this.keyfile));
                    if (file.isPassphraseProtected() && this.passphrase == null) {
                        throw new BuildException("Private key file is passphrase protected, please supply a valid passphrase!");
                    }
                    SshPrivateKey key = file.toPrivateKey(this.passphrase);
                    pk.setUsername(this.username);
                    pk.setKey(key);
                    result = this.ssh.authenticate(pk);
                    if (result == 4) {
                        authenticated = true;
                    } else if (result == 3) {
                        this.log("Public key authentication completed, attempting password authentication");
                    } else {
                        throw new BuildException("Public Key Authentication failed!");
                    }
                }
                if (this.password == null || authenticated) break block17;
                this.log("Performing password authentication");
                PasswordAuthenticationClient pwd = new PasswordAuthenticationClient();
                pwd.setUsername(this.username);
                pwd.setPassword(this.password);
                result = this.ssh.authenticate(pwd);
                if (result == 4) {
                    this.log("Authentication complete");
                    break block17;
                }
                if (result == 3) {
                    throw new BuildException("Password Authentication succeeded but further authentication required!");
                }
                throw new BuildException("Password Authentication failed!");
            }
            catch (IOException ex) {
                throw new BuildException((Throwable)ex);
            }
        }
    }

    protected void disconnect() throws BuildException {
        try {
            this.log("Disconnecting from " + this.host);
            this.ssh.disconnect();
        }
        catch (Exception ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    public void execute() throws BuildException {
        this.validate();
        this.connectAndAuthenticate();
        this.executeSubTasks();
        this.disconnect();
    }

    protected void executeSubTasks() throws BuildException {
        Iterator it = this.tasks.iterator();
        while (it.hasNext()) {
            SshSubTask task = (SshSubTask)it.next();
            task.setParent(this);
            task.execute(this.ssh);
        }
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setNewline(String newline) {
        this.newline = newline;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setKeyfile(String keyfile) {
        this.keyfile = keyfile;
    }

    public void setPassphrase(String passphrase) {
        this.passphrase = passphrase;
    }

    public void setCipher(String cipher) {
        this.cipher = cipher;
    }

    public void setMac(String mac) {
        this.mac = mac;
    }

    public void setLogfile(String logfile) {
        this.logfile = logfile;
    }

    public void setFingerprint(String fingerprint) {
        this.fingerprint = fingerprint;
    }

    public void setVerifyhost(boolean verifyhost) {
        this.verifyhost = verifyhost;
    }

    public void setAlways(boolean always) {
        this.always = always;
    }

    public void setSshtoolshome(String sshtoolsHome) {
        this.sshtoolsHome = sshtoolsHome;
    }

    protected boolean hasMoreSftpTasks() {
        Iterator it = this.tasks.iterator();
        while (it.hasNext()) {
            Class<?> clazz = it.next().getClass();
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = Class.forName("com.sshtools.ant.Sftp");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!clazz.equals(clazz2)) continue;
            return true;
        }
        return false;
    }

    public SshSubTask createShell() {
        Shell task = new Shell();
        this.tasks.addElement(task);
        return task;
    }

    public SshSubTask createExec() {
        Exec task = new Exec();
        this.tasks.addElement(task);
        return task;
    }

    public SshSubTask createSftp() {
        Sftp task = new Sftp();
        this.tasks.addElement(task);
        return task;
    }

    public class Exec
    extends Shell {
        private String cmd;

        public void execute(SshClient ssh) throws BuildException {
            this.validate();
            try {
                this.log("Executing command " + this.cmd);
                SessionChannelClient session = ssh.openSessionChannel();
                this.output = new SessionOutputReader(session);
                this.allocatePseudoTerminal(session);
                if (!session.executeCommand(this.cmd)) {
                    throw new BuildException("The command failed to start");
                }
                this.performTasks(session);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void setCmd(String cmd) {
            this.cmd = cmd;
        }
    }

    public class Shell
    extends SshSubTask
    implements PseudoTerminal {
        private String term = null;
        private int cols = 80;
        private int rows = 34;
        private int width = 0;
        private int height = 0;
        private String terminalModes = "";
        private Vector commands = new Vector();
        private SessionChannelClient session;
        protected SessionOutputReader output;

        public void execute(SshClient ssh) throws BuildException {
            this.validate();
            try {
                this.session = ssh.openSessionChannel();
                this.output = new SessionOutputReader(this.session);
                this.allocatePseudoTerminal(this.session);
                if (!this.session.startShell()) {
                    throw new BuildException("The session failed to start");
                }
                this.performTasks(this.session);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        protected void validate() throws BuildException {
            if (Ssh.this.ssh == null) {
                throw new BuildException("Invalid SSH session");
            }
            if (!Ssh.this.ssh.isConnected()) {
                throw new BuildException("The SSH session is not connected");
            }
        }

        protected void allocatePseudoTerminal(SessionChannelClient session) throws BuildException {
            try {
                if (this.term != null && !session.requestPseudoTerminal(this)) {
                    throw new BuildException("The server failed to allocate a pseudo terminal");
                }
            }
            catch (IOException ex) {
                throw new BuildException((Throwable)ex);
            }
        }

        protected void performTasks(SessionChannelClient session) throws BuildException {
            if (this.commands.size() > 0) {
                Iterator it = this.commands.iterator();
                while (it.hasNext()) {
                    Object obj = it.next();
                    if (obj instanceof Write) {
                        ((Write)obj).execute();
                        continue;
                    }
                    if (obj instanceof Read) {
                        ((Read)obj).execute();
                        continue;
                    }
                    throw new BuildException("Unexpected shell operation " + obj.toString());
                }
            } else {
                try {
                    this.output.echoLineByLineToClose(new SessionOutputEcho(this){
                        final /* synthetic */ Shell this$1;
                        {
                            this.this$1 = shell;
                        }

                        public void echo(String echo) {
                            this.this$1.log(echo);
                        }
                    });
                }
                catch (InterruptedException ex) {
                    throw new BuildException((Throwable)ex);
                }
            }
        }

        public void setTerm(String term) {
            this.term = term;
        }

        public void setCols(int cols) {
            this.cols = cols;
        }

        public void setRows(int rows) {
            this.rows = rows;
        }

        public String getTerm() {
            return this.term;
        }

        public int getColumns() {
            return this.cols;
        }

        public int getRows() {
            return this.rows;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public String getEncodedTerminalModes() {
            return this.terminalModes;
        }

        public Write createWrite() {
            Write write = new Write();
            this.commands.add(write);
            return write;
        }

        public Read createRead() {
            Read read = new Read();
            this.commands.add(read);
            return read;
        }

        public class Read {
            protected String taskString = "";
            private int timeout = 0;
            private boolean echo = true;

            public void execute() throws BuildException {
                try {
                    Shell.this.output.markCurrentPosition();
                    if (!Shell.this.output.waitForString(this.taskString, this.timeout, new SessionOutputEcho(this){
                        final /* synthetic */ Read this$2;
                        {
                            this.this$2 = read;
                        }

                        public void echo(String msg) {
                            if (Read.access$0(this.this$2)) {
                                Read.access$1(this.this$2).log(msg);
                            }
                        }
                    })) {
                        throw new BuildException("Timeout waiting for string " + this.taskString);
                    }
                }
                catch (InterruptedException ex) {
                    throw new BuildException((Throwable)ex);
                }
            }

            public void addText(String s) {
                this.setString(Ssh.this.getProject().replaceProperties(s));
            }

            public void setTimeout(int timeout) {
                this.timeout = timeout;
            }

            public void setEcho(boolean echo) {
                this.echo = echo;
            }

            public void setString(String s) {
                this.taskString = String.valueOf(this.taskString) + s;
            }

            static /* synthetic */ boolean access$0(Read read) {
                return read.echo;
            }

            static /* synthetic */ Shell access$1(Read read) {
                return read.Shell.this;
            }
        }

        public class Write {
            protected boolean echo = true;
            protected String taskString = "";
            protected boolean newline = true;

            public void execute() throws BuildException {
                try {
                    if (this.echo) {
                        Shell.this.log(this.taskString);
                    }
                    Shell.this.session.getOutputStream().write(this.taskString.getBytes());
                    if (this.newline) {
                        Shell.this.session.getOutputStream().write(((Shell)Shell.this).Ssh.this.newline.getBytes());
                    }
                }
                catch (IOException ex) {
                    throw new BuildException((Throwable)ex);
                }
            }

            public void addText(String s) {
                this.setString(Ssh.this.getProject().replaceProperties(s));
            }

            public void setString(String s) {
                this.taskString = String.valueOf(this.taskString) + s;
            }

            public void setEcho(boolean echo) {
                this.echo = echo;
            }

            public void setNewline(boolean newline) {
                this.newline = newline;
            }
        }
    }
}

