/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.authentication;

import com.sshtools.common.ui.IconWrapperPanel;
import com.sshtools.common.ui.ResourceIcon;
import com.sshtools.common.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;

public class PassphraseDialog
extends JDialog {
    static final String PASSPHRASE_ICON = "/com/sshtools/common/authentication/largepassphrase.png";
    JButton jButtonCancel = new JButton();
    JButton jButtonOK = new JButton();
    JLabel message = new JLabel("Enter passphrase");
    JPasswordField jPasswordField = new JPasswordField(20);
    boolean userCancelled = false;

    public PassphraseDialog() {
        super((Frame)null, "Passphrase", true);
        this.init(null);
    }

    public PassphraseDialog(Frame parent) {
        super(parent, "Passphrase", true);
        this.init(parent);
    }

    public PassphraseDialog(Frame parent, String identity) {
        super(parent, "Passphrase", true);
        this.init(parent);
        this.setTitle(String.valueOf(identity) + " - Identity");
    }

    public PassphraseDialog(Dialog parent) {
        super(parent, "Passphrase", true);
        this.init(parent);
    }

    public boolean isCancelled() {
        return this.userCancelled;
    }

    public void setMessage(String message) {
        this.message.setText(message);
    }

    public void setMessageForeground(Color color) {
        this.message.setForeground(color);
    }

    public char[] getPassphrase() {
        return this.jPasswordField.getPassword();
    }

    void init(Window parent) {
        this.getContentPane().setLayout(new GridLayout(1, 1));
        if (parent != null) {
            this.setLocationRelativeTo(parent);
        }
        try {
            this.jbInit();
            this.pack();
            UIUtil.positionComponent(0, this);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void jButtonCancel_actionPerformed(ActionEvent e) {
        this.userCancelled = true;
        this.hide();
    }

    void jButtonOK_actionPerformed(ActionEvent e) {
        this.userCancelled = false;
        this.hide();
    }

    void jbInit() throws Exception {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                PassphraseDialog.this.userCancelled = true;
            }
        });
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PassphraseDialog.this.jButtonOK_actionPerformed(e);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.setMnemonic('o');
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.setMnemonic('c');
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PassphraseDialog.this.jButtonCancel_actionPerformed(e);
            }
        });
        JPanel passphrasePanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 2, 2, 2);
        gbc.weightx = 1.0;
        UIUtil.jGridBagAdd(passphrasePanel, this.message, gbc, 0);
        UIUtil.jGridBagAdd(passphrasePanel, this.jPasswordField, gbc, 0);
        IconWrapperPanel centerPanel = new IconWrapperPanel(new ResourceIcon(PASSPHRASE_ICON), passphrasePanel);
        centerPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 10;
        gbc.insets = new Insets(6, 6, 0, 0);
        gbc.weighty = 1.0;
        UIUtil.jGridBagAdd(buttonPanel, this.jButtonOK, gbc, -1);
        UIUtil.jGridBagAdd(buttonPanel, this.jButtonCancel, gbc, 0);
        JPanel southPanel = new JPanel(new FlowLayout(2, 0, 0));
        southPanel.add(buttonPanel);
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        mainPanel.add((Component)centerPanel, "Center");
        mainPanel.add((Component)southPanel, "South");
        this.getContentPane().add(mainPanel);
        this.jPasswordField.grabFocus();
    }
}

