/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.automate;

import com.sshtools.common.automate.AuthorizedKeys;
import com.sshtools.common.automate.AuthorizedKeysFileLoader;
import com.sshtools.common.automate.AuthorizedKeysFileSaver;
import com.sshtools.common.automate.AuthorizedKeysFormat;
import com.sshtools.common.configuration.Authorization;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.SECSHPublicKeyFormat;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import com.sshtools.j2ssh.transport.publickey.SshPublicKeyFile;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class SshtoolsAuthorizedKeysFormat
implements AuthorizedKeysFormat {
    public byte[] format(AuthorizedKeys keys) {
        throw new UnsupportedOperationException("SSHTools authorized keys format requries seperate key files!");
    }

    public AuthorizedKeys unformat(byte[] formatted) {
        throw new UnsupportedOperationException("SSHTools authorized keys format requries seperate key files!");
    }

    public byte[] format(AuthorizedKeys keys, AuthorizedKeysFileSaver saver) throws IOException, InvalidSshKeyException {
        Authorization authorization = new Authorization();
        SECSHPublicKeyFormat secsh = new SECSHPublicKeyFormat();
        Iterator it = keys.getAuthorizedKeys().entrySet().iterator();
        while (it != null && it.hasNext()) {
            Map.Entry entry = it.next();
            String username = (String)entry.getValue();
            String filename = String.valueOf(username) + ".pub";
            secsh.setComment(username);
            SshPublicKeyFile pubfile = SshPublicKeyFile.create((SshPublicKey)entry.getKey(), secsh);
            saver.saveFile(filename, pubfile.toString().getBytes("US-ASCII"));
            authorization.addKey(filename);
        }
        return authorization.toString().getBytes("US-ASCII");
    }

    public AuthorizedKeys unformat(byte[] formatted, AuthorizedKeysFileLoader loader) throws IOException, InvalidSshKeyException {
        try {
            AuthorizedKeys keys = new AuthorizedKeys();
            Authorization authorization = new Authorization(new ByteArrayInputStream(formatted));
            List keyfiles = authorization.getAuthorizedKeys();
            Iterator it = keyfiles.iterator();
            while (it.hasNext()) {
                String filename = (String)it.next();
                SshPublicKeyFile pubfile = SshPublicKeyFile.parse(loader.loadFile(filename));
                String username = filename.substring(0, filename.length() - 4);
                keys.addKey(username, pubfile.toPublicKey());
            }
            return keys;
        }
        catch (ParserConfigurationException ex) {
            throw new IOException("Failed to read authorization file: " + ex.getMessage());
        }
        catch (SAXException ex) {
            throw new IOException("Failed to read authorization file: " + ex.getMessage());
        }
    }

    public boolean requiresKeyFiles() {
        return true;
    }
}

