/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.keygen;

import com.sshtools.common.keygen.KeygenPanel;
import com.sshtools.common.ui.IconWrapperPanel;
import com.sshtools.common.ui.ResourceIcon;
import com.sshtools.common.ui.UIUtil;
import com.sshtools.j2ssh.configuration.ConfigurationException;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.transport.publickey.OpenSSHPublicKeyFormat;
import com.sshtools.j2ssh.transport.publickey.SECSHPublicKeyFormat;
import com.sshtools.j2ssh.transport.publickey.SshKeyGenerator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ProgressMonitor;
import javax.swing.UIManager;

public class Main
extends JFrame
implements ActionListener {
    static final String ICON = "/com/sshtools/common/authentication/largepassphrase.png";
    JButton close;
    JButton generate;
    KeygenPanel keygen;

    public Main() {
        super("ssh-keygen");
        try {
            ConfigurationLoader.initialize(false);
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        this.setIconImage(new ResourceIcon(ICON).getImage());
        this.keygen = new KeygenPanel();
        IconWrapperPanel centerPanel = new IconWrapperPanel(new ResourceIcon(ICON), this.keygen);
        centerPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 10;
        gbc.insets = new Insets(6, 6, 0, 0);
        gbc.weighty = 1.0;
        this.generate = new JButton("Generate");
        this.generate.addActionListener(this);
        this.generate.setMnemonic('g');
        this.getRootPane().setDefaultButton(this.generate);
        UIUtil.jGridBagAdd(buttonPanel, this.generate, gbc, -1);
        this.close = new JButton("Close");
        this.close.addActionListener(this);
        this.close.setMnemonic('c');
        UIUtil.jGridBagAdd(buttonPanel, this.close, gbc, 0);
        JPanel southPanel = new JPanel(new FlowLayout(2, 0, 0));
        southPanel.add(buttonPanel);
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        mainPanel.add((Component)centerPanel, "Center");
        mainPanel.add((Component)southPanel, "South");
        this.getContentPane().setLayout(new GridLayout(1, 1));
        this.getContentPane().add(mainPanel);
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.close) {
            this.dispose();
            return;
        }
        final String newPassphrase = new String(this.keygen.getNewPassphrase()).trim();
        final String oldPassphrase = new String(this.keygen.getOldPassphrase()).trim();
        if ((this.keygen.getAction() == 0 || this.keygen.getAction() == 3) && newPassphrase.length() == 0 && JOptionPane.showConfirmDialog(this, "Passphrase is empty. Are you sure?", "Empty Passphrase", 0) == 1) {
            return;
        }
        final File inputFile = new File(this.keygen.getInputFilename());
        final File outputFile = new File(this.keygen.getOutputFilename());
        File publicFile = new File(String.valueOf(this.keygen.getOutputFilename()) + ".pub");
        if (this.keygen.getAction() == 1 || this.keygen.getAction() == 2 || this.keygen.getAction() == 0) {
            if (this.keygen.getOutputFilename().length() == 0) {
                JOptionPane.showMessageDialog(this, "No Output file supplied.", "Error", 0);
                return;
            }
            if (outputFile.exists() && JOptionPane.showConfirmDialog(this, "Output file " + outputFile.getName() + " exists. Are you sure?", "File exists", 0) == 1) {
                return;
            }
            if (outputFile.exists() && !outputFile.canWrite()) {
                JOptionPane.showMessageDialog(this, "Output file " + outputFile.getName() + " can not be written.", "Unwriteable file", 0);
                return;
            }
        }
        if (this.keygen.getAction() == 1 || this.keygen.getAction() == 2) {
            if (this.keygen.getInputFilename().length() == 0) {
                JOptionPane.showMessageDialog(this, "No Input file supplied.", "Error", 0);
                return;
            }
        } else if (this.keygen.getAction() == 0 && publicFile.exists() && !publicFile.canWrite()) {
            JOptionPane.showMessageDialog(this, "Public key file " + publicFile.getName() + " can not be written.", "Unwriteable file", 0);
            return;
        }
        final ProgressMonitor monitor = new ProgressMonitor(this, "Generating keys", "Generating", 0, 100);
        monitor.setMillisToDecideToPopup(0);
        monitor.setMillisToPopup(0);
        Runnable r = new Runnable(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    block8: {
                        try {
                            if (Main.this.keygen.getAction() == 3) {
                                monitor.setNote("Changing passphrase");
                                SshKeyGenerator.changePassphrase(inputFile, oldPassphrase, newPassphrase);
                                monitor.setNote("Complete");
                                JOptionPane.showMessageDialog(Main.this, "Passphrase changed", "Passphrase changed", 1);
                                break block8;
                            }
                            if (Main.this.keygen.getAction() == 1) {
                                monitor.setNote("Converting key file");
                                Main.this.writeString(outputFile, SshKeyGenerator.convertPublicKeyFile(inputFile, new OpenSSHPublicKeyFormat()));
                                monitor.setNote("Complete");
                                JOptionPane.showMessageDialog(Main.this, "Key converted", "Key converted", 1);
                                break block8;
                            }
                            if (Main.this.keygen.getAction() == 2) {
                                monitor.setNote("Converting key file");
                                Main.this.writeString(outputFile, SshKeyGenerator.convertPublicKeyFile(inputFile, new SECSHPublicKeyFormat()));
                                monitor.setNote("Complete");
                                JOptionPane.showMessageDialog(Main.this, "Key converted", "Key converted", 1);
                                break block8;
                            }
                            monitor.setNote("Creating generator");
                            SshKeyGenerator generator = new SshKeyGenerator();
                            monitor.setNote("Generating");
                            String username = System.getProperty("user.name");
                            generator.generateKeyPair(Main.this.keygen.getType(), Main.this.keygen.getBits(), outputFile.getAbsolutePath(), username, newPassphrase);
                            monitor.setNote("Complete");
                            JOptionPane.showMessageDialog(Main.this, "Key generated to " + outputFile.getName(), "Complete", 1);
                        }
                        catch (Exception e) {
                            JOptionPane.showMessageDialog(Main.this, e.getMessage(), "Error", 0);
                        }
                    }
                    Object var3_6 = null;
                    monitor.close();
                    return;
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    monitor.close();
                    throw throwable;
                }
            }
        };
        Thread t = new Thread(r);
        t.start();
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Main main = new Main();
        main.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                System.exit(0);
            }
        });
        main.pack();
        UIUtil.positionComponent(0, main);
        main.setVisible(true);
    }

    /*
     * Exception decompiling
     */
    private void writeString(File file, String string) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 51->55)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

