/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.mru;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MRUList
extends Vector {
    private static Log log;
    private static final String MRU_LIST_ELEMENT = "MRUList";
    private static final String FILE_ELEMENT = "File";
    private String currentElement = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.sshtools.common.mru.MRUList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public MRUList() {
    }

    public MRUList(InputStream in) throws SAXException, ParserConfigurationException, IOException {
        this();
        this.reload(in);
    }

    public void reload(InputStream in) throws SAXException, ParserConfigurationException, IOException {
        SAXParserFactory saxFactory = SAXParserFactory.newInstance();
        SAXParser saxParser = saxFactory.newSAXParser();
        saxParser.parse(in, (DefaultHandler)new MRUSAXHandler());
    }

    public String toString() {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
        xml = String.valueOf(xml) + "<!-- Most recently used -->\n<MRUList>\n";
        Iterator it = this.iterator();
        File file = null;
        while (it.hasNext()) {
            file = (File)it.next();
            xml = String.valueOf(xml) + "   <File>" + file.getAbsolutePath() + "</" + FILE_ELEMENT + ">\n";
        }
        xml = String.valueOf(xml) + "</MRUList>";
        return xml;
    }

    private class MRUSAXHandler
    extends DefaultHandler {
        private String MRU_LIST_ELEMENT = "MRUList";
        private String FILE_ELEMENT = "File";
        private File currentFile = null;
        private Stack tags = new Stack();

        MRUSAXHandler() {
        }

        public void startElement(String uri, String localName, String qname, Attributes attrs) throws SAXException {
            ElementWrapper currentElement;
            ElementWrapper elementWrapper = currentElement = this.tags.size() == 0 ? null : (ElementWrapper)this.tags.peek();
            if (currentElement == null) {
                if (!qname.equals(this.MRU_LIST_ELEMENT)) {
                    throw new SAXException("Unexpected root element <" + qname + ">");
                }
            } else if (currentElement.element.equals(this.MRU_LIST_ELEMENT)) {
                if (!qname.equals(this.FILE_ELEMENT)) {
                    throw new SAXException("Unexpected element <" + qname + ">");
                }
            } else {
                throw new SAXException("Unexpected element <" + qname + ">");
            }
            ElementWrapper w = new ElementWrapper(qname);
            this.tags.push(w);
        }

        public void characters(char[] ch, int start, int len) throws SAXException {
            ElementWrapper currentElement;
            ElementWrapper elementWrapper = currentElement = this.tags.size() == 0 ? null : (ElementWrapper)this.tags.peek();
            if (currentElement == null) {
                throw new SAXException("Unexpected text at " + start + " for " + len);
            }
            currentElement.text.append(new String(ch, start, len));
        }

        public void endElement(String uri, String localName, String qname) throws SAXException {
            ElementWrapper currentElement;
            ElementWrapper elementWrapper = currentElement = this.tags.size() == 0 ? null : (ElementWrapper)this.tags.peek();
            if (currentElement != null) {
                if (!currentElement.element.equals(qname)) {
                    throw new SAXException("Unexpected end element found <" + qname + ">");
                }
                if (currentElement.element.equals(this.FILE_ELEMENT)) {
                    MRUList.this.add(new File(currentElement.text.toString()));
                }
                this.tags.pop();
            }
        }
    }

    public class ElementWrapper {
        String element;
        StringBuffer text;

        ElementWrapper(String element) {
            this.element = element;
            this.text = new StringBuffer();
        }
    }
}

