/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ui;

import com.sshtools.common.ui.MultilineLabel;
import com.sshtools.common.ui.Option;
import com.sshtools.common.ui.OptionCallback;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;

public class OptionsDialog
extends JDialog
implements ActionListener {
    private Option selectedOption;
    private OptionCallback callback;
    private JButton defaultButton;
    static /* synthetic */ Class class$0;

    public OptionsDialog(JDialog parent, Option[] options, Object message, String title, Option defaultOption, OptionCallback callback, boolean modal, Icon icon) {
        super(parent, title, modal);
        this.init(options, message, defaultOption, callback, icon);
    }

    public OptionsDialog(JFrame parent, Option[] options, Object message, String title, Option defaultOption, OptionCallback callback, boolean modal, Icon icon) {
        super(parent, title, modal);
        this.init(options, message, defaultOption, callback, icon);
    }

    private void init(Option[] options, Object message, Option defaultOption, OptionCallback callback, Icon icon) {
        this.callback = callback;
        JPanel b = new JPanel(new FlowLayout(2, 2, 2));
        b.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        int i = 0;
        while (i < options.length) {
            JButton button = new JButton(options[i].getText());
            if (options[i] == defaultOption) {
                button.setDefaultCapable(options[i] == defaultOption);
                this.defaultButton = button;
            }
            button.setMnemonic(options[i].getMnemonic());
            button.setToolTipText(options[i].getToolTipText());
            button.putClientProperty("option", options[i]);
            button.addActionListener(this);
            b.add(button);
            ++i;
        }
        JPanel s = new JPanel(new BorderLayout());
        s.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
        s.add((Component)new JSeparator(0), "North");
        s.add((Component)b, "South");
        JPanel z = new JPanel(new BorderLayout());
        z.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        if (message instanceof JComponent) {
            z.add((Component)((JComponent)message), "Center");
        } else {
            z.add((Component)new MultilineLabel(String.valueOf(message)), "Center");
        }
        JLabel i2 = null;
        if (icon != null) {
            i2 = new JLabel(icon);
            i2.setVerticalAlignment(1);
            i2.setBorder(BorderFactory.createEmptyBorder(4, 4, 0, 4));
        }
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)z, "Center");
        if (i2 != null) {
            this.getContentPane().add((Component)i2, "West");
        }
        this.getContentPane().add((Component)s, "South");
        this.pack();
    }

    public JButton getDefaultButton() {
        return this.defaultButton;
    }

    public Option getSelectedOption() {
        return this.selectedOption;
    }

    public void actionPerformed(ActionEvent evt) {
        this.selectedOption = (Option)((JButton)evt.getSource()).getClientProperty("option");
        if (this.callback == null || this.callback.canClose(this, this.selectedOption)) {
            this.setVisible(false);
        }
    }

    public static OptionsDialog createOptionDialog(JComponent parent, Option[] options, Object message, String title, Option defaultOption, OptionCallback callback, Icon icon) {
        Window w;
        OptionsDialog dialog = null;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.awt.Window");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((dialog = (w = (Window)SwingUtilities.getAncestorOfClass(clazz, parent)) instanceof JFrame ? new OptionsDialog((JFrame)w, options, message, title, defaultOption, callback, true, icon) : (w instanceof JDialog ? new OptionsDialog((JDialog)w, options, message, title, defaultOption, callback, true, icon) : new OptionsDialog(null, options, message, title, defaultOption, callback, true, icon))).getDefaultButton() != null) {
            dialog.getRootPane().setDefaultButton(dialog.getDefaultButton());
        }
        return dialog;
    }
}

