/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ui;

import com.sshtools.common.mru.MRUList;
import com.sshtools.common.mru.MRUListModel;
import com.sshtools.common.ui.MultilineLabel;
import com.sshtools.common.ui.OptionsTab;
import com.sshtools.common.ui.PreferencesStore;
import com.sshtools.common.ui.ResourceIcon;
import com.sshtools.common.ui.SshToolsApplicationContainer;
import com.sshtools.common.ui.SshToolsApplicationException;
import com.sshtools.common.ui.SshToolsApplicationPanel;
import com.sshtools.common.ui.UIUtil;
import com.sshtools.common.util.BrowserLauncher;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.io.IOUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.AccessControlException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SshToolsApplication {
    public static final String PREF_CONNECTION_LAST_HOST = "apps.connection.lastHost";
    public static final String PREF_CONNECTION_LAST_USER = "apps.connection.lastUser";
    public static final String PREF_CONNECTION_LAST_PORT = "apps.connection.lastPort";
    public static final String PREF_CONNECTION_LAST_KEY = "apps.connection.lastKey";
    public static final String PREF_LAF = "apps.laf";
    public static final String CROSS_PLATFORM_LAF = "CROSS_PLATFORM";
    public static final String DEFAULT_LAF = "DEFAULT";
    public static final String SYSTEM_LAF = "SYSTEM";
    protected static Vector containers;
    protected static Log log;
    protected static MRUListModel mruModel;
    private static UIManager.LookAndFeelInfo[] allLookAndFeelInfo;
    protected Class panelClass;
    protected Class defaultContainerClass;
    protected List additionalOptionsTabs;
    static /* synthetic */ Class class$0;

    static {
        UIManager.LookAndFeelInfo[] i;
        containers = new Vector();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.sshtools.common.ui.SshToolsApplication");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
        try {
            i = UIManager.getInstalledLookAndFeels();
        }
        catch (Throwable t) {
            i = new UIManager.LookAndFeelInfo[]{};
        }
        allLookAndFeelInfo = new UIManager.LookAndFeelInfo[i.length + 3];
        System.arraycopy(i, 0, allLookAndFeelInfo, 0, i.length);
        SshToolsApplication.allLookAndFeelInfo[i.length] = new UIManager.LookAndFeelInfo("Default", DEFAULT_LAF);
        SshToolsApplication.allLookAndFeelInfo[i.length + 1] = new UIManager.LookAndFeelInfo("Cross Platform", CROSS_PLATFORM_LAF);
        SshToolsApplication.allLookAndFeelInfo[i.length + 2] = new UIManager.LookAndFeelInfo("System", SYSTEM_LAF);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SshToolsApplication(Class panelClass, Class defaultContainerClass) {
        this.panelClass = panelClass;
        this.defaultContainerClass = defaultContainerClass;
        this.additionalOptionsTabs = new ArrayList();
        try {
            File a;
            if (System.getSecurityManager() != null) {
                AccessController.checkPermission(new FilePermission("<<ALL FILES>>", "write"));
            }
            if ((a = this.getApplicationPreferencesDirectory()) == null) {
                throw new AccessControlException("Application preferences directory not specified.");
            }
            FileInputStream in = null;
            MRUList mru = new MRUList();
            try {
                try {
                    File f = new File(a, String.valueOf(this.getApplicationName()) + ".mru");
                    if (f.exists()) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Loading MRU from " + f.getAbsolutePath()));
                        }
                        in = new FileInputStream(f);
                        mru.reload(in);
                    } else if (log.isDebugEnabled()) {
                        log.debug((Object)("MRU file " + f.getAbsolutePath() + " doesn't exist, creating empty list"));
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Could not load MRU list.", (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                IOUtil.closeStream(in);
                throw throwable;
            }
            {
                Object var7_11 = null;
            }
            IOUtil.closeStream(in);
            mruModel = new MRUListModel();
            mruModel.setMRUList(mru);
            return;
        }
        catch (AccessControlException ace) {
            log.error((Object)"Could not load MRU.", (Throwable)ace);
        }
    }

    public static UIManager.LookAndFeelInfo[] getAllLookAndFeelInfo() {
        return allLookAndFeelInfo;
    }

    public MRUListModel getMRUModel() {
        return mruModel;
    }

    public abstract String getApplicationName();

    public abstract String getApplicationVersion();

    public abstract Icon getApplicationLargeIcon();

    public abstract String getAboutLicenseDetails();

    public abstract String getAboutURL();

    public abstract String getAboutAuthors();

    public abstract File getApplicationPreferencesDirectory();

    public OptionsTab[] getAdditionalOptionsTabs() {
        OptionsTab[] t = new OptionsTab[this.additionalOptionsTabs.size()];
        this.additionalOptionsTabs.toArray(t);
        return t;
    }

    public void addAdditionalOptionsTab(OptionsTab tab) {
        if (!this.additionalOptionsTabs.contains(tab)) {
            this.additionalOptionsTabs.add(tab);
        }
    }

    public void removeAdditionalOptionsTab(OptionsTab tab) {
        this.additionalOptionsTabs.remove(tab);
    }

    public void removeAdditionalOptionsTab(String title) {
        OptionsTab t = this.getOptionsTab(title);
        if (t != null) {
            this.removeAdditionalOptionsTab(t);
        }
    }

    public OptionsTab getOptionsTab(String title) {
        Iterator i = this.additionalOptionsTabs.iterator();
        while (i.hasNext()) {
            OptionsTab t = (OptionsTab)i.next();
            if (!t.getTabTitle().equals(title)) continue;
            return t;
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void exit() {
        block7: {
            log.debug((Object)"Exiting application");
            PreferencesStore.savePreferences();
            FileOutputStream out = null;
            File a = this.getApplicationPreferencesDirectory();
            if (a != null) {
                try {
                    try {
                        File f = new File(this.getApplicationPreferencesDirectory(), String.valueOf(this.getApplicationName()) + ".mru");
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Saving MRU to " + f.getAbsolutePath()));
                        }
                        out = new FileOutputStream(f);
                        PrintWriter w = new PrintWriter(out, true);
                        w.println(mruModel.getMRUList().toString());
                    }
                    catch (IOException ioe) {
                        log.error((Object)"Could not save MRU. ", (Throwable)ioe);
                    }
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    IOUtil.closeStream(out);
                    throw throwable;
                }
                {
                    Object var5_8 = null;
                    IOUtil.closeStream(out);
                    break block7;
                }
            }
            log.debug((Object)"Not saving preferences because no preferences directory is available.");
        }
        System.exit(0);
    }

    public int getContainerCount() {
        return containers.size();
    }

    public SshToolsApplicationContainer getContainerAt(int idx) {
        return (SshToolsApplicationContainer)containers.elementAt(idx);
    }

    public SshToolsApplicationContainer getContainerForPanel(SshToolsApplicationPanel panel) {
        Iterator i = containers.iterator();
        while (i.hasNext()) {
            SshToolsApplicationContainer c = (SshToolsApplicationContainer)i.next();
            if (c.getApplicationPanel() != panel) continue;
            return c;
        }
        return null;
    }

    public void closeContainer(SshToolsApplicationContainer container) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Asking " + container + " if it can close"));
        }
        if (container.getApplicationPanel().canClose()) {
            Iterator i;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Closing");
                i = containers.iterator();
                while (i.hasNext()) {
                    log.debug((Object)(i.next() + " is currently open"));
                }
            }
            container.getApplicationPanel().close();
            container.closeContainer();
            containers.removeElement(container);
            if (containers.size() == 0) {
                this.exit();
            } else {
                log.debug((Object)"Not closing completely because there are containers still open");
                i = containers.iterator();
                while (i.hasNext()) {
                    log.debug((Object)(i.next() + " is still open"));
                }
            }
        }
    }

    public void showAbout(Component parent) {
        JPanel p = new JPanel(new GridBagLayout());
        p.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        GridBagConstraints gBC = new GridBagConstraints();
        gBC.anchor = 10;
        gBC.fill = 2;
        gBC.insets = new Insets(1, 1, 1, 1);
        JLabel a = new JLabel(this.getApplicationName());
        a.setFont(a.getFont().deriveFont(24.0f));
        UIUtil.jGridBagAdd(p, a, gBC, 0);
        JLabel v = new JLabel(ConfigurationLoader.getVersionString(this.getApplicationName(), this.getApplicationVersion()));
        v.setFont(v.getFont().deriveFont(10.0f));
        UIUtil.jGridBagAdd(p, v, gBC, 0);
        MultilineLabel x = new MultilineLabel(this.getAboutAuthors());
        x.setBorder(BorderFactory.createEmptyBorder(8, 0, 8, 0));
        x.setFont(x.getFont().deriveFont(12.0f));
        UIUtil.jGridBagAdd(p, x, gBC, 0);
        MultilineLabel c = new MultilineLabel(this.getAboutLicenseDetails());
        c.setFont(c.getFont().deriveFont(10.0f));
        UIUtil.jGridBagAdd(p, c, gBC, 0);
        JLabel h = new JLabel(this.getAboutURL());
        h.setForeground(Color.blue);
        h.setFont(new Font(h.getFont().getName(), 1, 10));
        h.setCursor(Cursor.getPredefinedCursor(12));
        h.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                try {
                    BrowserLauncher.openURL(SshToolsApplication.this.getAboutURL());
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        });
        UIUtil.jGridBagAdd(p, h, gBC, 0);
        JOptionPane.showMessageDialog(parent, p, "About", -1, this.getApplicationLargeIcon());
    }

    public SshToolsApplicationContainer newContainer() throws SshToolsApplicationException {
        SshToolsApplicationContainer container = null;
        try {
            container = (SshToolsApplicationContainer)this.defaultContainerClass.newInstance();
            this.newContainer(container);
            return container;
        }
        catch (Throwable t) {
            throw new SshToolsApplicationException(t);
        }
    }

    public void newContainer(SshToolsApplicationContainer container) throws SshToolsApplicationException {
        try {
            SshToolsApplicationPanel panel = (SshToolsApplicationPanel)this.panelClass.newInstance();
            panel.init(this);
            panel.rebuildActionComponents();
            panel.setAvailableActions();
            container.init(this, panel);
            panel.setContainer(container);
            if (!container.isContainerVisible()) {
                container.setContainerVisible(true);
            }
            containers.addElement(container);
        }
        catch (Throwable t) {
            throw new SshToolsApplicationException(t);
        }
    }

    public SshToolsApplicationContainer convertContainer(SshToolsApplicationContainer container, Class newContainerClass) throws SshToolsApplicationException {
        log.info((Object)("Converting container of class " + container.getClass().getName() + " to " + newContainerClass.getName()));
        int idx = containers.indexOf(container);
        if (idx == -1) {
            throw new SshToolsApplicationException("Container is not being manager by the application.");
        }
        SshToolsApplicationContainer newContainer = null;
        try {
            container.closeContainer();
            SshToolsApplicationPanel panel = container.getApplicationPanel();
            newContainer = (SshToolsApplicationContainer)newContainerClass.newInstance();
            newContainer.init(this, panel);
            panel.setContainer(newContainer);
            if (!newContainer.isContainerVisible()) {
                newContainer.setContainerVisible(true);
            }
            containers.setElementAt(newContainer, idx);
            return newContainer;
        }
        catch (Throwable t) {
            throw new SshToolsApplicationException(t);
        }
    }

    public void init(String[] args) throws SshToolsApplicationException {
        File f = this.getApplicationPreferencesDirectory();
        if (f != null) {
            PreferencesStore.init(new File(f, String.valueOf(this.getApplicationName()) + ".properties"));
            log.info((Object)("Preferences will be saved to " + f.getAbsolutePath()));
        } else {
            log.warn((Object)"No preferences can be saved.");
        }
        try {
            SshToolsApplication.setLookAndFeel(PreferencesStore.get(PREF_LAF, SYSTEM_LAF));
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.sshtools.common.ui.SshToolsApplication");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            UIManager.put("OptionPane.errorIcon", new ResourceIcon(clazz, "dialog-error4.png"));
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("com.sshtools.common.ui.SshToolsApplication");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            UIManager.put("OptionPane.informationIcon", new ResourceIcon(clazz2, "dialog-information.png"));
            Class<?> clazz3 = class$0;
            if (clazz3 == null) {
                try {
                    clazz3 = class$0 = Class.forName("com.sshtools.common.ui.SshToolsApplication");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            UIManager.put("OptionPane.warningIcon", new ResourceIcon(clazz3, "dialog-warning2.png"));
            Class<?> clazz4 = class$0;
            if (clazz4 == null) {
                try {
                    clazz4 = class$0 = Class.forName("com.sshtools.common.ui.SshToolsApplication");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            UIManager.put("OptionPane.questionIcon", new ResourceIcon(clazz4, "dialog-question3.png"));
        }
        catch (Throwable t) {
            log.error((Object)t);
        }
    }

    public static void setLookAndFeel(String className) throws Exception {
        LookAndFeel laf = null;
        if (!className.equals(DEFAULT_LAF)) {
            if (className.equals(SYSTEM_LAF)) {
                String systemLaf = UIManager.getSystemLookAndFeelClassName();
                log.debug((Object)("System Look And Feel is " + systemLaf));
                laf = (LookAndFeel)Class.forName(systemLaf).newInstance();
            } else if (className.equals(CROSS_PLATFORM_LAF)) {
                String crossPlatformLaf = UIManager.getCrossPlatformLookAndFeelClassName();
                log.debug((Object)("Cross Platform Look And Feel is " + crossPlatformLaf));
                laf = (LookAndFeel)Class.forName(crossPlatformLaf).newInstance();
            } else {
                laf = (LookAndFeel)Class.forName(className).newInstance();
            }
        }
        if (laf != null) {
            log.info((Object)("Setting look and feel " + laf.getName() + " (" + laf.getClass().getName() + ")"));
            UIManager.setLookAndFeel(laf);
            UIManager.put("EditorPane.font", UIManager.getFont("TextArea.font"));
        }
    }
}

