/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ui;

import com.sshtools.common.authentication.AuthenticationDialog;
import com.sshtools.common.authentication.BannerDialog;
import com.sshtools.common.authentication.KBIRequestHandlerDialog;
import com.sshtools.common.authentication.PasswordAuthenticationDialog;
import com.sshtools.common.authentication.PasswordChange;
import com.sshtools.common.authentication.PublicKeyAuthenticationPrompt;
import com.sshtools.common.automate.RemoteIdentification;
import com.sshtools.common.automate.RemoteIdentificationException;
import com.sshtools.common.automate.RemoteIdentificationFactory;
import com.sshtools.common.configuration.InvalidProfileFileException;
import com.sshtools.common.configuration.SshToolsConnectionProfile;
import com.sshtools.common.hosts.DialogKnownHostsKeyVerification;
import com.sshtools.common.ui.HostsTab;
import com.sshtools.common.ui.Option;
import com.sshtools.common.ui.OptionCallback;
import com.sshtools.common.ui.OptionsDialog;
import com.sshtools.common.ui.PreferencesStore;
import com.sshtools.common.ui.SshToolsApplication;
import com.sshtools.common.ui.SshToolsApplicationContainer;
import com.sshtools.common.ui.SshToolsApplicationException;
import com.sshtools.common.ui.SshToolsApplicationPanel;
import com.sshtools.common.ui.SshToolsConnectionPanel;
import com.sshtools.common.ui.SshToolsConnectionTab;
import com.sshtools.common.ui.StandardAction;
import com.sshtools.common.ui.UIUtil;
import com.sshtools.j2ssh.SshClient;
import com.sshtools.j2ssh.SshException;
import com.sshtools.j2ssh.SshThread;
import com.sshtools.j2ssh.agent.AgentAuthenticationClient;
import com.sshtools.j2ssh.agent.AgentNotAvailableException;
import com.sshtools.j2ssh.agent.SshAgentClient;
import com.sshtools.j2ssh.authentication.KBIAuthenticationClient;
import com.sshtools.j2ssh.authentication.PasswordAuthenticationClient;
import com.sshtools.j2ssh.authentication.PublicKeyAuthenticationClient;
import com.sshtools.j2ssh.authentication.SshAuthenticationClient;
import com.sshtools.j2ssh.authentication.SshAuthenticationClientFactory;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.transport.AbstractKnownHostsKeyVerification;
import com.sshtools.j2ssh.transport.HostKeyVerification;
import com.sshtools.j2ssh.transport.InvalidHostFileException;
import com.sshtools.j2ssh.transport.TransportProtocolException;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.security.AccessControlException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SshToolsApplicationClientPanel
extends SshToolsApplicationPanel {
    public static final String PREF_CONNECTION_FILE_DIRECTORY = "sshapps.connectionFile.directory";
    public static final int BANNER_TIMEOUT = 2000;
    protected static AbstractKnownHostsKeyVerification ver;
    protected Log log;
    protected HostKeyVerification hostKeyVerification;
    protected File currentConnectionFile;
    protected boolean needSave;
    protected SshToolsConnectionProfile currentConnectionProfile;
    protected FileFilter connectionFileFilter;
    protected SshClient ssh;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public SshToolsApplicationClientPanel() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.sshtools.common.ui.SshToolsApplicationClientPanel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = LogFactory.getLog((Class)clazz);
        this.connectionFileFilter = new ConnectionFileFilter();
    }

    public SshToolsApplicationClientPanel(LayoutManager mgr) {
        super(mgr);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.sshtools.common.ui.SshToolsApplicationClientPanel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = LogFactory.getLog((Class)clazz);
        this.connectionFileFilter = new ConnectionFileFilter();
    }

    public abstract SshToolsConnectionTab[] getAdditionalConnectionTabs();

    public HostKeyVerification getHostKeyVerification() {
        return this.hostKeyVerification;
    }

    public void setHostHostVerification(HostKeyVerification hostKeyVerification) {
        this.hostKeyVerification = hostKeyVerification;
    }

    public void init(SshToolsApplication application) throws SshToolsApplicationException {
        super.init(application);
        try {
            ver = new DialogKnownHostsKeyVerification(this);
            this.setHostHostVerification(ver);
            if (ver.isHostFileWriteable()) {
                application.addAdditionalOptionsTab(new HostsTab(ver));
            }
        }
        catch (InvalidHostFileException uhfe) {
            this.log.warn((Object)"Host key verification will be DISABLED.", (Throwable)uhfe);
        }
    }

    public void editConnection() {
        JFileChooser fileDialog = new JFileChooser(PreferencesStore.get(PREF_CONNECTION_FILE_DIRECTORY, System.getProperty("sshtools.home", System.getProperty("user.home"))));
        fileDialog.setFileFilter(this.connectionFileFilter);
        int ret = fileDialog.showOpenDialog(this);
        if (ret == 0) {
            PreferencesStore.put(PREF_CONNECTION_FILE_DIRECTORY, fileDialog.getCurrentDirectory().getAbsolutePath());
            File f = fileDialog.getSelectedFile();
            SshToolsConnectionProfile p = new SshToolsConnectionProfile();
            try {
                p.open(f);
                if (this.editConnection(p)) {
                    this.saveConnection(false, f, p);
                }
            }
            catch (IOException ioe) {
                SshToolsApplicationClientPanel.showErrorMessage(this, "Failed to load connection profile.", "Error", ioe);
            }
        }
    }

    public SshToolsConnectionProfile newConnectionProfile(SshToolsConnectionProfile profile) {
        return SshToolsConnectionPanel.showConnectionDialog(this, profile, this.getAdditionalConnectionTabs());
    }

    public void open() {
        String prefsDir = super.getApplication().getApplicationPreferencesDirectory().getAbsolutePath();
        JFileChooser fileDialog = new JFileChooser(prefsDir);
        fileDialog.setFileFilter(this.connectionFileFilter);
        int ret = fileDialog.showOpenDialog(this);
        if (ret == 0) {
            PreferencesStore.put(PREF_CONNECTION_FILE_DIRECTORY, fileDialog.getCurrentDirectory().getAbsolutePath());
            File f = fileDialog.getSelectedFile();
            this.open(f);
        }
    }

    public void open(File f) {
        this.log.debug((Object)("Opening connection file " + f));
        if (this.isConnected()) {
            Option optNew = new Option("New", "New create a new window", 110);
            Option optClose = new Option("Close", "Close current connection", 108);
            Option optCancel = new Option("Cancel", "Cancel the opening of this connection", 99);
            OptionsDialog dialog = OptionsDialog.createOptionDialog(this, new Option[]{optNew, optClose, optCancel}, "You already have a connection open. Select\nClose to close the current connection, New\nto create a new terminal or Cancel to abort.", "Existing connection", optNew, null, UIManager.getIcon("OptionPane.warningIcon"));
            UIUtil.positionComponent(0, dialog);
            dialog.setVisible(true);
            Option opt = dialog.getSelectedOption();
            if (opt == null || opt == optCancel) {
                return;
            }
            if (opt == optNew) {
                try {
                    SshToolsApplicationContainer c = this.application.newContainer();
                    ((SshToolsApplicationClientPanel)c.getApplicationPanel()).open(f);
                    return;
                }
                catch (SshToolsApplicationException stae) {
                    this.log.error((Object)stae);
                }
            } else {
                this.closeConnection(true);
            }
        }
        if (this.getApplication().getMRUModel() != null) {
            this.getApplication().getMRUModel().add(f);
        }
        if (f != null) {
            SshToolsConnectionProfile profile = new SshToolsConnectionProfile();
            try {
                profile.open(f.getAbsolutePath());
                this.setNeedSave(false);
                this.currentConnectionFile = f;
                this.setContainerTitle(f);
                this.connect(profile, false);
            }
            catch (InvalidProfileFileException fnfe) {
                this.showExceptionMessage(fnfe.getMessage(), "Open Connection");
            }
            catch (SshException e) {
                e.printStackTrace();
                this.showExceptionMessage("An unexpected error occured!", "Open Connection");
            }
        } else {
            this.showExceptionMessage("Invalid file specified", "Open Connection");
        }
    }

    public void connect(SshToolsConnectionProfile profile, final boolean newProfile) {
        this.ssh = new SshClient();
        this.setCurrentConnectionProfile(profile);
        Runnable r = new Runnable(){

            public void run() {
                SshToolsApplicationClientPanel.this.getStatusBar().setStatusText("Connecting");
                SshToolsApplicationClientPanel.this.getStatusBar().setHost(SshToolsApplicationClientPanel.this.getCurrentConnectionProfile().getHost(), SshToolsApplicationClientPanel.this.getCurrentConnectionProfile().getPort());
                SshToolsApplicationClientPanel.this.getStatusBar().setUser(SshToolsApplicationClientPanel.this.getCurrentConnectionProfile().getUsername());
                try {
                    SshToolsApplicationClientPanel.this.log.info((Object)("Connecting to " + SshToolsApplicationClientPanel.this.getCurrentConnectionProfile().getHost() + " as " + SshToolsApplicationClientPanel.this.getCurrentConnectionProfile().getUsername()));
                    SshToolsApplicationClientPanel.this.ssh.connect(SshToolsApplicationClientPanel.this.getCurrentConnectionProfile(), SshToolsApplicationClientPanel.this.getHostKeyVerification() == null ? new SinkHostKeyVerification() : SshToolsApplicationClientPanel.this.getHostKeyVerification());
                    try {
                        RemoteIdentification rid = RemoteIdentificationFactory.getInstance(SshToolsApplicationClientPanel.this.ssh.getServerId(), SshToolsApplicationClientPanel.this.ssh.getConnectionProperties().getHost());
                        SshToolsApplicationClientPanel.this.getStatusBar().setRemoteId(rid.getName(SshToolsApplicationClientPanel.this.ssh.getServerId()));
                    }
                    catch (RemoteIdentificationException ex) {
                        SshToolsApplicationClientPanel.this.getStatusBar().setRemoteId("Unknown");
                    }
                    if (SshToolsApplicationClientPanel.this.postConnection()) {
                        if (!SshToolsApplicationClientPanel.this.authenticateUser(newProfile)) {
                            SshToolsApplicationClientPanel.this.closeConnection(false);
                        } else {
                            SshToolsApplicationClientPanel.this.setAvailableActions();
                        }
                    }
                }
                catch (IOException sshe) {
                    SshToolsApplicationClientPanel.this.ssh = null;
                    SshToolsApplicationClientPanel.this.showExceptionMessage("Connection Error", "Could not establish a connection to host: \n\n " + sshe.getMessage());
                    SshToolsApplicationClientPanel.this.closeConnection(false);
                }
                catch (SecurityException se) {
                    SshToolsApplicationClientPanel.this.ssh = null;
                    SshToolsApplicationClientPanel.showErrorMessage(SshToolsApplicationClientPanel.this, "Error", se);
                    SshToolsApplicationClientPanel.this.closeConnection(false);
                }
            }
        };
        SshThread thread = new SshThread(r, String.valueOf(this.application.getApplicationName()) + " connection", true);
        thread.start();
    }

    public void connect(SshClient ssh, SshToolsConnectionProfile profile) throws IOException {
        this.ssh = ssh;
        if (!ssh.isAuthenticated()) {
            this.authenticateUser(false);
        }
        this.setCurrentConnectionProfile(profile);
        this.authenticationComplete(false);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean authenticateUser(boolean newProfile) throws IOException {
        int result = 1;
        boolean authenticated = false;
        List supported = SshAuthenticationClientFactory.getSupportedMethods();
        if (supported.contains("publickey") && System.getProperty("sshtools.agent") != null) {
            try {
                SshAgentClient agent = SshAgentClient.connectLocalAgent("SSHTerm", System.getProperty("sshtools.agent"));
                AgentAuthenticationClient aac = new AgentAuthenticationClient();
                aac.setAgent(agent);
                aac.setUsername(this.getCurrentConnectionProfile().getUsername());
                result = this.ssh.authenticate(aac);
                agent.close();
            }
            catch (AgentNotAvailableException ex) {
                this.log.info((Object)"No agent was available for authentication");
            }
            if (result == 4) {
                this.authenticationComplete(newProfile);
                return true;
            }
        }
        ArrayList display = new ArrayList();
        List auths = null;
        auths = this.ssh.getAvailableAuthMethods(this.getCurrentConnectionProfile().getUsername());
        final String banner = this.ssh.getAuthenticationBanner(2000);
        if (banner != null && !banner.trim().equals("")) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        BannerDialog.showBannerDialog(SshToolsApplicationClientPanel.this, banner);
                    }
                });
            }
            catch (Exception exception) {
                this.log.error((Object)"Failed to invoke and wait on BannerDialog", (Throwable)exception);
            }
        }
        Iterator iterator = supported.iterator();
        while (iterator.hasNext() && !authenticated) {
            Object obj = iterator.next();
            if (!auths.contains(obj)) continue;
            display.add(obj);
        }
        Map authMethods = (Map)((HashMap)this.getCurrentConnectionProfile().getAuthenticationMethods()).clone();
        Iterator iterator2 = authMethods.entrySet().iterator();
        boolean completed = false;
        String msg = null;
        while (!completed && this.ssh.getConnectionState().getValue() != 5) {
            void var8_12;
            SshAuthenticationClient auth = null;
            if (var8_12.hasNext()) {
                Object obj = var8_12.next();
                if (obj instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)obj;
                    auth = (SshAuthenticationClient)entry.getValue();
                } else {
                    if (!(obj instanceof String)) {
                        this.closeConnection(true);
                        throw new IOException("Iterator of Map or List of String expected");
                    }
                    auth = SshAuthenticationClientFactory.newInstance((String)obj);
                    auth.setUsername(this.getCurrentConnectionProfile().getUsername());
                }
            } else {
                List selected = AuthenticationDialog.showAuthenticationDialog(this, display, msg == null ? "" : msg);
                if (selected.size() <= 0) {
                    this.closeConnection(true);
                    return false;
                }
                Iterator iterator3 = selected.iterator();
            }
            if (auth == null) continue;
            result = this.showAuthenticationPrompt(auth);
            if (result == 2) {
                msg = String.valueOf(auth.getMethodName()) + " authentication failed, try again?";
            }
            if (result == 3) {
                this.getCurrentConnectionProfile().addAuthenticationMethod(auth);
                msg = String.valueOf(auth.getMethodName()) + " authentication succeeded but another is required";
            }
            if (result == 4) {
                authenticated = true;
                this.getCurrentConnectionProfile().addAuthenticationMethod(auth);
                completed = true;
                this.authenticationComplete(newProfile);
            }
            if (result != 5) continue;
            this.ssh.disconnect();
            return false;
        }
        return authenticated;
    }

    protected int showAuthenticationPrompt(SshAuthenticationClient instance) throws IOException {
        instance.setUsername(this.getCurrentConnectionProfile().getUsername());
        if (instance instanceof PasswordAuthenticationClient) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.awt.Frame");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            PasswordAuthenticationDialog dialog = new PasswordAuthenticationDialog((Frame)SwingUtilities.getAncestorOfClass(clazz, this));
            instance.setAuthenticationPrompt(dialog);
            ((PasswordAuthenticationClient)instance).setPasswordChangePrompt(PasswordChange.getInstance());
            PasswordChange.getInstance().setParentComponent(this);
        } else if (instance instanceof PublicKeyAuthenticationClient) {
            PublicKeyAuthenticationPrompt prompt = new PublicKeyAuthenticationPrompt(this);
            instance.setAuthenticationPrompt(prompt);
        } else if (instance instanceof KBIAuthenticationClient) {
            KBIAuthenticationClient kbi = new KBIAuthenticationClient();
            KBIAuthenticationClient kBIAuthenticationClient = (KBIAuthenticationClient)instance;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.awt.Frame");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            kBIAuthenticationClient.setKBIRequestHandler(new KBIRequestHandlerDialog((Frame)SwingUtilities.getAncestorOfClass(clazz, this)));
        }
        return this.ssh.authenticate(instance);
    }

    public abstract boolean postConnection();

    public abstract void authenticationComplete(boolean var1) throws SshException, IOException;

    public void setContainerTitle(File file) {
        String verString = ConfigurationLoader.getVersionString(this.application.getApplicationName(), this.application.getApplicationVersion());
        if (this.container != null) {
            this.container.setContainerTitle(file == null ? verString : String.valueOf(verString) + " [" + file.getName() + "]");
        }
    }

    public void setNeedSave(boolean needSave) {
        if (needSave != this.needSave) {
            this.needSave = needSave;
            this.setAvailableActions();
        }
    }

    public void setCurrentConnectionFile(File file) {
        this.currentConnectionFile = file;
    }

    public File getCurrentConnectionFile() {
        return this.currentConnectionFile;
    }

    public void setCurrentConnectionProfile(SshToolsConnectionProfile profile) {
        this.currentConnectionProfile = profile;
    }

    public SshToolsConnectionProfile getCurrentConnectionProfile() {
        return this.currentConnectionProfile;
    }

    public boolean isNeedSave() {
        return this.needSave;
    }

    public boolean isConnected() {
        return this.ssh != null && this.ssh.isConnected();
    }

    public void connect() throws SshException {
        if (this.getCurrentConnectionProfile() == null) {
            throw new SshException("Can't connect, no connection profile have been set.");
        }
        this.connect(this.getCurrentConnectionProfile(), false);
    }

    public void closeConnection(boolean disconnect) {
        if (this.isNeedSave()) {
            try {
                if (System.getSecurityManager() != null) {
                    AccessController.checkPermission(new FilePermission("<<ALL FILES>>", "write"));
                    if (JOptionPane.showConfirmDialog(this, "You have unsaved changes to the connection " + (this.currentConnectionFile == null ? "<Untitled>" : this.currentConnectionFile.getName()) + ".\nDo you want to save the changes now?", "Unsaved changes", 0, 3) == 0) {
                        this.saveConnection(false, this.getCurrentConnectionFile(), this.getCurrentConnectionProfile());
                        this.setNeedSave(false);
                    }
                }
            }
            catch (AccessControlException ace) {
                this.log.warn((Object)"Changes made to connection, but security manager won't allow saving of files.");
            }
        }
        this.setCurrentConnectionFile(null);
    }

    protected boolean allowConnectionSettingsEditing() {
        return true;
    }

    public boolean editConnection(SshToolsConnectionProfile profile) {
        final SshToolsConnectionPanel panel = new SshToolsConnectionPanel(this.allowConnectionSettingsEditing());
        SshToolsConnectionTab[] tabs = this.getAdditionalConnectionTabs();
        int i = 0;
        while (tabs != null && i < tabs.length) {
            tabs[i].setConnectionProfile(profile);
            panel.addTab(tabs[i]);
            ++i;
        }
        panel.setConnectionProfile(profile);
        final Option ok = new Option("Ok", "Apply the settings and close this dialog", 111);
        Option cancel = new Option("Cancel", "Close this dialog without applying the settings", 99);
        OptionCallback callback = new OptionCallback(){

            public boolean canClose(OptionsDialog dialog, Option option) {
                if (option == ok) {
                    return panel.validateTabs();
                }
                return true;
            }
        };
        OptionsDialog od = OptionsDialog.createOptionDialog(this, new Option[]{ok, cancel}, panel, "Connection Settings", ok, callback, null);
        od.pack();
        UIUtil.positionComponent(0, od);
        od.setVisible(true);
        if (od.getSelectedOption() == ok) {
            panel.applyTabs();
            if (profile == this.getCurrentConnectionProfile()) {
                this.setNeedSave(true);
            }
            return true;
        }
        return false;
    }

    public File saveConnection(boolean saveAs, File file, SshToolsConnectionProfile profile) {
        if (profile != null) {
            if (file == null || saveAs) {
                String prefsDir = super.getApplication().getApplicationPreferencesDirectory().getAbsolutePath();
                JFileChooser fileDialog = new JFileChooser(prefsDir);
                fileDialog.setFileFilter(this.connectionFileFilter);
                int ret = fileDialog.showSaveDialog(this);
                if (ret == 1) {
                    return null;
                }
                file = fileDialog.getSelectedFile();
                if (!file.getName().toLowerCase().endsWith(".xml")) {
                    file = new File(String.valueOf(file.getAbsolutePath()) + ".xml");
                }
            }
            try {
                if (saveAs && file.exists() && JOptionPane.showConfirmDialog(this, "File already exists. Are you sure?", "File exists", 0, 2) == 1) {
                    return null;
                }
                if (file != null) {
                    this.log.debug((Object)("Saving connection to " + file.getAbsolutePath()));
                    profile.save(file.getAbsolutePath());
                    if (profile == this.getCurrentConnectionProfile()) {
                        this.log.debug((Object)"Current connection saved, disabling save action.");
                        this.setNeedSave(false);
                    }
                    return file;
                }
                this.showExceptionMessage("The file specified is invalid!", "Save Connection");
            }
            catch (InvalidProfileFileException e) {
                this.showExceptionMessage(e.getMessage(), "Save Connection");
            }
        }
        return null;
    }

    public static class ActionMenu
    implements Comparable {
        int weight;
        int mnemonic;
        String name;
        String displayName;

        public ActionMenu(String name, String displayName, int mnemonic, int weight) {
            this.name = name;
            this.displayName = displayName;
            this.mnemonic = mnemonic;
            this.weight = weight;
        }

        public int compareTo(Object o) {
            int i = new Integer(this.weight).compareTo(new Integer(((ActionMenu)o).weight));
            return i == 0 ? this.displayName.compareTo(((ActionMenu)o).displayName) : i;
        }
    }

    class ToolBarActionComparator
    implements Comparator {
        ToolBarActionComparator() {
        }

        public int compare(Object o1, Object o2) {
            int i = ((Integer)((StandardAction)o1).getValue("toolBarGroup")).compareTo((Integer)((StandardAction)o2).getValue("toolBarGroup"));
            return i == 0 ? ((Integer)((StandardAction)o1).getValue("toolBarWeight")).compareTo((Integer)((StandardAction)o2).getValue("toolBarWeight")) : i;
        }
    }

    class MenuItemActionComparator
    implements Comparator {
        MenuItemActionComparator() {
        }

        public int compare(Object o1, Object o2) {
            int i = ((Integer)((StandardAction)o1).getValue("menuItemGroup")).compareTo((Integer)((StandardAction)o2).getValue("menuItemGroup"));
            return i == 0 ? ((Integer)((StandardAction)o1).getValue("menuItemWeight")).compareTo((Integer)((StandardAction)o2).getValue("menuItemWeight")) : i;
        }
    }

    class ConnectionFileFilter
    extends FileFilter {
        ConnectionFileFilter() {
        }

        public boolean accept(File f) {
            return f.isDirectory() || f.getName().toLowerCase().endsWith(".xml");
        }

        public String getDescription() {
            return "Connection files (*.xml)";
        }
    }

    class SinkHostKeyVerification
    implements HostKeyVerification {
        SinkHostKeyVerification() {
        }

        public boolean verifyHost(String host, SshPublicKey pk) throws TransportProtocolException {
            SshToolsApplicationClientPanel.this.log.warn((Object)("Accepting host " + host + " as host key verification is disabled."));
            return true;
        }
    }
}

