/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ui;

import com.sshtools.common.ui.MenuAction;
import com.sshtools.common.ui.MultilineLabel;
import com.sshtools.common.ui.OptionsAction;
import com.sshtools.common.ui.OptionsPanel;
import com.sshtools.common.ui.OptionsTab;
import com.sshtools.common.ui.PreferencesStore;
import com.sshtools.common.ui.ResourceIcon;
import com.sshtools.common.ui.SshToolsApplication;
import com.sshtools.common.ui.SshToolsApplicationContainer;
import com.sshtools.common.ui.SshToolsApplicationException;
import com.sshtools.common.ui.StandardAction;
import com.sshtools.common.ui.StatusBar;
import com.sshtools.common.ui.ToolBarSeparator;
import com.sshtools.common.ui.ToolButton;
import com.sshtools.common.ui.ToolToggleButton;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SshToolsApplicationPanel
extends JPanel {
    protected Log log;
    protected SshToolsApplication application;
    protected JMenuBar menuBar;
    protected JToolBar toolBar;
    protected JPopupMenu contextMenu;
    protected SshToolsApplicationContainer container;
    protected Vector actions;
    protected HashMap actionsVisible;
    protected boolean toolsVisible;
    protected Vector actionMenus;
    static /* synthetic */ Class class$0;

    public SshToolsApplicationPanel() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.sshtools.common.ui.SshToolsApplicationPanel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = LogFactory.getLog((Class)clazz);
        this.actions = new Vector();
        this.actionsVisible = new HashMap();
        this.actionMenus = new Vector();
    }

    public SshToolsApplicationPanel(LayoutManager mgr) {
        super(mgr);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.sshtools.common.ui.SshToolsApplicationPanel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = LogFactory.getLog((Class)clazz);
        this.actions = new Vector();
        this.actionsVisible = new HashMap();
        this.actionMenus = new Vector();
    }

    public abstract boolean canClose();

    public abstract void close();

    public abstract void setAvailableActions();

    public void setActionVisible(String name, boolean visible) {
        this.log.debug((Object)("Setting action '" + name + "' to visibility " + visible));
        this.actionsVisible.put(name, new Boolean(visible));
    }

    public SshToolsApplicationContainer getContainer() {
        return this.container;
    }

    public void setContainer(SshToolsApplicationContainer container) {
        this.container = container;
    }

    public void registerActionMenu(ActionMenu actionMenu) {
        ActionMenu current = this.getActionMenu(actionMenu.name);
        if (current == null) {
            this.actionMenus.addElement(actionMenu);
        }
    }

    public ActionMenu getActionMenu(String actionMenuName) {
        return this.getActionMenu(this.actionMenus.iterator(), actionMenuName);
    }

    private ActionMenu getActionMenu(Iterator actions, String actionMenuName) {
        while (actions.hasNext()) {
            ActionMenu a = (ActionMenu)actions.next();
            if (!a.name.equals(actionMenuName)) continue;
            return a;
        }
        return null;
    }

    public StandardAction getAction(String name) {
        Iterator i = this.actions.iterator();
        while (i.hasNext()) {
            StandardAction a = (StandardAction)i.next();
            if (!a.getName().equals(name)) continue;
            return a;
        }
        return null;
    }

    public void deregisterAction(StandardAction action) {
        this.actions.removeElement(action);
    }

    public void registerAction(StandardAction action) {
        this.actions.addElement(action);
    }

    public void init(SshToolsApplication application) throws SshToolsApplicationException {
        this.application = application;
        this.menuBar = new JMenuBar();
        this.toolBar = new JToolBar();
        this.toolBar.setFloatable(false);
        this.toolBar.setBorderPainted(false);
        this.toolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.contextMenu = new JPopupMenu();
        this.registerActionMenu(new ActionMenu("Tools", "Tools", 116, 30));
        if (PreferencesStore.isStoreAvailable()) {
            this.log.debug((Object)"Preferences store is available, adding options action");
            this.registerAction(new OptionsAction(){

                public void actionPerformed(ActionEvent evt) {
                    SshToolsApplicationPanel.this.showOptions();
                }
            });
        }
    }

    public void showOptions() {
        OptionsTab[] tabs = this.getApplication().getAdditionalOptionsTabs();
        OptionsPanel.showOptionsDialog(this, tabs);
    }

    public void rebuildActionComponents() {
        StandardAction a;
        this.log.debug((Object)"Rebuild action components");
        this.toolBar.removeAll();
        Vector<StandardAction> enabledActions = new Vector<StandardAction>();
        Iterator i = this.actions.iterator();
        while (i.hasNext()) {
            StandardAction a2 = (StandardAction)i.next();
            String n = (String)a2.getValue("Name");
            Boolean s = (Boolean)this.actionsVisible.get(n);
            if (s == null) {
                s = Boolean.TRUE;
            }
            if (Boolean.TRUE.equals(s)) {
                this.log.debug((Object)("Action " + n + " is enabled."));
                enabledActions.add(a2);
                continue;
            }
            this.log.debug((Object)("Action " + n + " not enabled."));
        }
        Vector<StandardAction> v = new Vector<StandardAction>();
        Iterator i2 = enabledActions.iterator();
        while (i2.hasNext()) {
            StandardAction a3 = (StandardAction)i2.next();
            if (!Boolean.TRUE.equals((Boolean)a3.getValue("onToolBar"))) continue;
            v.addElement(a3);
        }
        Collections.sort(v, new ToolBarActionComparator());
        Integer grp = null;
        Iterator i3 = v.iterator();
        while (i3.hasNext()) {
            StandardAction z = (StandardAction)i3.next();
            if (grp != null && !grp.equals((Integer)z.getValue("toolBarGroup"))) {
                this.toolBar.add(new ToolBarSeparator());
            }
            if (Boolean.TRUE.equals((Boolean)z.getValue("isToggleButton"))) {
                ToolToggleButton tBtn = new ToolToggleButton(z);
                this.toolBar.add(tBtn);
            } else {
                ToolButton btn = new ToolButton(z);
                this.toolBar.add(btn);
            }
            grp = (Integer)z.getValue("toolBarGroup");
        }
        this.toolBar.revalidate();
        this.toolBar.repaint();
        Vector<StandardAction> c = new Vector<StandardAction>();
        this.contextMenu.removeAll();
        Iterator i4 = enabledActions.iterator();
        while (i4.hasNext()) {
            a = (StandardAction)i4.next();
            if (!Boolean.TRUE.equals((Boolean)a.getValue("onContextMenu"))) continue;
            c.addElement(a);
        }
        Collections.sort(c, new ContextActionComparator());
        grp = null;
        i4 = c.iterator();
        while (i4.hasNext()) {
            StandardAction z = (StandardAction)i4.next();
            if (grp != null && !grp.equals((Integer)z.getValue("contextMenuGroup"))) {
                this.contextMenu.addSeparator();
            }
            this.contextMenu.add(z);
            grp = (Integer)z.getValue("contextMenuGroup");
        }
        this.contextMenu.revalidate();
        this.menuBar.removeAll();
        v.removeAllElements();
        Enumeration e = enabledActions.elements();
        while (e.hasMoreElements()) {
            a = (StandardAction)e.nextElement();
            if (!Boolean.TRUE.equals((Boolean)a.getValue("onMenuBar"))) continue;
            v.addElement(a);
        }
        Vector menus = (Vector)this.actionMenus.clone();
        Collections.sort(menus);
        HashMap<String, Vector<StandardAction>> map = new HashMap<String, Vector<StandardAction>>();
        Iterator i5 = v.iterator();
        while (i5.hasNext()) {
            StandardAction z = (StandardAction)i5.next();
            String menuName = (String)z.getValue("menuName");
            if (menuName == null) {
                this.log.error((Object)("Action " + z.getName() + " doesnt specify a value for " + "menuName"));
                continue;
            }
            String m = (String)z.getValue("menuName");
            ActionMenu menu = this.getActionMenu(menus.iterator(), m);
            if (menu == null) {
                this.log.error((Object)("Action menu " + z.getName() + " does not exist"));
                continue;
            }
            Vector<StandardAction> x = (Vector<StandardAction>)map.get(menu.name);
            if (x == null) {
                x = new Vector<StandardAction>();
                map.put(menu.name, x);
            }
            x.addElement(z);
        }
        i5 = menus.iterator();
        while (i5.hasNext()) {
            ActionMenu m = (ActionMenu)i5.next();
            Vector x = (Vector)map.get(m.name);
            if (x != null) {
                Collections.sort(x, new MenuItemActionComparator());
                JMenu menu = new JMenu(m.displayName);
                menu.setMnemonic(m.mnemonic);
                grp = null;
                Iterator j = x.iterator();
                while (j.hasNext()) {
                    StandardAction a4 = (StandardAction)j.next();
                    Integer g = (Integer)a4.getValue("menuItemGroup");
                    if (grp != null && !g.equals(grp)) {
                        menu.addSeparator();
                    }
                    grp = g;
                    if (a4 instanceof MenuAction) {
                        JMenu mnu = (JMenu)a4.getValue("menu");
                        menu.add(mnu);
                        continue;
                    }
                    JMenuItem item = new JMenuItem(a4);
                    menu.add(item);
                }
                this.menuBar.add(menu);
                continue;
            }
            this.log.error((Object)("Can't find menu " + m.name));
        }
        this.menuBar.validate();
        this.menuBar.repaint();
    }

    public boolean isToolsVisible() {
        return this.toolsVisible;
    }

    public void addFavorite(StandardAction action) {
        int i = 0;
        while (i < this.menuBar.getMenuCount()) {
            JMenu menu = this.menuBar.getMenu(i);
            if (menu.getText() != null && menu.getText().equals("Favorites")) {
                menu.add(action);
            }
            ++i;
        }
    }

    public void setMenuBarVisible(boolean visible) {
        if (this.getJMenuBar() != null && this.getJMenuBar().isVisible() != visible) {
            this.getJMenuBar().setVisible(visible);
            this.revalidate();
        }
    }

    public void setToolBarVisible(boolean visible) {
        if (this.getToolBar() != null && this.getToolBar().isVisible() != visible) {
            this.getToolBar().setVisible(visible);
            this.revalidate();
        }
    }

    public void setStatusBarVisible(boolean visible) {
        if (this.getStatusBar() != null && this.getStatusBar().isVisible() != visible) {
            this.getStatusBar().setVisible(visible);
            this.revalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setToolsVisible(boolean visible) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.getToolBar() != null && this.getToolBar().isVisible() != visible) {
                this.getToolBar().setVisible(visible);
            }
            if (this.getJMenuBar() != null && this.getJMenuBar().isVisible() != visible) {
                this.getJMenuBar().setVisible(visible);
            }
            if (this.getStatusBar() != null && this.getStatusBar().isVisible() != visible) {
                this.getStatusBar().setVisible(visible);
            }
            this.toolsVisible = visible;
            this.revalidate();
        }
    }

    public void showExceptionMessage(String title, String message) {
        JOptionPane.showMessageDialog(this, message, title, 0);
    }

    public static void showErrorMessage(Component parent, String title, Throwable exception) {
        SshToolsApplicationPanel.showErrorMessage(parent, null, title, exception);
    }

    public static void showErrorMessage(Component parent, String mesg, String title, Throwable exception) {
        boolean details = false;
        while (true) {
            Object[] opts = new String[]{details ? "Hide Details" : "Details", "Ok"};
            StringBuffer buf = new StringBuffer();
            if (mesg != null) {
                buf.append(mesg);
            }
            SshToolsApplicationPanel.appendException(exception, 0, buf, details);
            MultilineLabel message = new MultilineLabel(buf.toString());
            int opt = JOptionPane.showOptionDialog(parent, message, title, 2, 0, null, opts, opts[1]);
            if (opt != 0) break;
            details = !details;
        }
    }

    private static void appendException(Throwable exception, int level, StringBuffer buf, boolean details) {
        try {
            if (exception != null && exception.getMessage() != null && exception.getMessage().length() > 0) {
                if (details && level > 0) {
                    buf.append("\n \nCaused by ...\n");
                }
                buf.append(exception.getMessage());
            }
            if (details) {
                if (exception != null) {
                    if (exception.getMessage() != null && exception.getMessage().length() == 0) {
                        buf.append("\n \nCaused by ...");
                    } else {
                        buf.append("\n \n");
                    }
                }
                StringWriter sw = new StringWriter();
                if (exception != null) {
                    exception.printStackTrace(new PrintWriter(sw));
                }
                buf.append(sw.toString());
            }
            try {
                Method method = exception.getClass().getMethod("getCause", new Class[0]);
                Throwable cause = (Throwable)method.invoke((Object)exception, null);
                if (cause != null) {
                    SshToolsApplicationPanel.appendException(cause, level + 1, buf, details);
                }
            }
            catch (Exception exception2) {}
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public abstract boolean isConnected();

    public void setContainerTitle(File file) {
        String verString = "";
        if (this.application != null) {
            verString = ConfigurationLoader.getVersionString(this.application.getApplicationName(), this.application.getApplicationVersion());
        }
        if (this.container != null) {
            this.container.setContainerTitle(file == null ? verString : String.valueOf(verString) + " [" + file.getName() + "]");
        }
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    public JPopupMenu getContextMenu() {
        return this.contextMenu;
    }

    public JMenuBar getJMenuBar() {
        return this.menuBar;
    }

    public StatusBar getStatusBar() {
        return null;
    }

    public SshToolsApplication getApplication() {
        return this.application;
    }

    public abstract ResourceIcon getIcon();

    public static class ActionMenu
    implements Comparable {
        int weight;
        int mnemonic;
        String name;
        String displayName;

        public ActionMenu(String name, String displayName, int mnemonic, int weight) {
            this.name = name;
            this.displayName = displayName;
            this.mnemonic = mnemonic;
            this.weight = weight;
        }

        public int compareTo(Object o) {
            int i = new Integer(this.weight).compareTo(new Integer(((ActionMenu)o).weight));
            return i == 0 ? this.displayName.compareTo(((ActionMenu)o).displayName) : i;
        }
    }

    class ToolBarActionComparator
    implements Comparator {
        ToolBarActionComparator() {
        }

        public int compare(Object o1, Object o2) {
            int i = ((Integer)((StandardAction)o1).getValue("toolBarGroup")).compareTo((Integer)((StandardAction)o2).getValue("toolBarGroup"));
            return i == 0 ? ((Integer)((StandardAction)o1).getValue("toolBarWeight")).compareTo((Integer)((StandardAction)o2).getValue("toolBarWeight")) : i;
        }
    }

    class ContextActionComparator
    implements Comparator {
        ContextActionComparator() {
        }

        public int compare(Object o1, Object o2) {
            int i = ((Integer)((StandardAction)o1).getValue("contextMenuGroup")).compareTo((Integer)((StandardAction)o2).getValue("contextMenuGroup"));
            return i == 0 ? ((Integer)((StandardAction)o1).getValue("contextMenuWeight")).compareTo((Integer)((StandardAction)o2).getValue("contextMenuWeight")) : i;
        }
    }

    class MenuItemActionComparator
    implements Comparator {
        MenuItemActionComparator() {
        }

        public int compare(Object o1, Object o2) {
            int i = ((Integer)((StandardAction)o1).getValue("menuItemGroup")).compareTo((Integer)((StandardAction)o2).getValue("menuItemGroup"));
            return i == 0 ? ((Integer)((StandardAction)o1).getValue("menuItemWeight")).compareTo((Integer)((StandardAction)o2).getValue("menuItemWeight")) : i;
        }
    }

    class ConnectionFileFilter
    extends FileFilter {
        ConnectionFileFilter() {
        }

        public boolean accept(File f) {
            return f.isDirectory() || f.getName().toLowerCase().endsWith(".xml");
        }

        public String getDescription() {
            return "Connection files (*.xml)";
        }
    }
}

