/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ui;

import com.sshtools.common.configuration.SshToolsConnectionProfile;
import com.sshtools.common.ui.PreferencesStore;
import com.sshtools.common.ui.SshToolsConnectionHostTab;
import com.sshtools.common.ui.SshToolsConnectionPanel;
import com.sshtools.common.ui.SshToolsConnectionProtocolTab;
import com.sshtools.common.ui.SshToolsConnectionProxyTab;
import com.sshtools.common.ui.SshToolsConnectionTab;
import com.sshtools.common.ui.Tabber;
import com.sshtools.common.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshToolsConnectionPanel
extends JPanel {
    static final String DEFAULT = "<Default>";
    static final int DEFAULT_PORT = 22;
    protected Log log;
    private Tabber tabber;
    private SshToolsConnectionProfile profile;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public SshToolsConnectionPanel(boolean showConnectionTabs) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.sshtools.common.ui.SshToolsConnectionPanel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = LogFactory.getLog((Class)clazz);
        this.tabber = new Tabber();
        if (showConnectionTabs) {
            this.addTab(new SshToolsConnectionHostTab());
            this.addTab(new SshToolsConnectionProtocolTab());
            this.addTab(new SshToolsConnectionProxyTab());
        }
        this.setLayout(new GridLayout(1, 1));
        this.add(this.tabber);
    }

    public boolean validateTabs() {
        return this.tabber.validateTabs();
    }

    public void applyTabs() {
        this.tabber.applyTabs();
    }

    public void addTab(SshToolsConnectionTab tab) {
        this.tabber.addTab(tab);
    }

    public void setConnectionProfile(SshToolsConnectionProfile profile) {
        this.profile = profile;
        int i = 0;
        while (i < this.tabber.getTabCount()) {
            ((SshToolsConnectionTab)this.tabber.getTabAt(i)).setConnectionProfile(profile);
            ++i;
        }
    }

    public static SshToolsConnectionProfile showConnectionDialog(Component parent, SshToolsConnectionTab[] optionalTabs) {
        return SshToolsConnectionPanel.showConnectionDialog(parent, null, optionalTabs);
    }

    public static SshToolsConnectionProfile showConnectionDialog(Component parent, SshToolsConnectionProfile profile, SshToolsConnectionTab[] optionalTabs) {
        Window w;
        if (profile == null) {
            profile = new SshToolsConnectionProfile();
            profile.setHost(PreferencesStore.get("apps.connection.lastHost", ""));
            profile.setPort(PreferencesStore.getInt("apps.connection.lastPort", 22));
            profile.setUsername(PreferencesStore.get("apps.connection.lastUser", ""));
        }
        SshToolsConnectionPanel conx = new SshToolsConnectionPanel(true);
        if (optionalTabs != null) {
            int i = 0;
            while (i < optionalTabs.length) {
                conx.addTab(optionalTabs[i]);
                ++i;
            }
        }
        conx.setConnectionProfile(profile);
        JDialog d = null;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.awt.Window");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        d = (w = (Window)SwingUtilities.getAncestorOfClass(clazz, parent)) instanceof JDialog ? new JDialog((JDialog)w, "Connection Profile", true) : (w instanceof JFrame ? new JDialog((JFrame)w, "Connection Profile", true) : new JDialog(null, "Connection Profile", true));
        final JDialog dialog = d;
        class UserAction {
            boolean connect;

            UserAction() {
            }
        }
        final UserAction userAction = new UserAction();
        JButton cancel = new JButton("Cancel");
        cancel.setMnemonic('c');
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                dialog.setVisible(false);
            }
        });
        JButton connect = new JButton("Connect");
        connect.setMnemonic('t');
        connect.addActionListener(new ActionListener(){
            {
            }

            public void actionPerformed(ActionEvent evt) {
                if (SshToolsConnectionPanel.this.validateTabs()) {
                    userAction.connect = true;
                    dialog.setVisible(false);
                }
            }
        });
        dialog.getRootPane().setDefaultButton(connect);
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 10;
        gbc.insets = new Insets(6, 6, 0, 0);
        gbc.weighty = 1.0;
        UIUtil.jGridBagAdd(buttonPanel, connect, gbc, -1);
        UIUtil.jGridBagAdd(buttonPanel, cancel, gbc, 0);
        JPanel southPanel = new JPanel(new FlowLayout(2, 0, 0));
        southPanel.add(buttonPanel);
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        mainPanel.add((Component)conx, "Center");
        mainPanel.add((Component)southPanel, "South");
        dialog.getContentPane().setLayout(new GridLayout(1, 1));
        dialog.getContentPane().add(mainPanel);
        dialog.pack();
        dialog.setResizable(false);
        UIUtil.positionComponent(0, dialog);
        dialog.setVisible(true);
        if (!userAction.connect) {
            return null;
        }
        conx.applyTabs();
        PreferencesStore.put("apps.connection.lastHost", profile.getHost());
        PreferencesStore.put("apps.connection.lastUser", profile.getUsername());
        PreferencesStore.putInt("apps.connection.lastPort", profile.getPort());
        return profile;
    }
}

