/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ui;

import com.sshtools.common.ui.EmptyIcon;
import com.sshtools.common.ui.ResourceIcon;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;

public class XTextField
extends JTextField
implements ClipboardOwner {
    private JPopupMenu popup;
    private Action cutAction;
    private Action copyAction;
    private Action pasteAction;
    private Action deleteAction;
    private Action selectAllAction;

    public XTextField() {
        this(null, null, 0);
    }

    public XTextField(String text) {
        this(null, text, 0);
    }

    public XTextField(int columns) {
        this(null, null, columns);
    }

    public XTextField(String text, int columns) {
        this(null, text, columns);
    }

    public XTextField(Document doc, String text, int columns) {
        super(doc, text, columns);
        this.initXtensions();
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    private void showPopup(int x, int y) {
        this.requestFocus();
        if (this.popup == null) {
            this.popup = new JPopupMenu("Clipboard");
            this.cutAction = new CutAction();
            this.popup.add(this.cutAction);
            this.copyAction = new CopyAction();
            this.popup.add(this.copyAction);
            this.pasteAction = new PasteAction();
            this.popup.add(this.pasteAction);
            this.deleteAction = new DeleteAction();
            this.popup.add(this.deleteAction);
            this.popup.addSeparator();
            this.selectAllAction = new SelectAllAction();
            this.popup.add(this.selectAllAction);
        }
        this.cutAction.setEnabled(this.isEnabled() && this.getSelectedText() != null);
        this.copyAction.setEnabled(this.isEnabled() && this.getSelectedText() != null);
        this.deleteAction.setEnabled(this.isEnabled() && this.getSelectedText() != null);
        this.pasteAction.setEnabled(this.isEnabled() && Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this).isDataFlavorSupported(DataFlavor.stringFlavor));
        this.selectAllAction.setEnabled(this.isEnabled());
        this.popup.show(this, x, y);
    }

    private void initXtensions() {
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                if (SwingUtilities.isRightMouseButton(evt)) {
                    XTextField.this.showPopup(evt.getX(), evt.getY());
                }
            }
        });
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent evt) {
                XTextField.this.selectAll();
            }

            public void focusLost(FocusEvent evt) {
            }
        });
    }

    class CopyAction
    extends AbstractAction {
        static /* synthetic */ Class class$0;

        public CopyAction() {
            this.putValue("Name", "Copy");
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.sshtools.common.ui.XTextField");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.putValue("SmallIcon", new ResourceIcon(clazz, "copy.png"));
            this.putValue("ShortDescription", "Copy");
            this.putValue("LongDescription", "Copy the selection from the text and place it in the clipboard");
            this.putValue("MnemonicKey", new Integer(99));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, 2));
        }

        public void actionPerformed(ActionEvent evt) {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(XTextField.this.getText()), XTextField.this);
        }
    }

    class CutAction
    extends AbstractAction {
        static /* synthetic */ Class class$0;

        public CutAction() {
            this.putValue("Name", "Cut");
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.sshtools.common.ui.XTextField");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.putValue("SmallIcon", new ResourceIcon(clazz, "cut.png"));
            this.putValue("ShortDescription", "Cut selection");
            this.putValue("LongDescription", "Cut the selection from the text and place it in the clipboard");
            this.putValue("MnemonicKey", new Integer(117));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(88, 2));
        }

        public void actionPerformed(ActionEvent evt) {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(XTextField.this.getText()), XTextField.this);
            XTextField.this.setText("");
        }
    }

    class PasteAction
    extends AbstractAction {
        static /* synthetic */ Class class$0;

        public PasteAction() {
            this.putValue("Name", "Paste");
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.sshtools.common.ui.XTextField");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.putValue("SmallIcon", new ResourceIcon(clazz, "paste.png"));
            this.putValue("ShortDescription", "Paste clipboard content");
            this.putValue("LongDescription", "Paste the clipboard contents to the current care position or replace the selection");
            this.putValue("MnemonicKey", new Integer(112));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(88, 2));
        }

        public void actionPerformed(ActionEvent evt) {
            Transferable t = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this);
            if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                try {
                    XTextField.this.setText(t.getTransferData(DataFlavor.stringFlavor).toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    class DeleteAction
    extends AbstractAction {
        static /* synthetic */ Class class$0;

        public DeleteAction() {
            this.putValue("Name", "Delete");
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.sshtools.common.ui.XTextField");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.putValue("SmallIcon", new ResourceIcon(clazz, "delete.png"));
            this.putValue("ShortDescription", "Delete selection");
            this.putValue("LongDescription", "Delete the selection from the text");
            this.putValue("MnemonicKey", new Integer(100));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(88, 2));
        }

        public void actionPerformed(ActionEvent evt) {
            XTextField.this.setText("");
        }
    }

    class SelectAllAction
    extends AbstractAction {
        SelectAllAction() {
            this.putValue("SmallIcon", new EmptyIcon(16, 16));
            this.putValue("Name", "Select All");
            this.putValue("ShortDescription", "Select All");
            this.putValue("LongDescription", "Select all items in the context");
            this.putValue("MnemonicKey", new Integer(97));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(65, 2));
        }

        public void actionPerformed(ActionEvent evt) {
            XTextField.this.selectAll();
        }
    }
}

