/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.daemon;

import com.sshtools.common.configuration.XmlConfigurationContext;
import com.sshtools.daemon.SshServer;
import com.sshtools.daemon.configuration.ServerConfiguration;
import com.sshtools.daemon.configuration.XmlServerConfigurationContext;
import com.sshtools.daemon.forwarding.ForwardingServer;
import com.sshtools.daemon.session.SessionChannelFactory;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.connection.ConnectionProtocol;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshDaemon {
    private static Log log;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.sshtools.daemon.SshDaemon");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public static void main(String[] args) {
        try {
            XmlServerConfigurationContext context = new XmlServerConfigurationContext();
            context.setServerConfigurationResource(ConfigurationLoader.checkAndGetProperty("sshtools.server", "server.xml"));
            context.setPlatformConfigurationResource(System.getProperty("sshtools.platform", "platform.xml"));
            ConfigurationLoader.initialize(false, context);
            XmlConfigurationContext context2 = new XmlConfigurationContext();
            context2.setFailOnError(false);
            context2.setAPIConfigurationResource(ConfigurationLoader.checkAndGetProperty("sshtools.config", "sshtools.xml"));
            context2.setAutomationConfigurationResource(ConfigurationLoader.checkAndGetProperty("sshtools.automate", "automation.xml"));
            ConfigurationLoader.initialize(false, context2);
            if (args.length > 0) {
                if (args[0].equals("-start")) {
                    SshDaemon.start();
                } else if (args[0].equals("-stop")) {
                    if (args.length > 1) {
                        SshDaemon.stop(args[1]);
                    } else {
                        SshDaemon.stop("The framework daemon is shutting down");
                    }
                } else {
                    System.out.println("Usage: SshDaemon [-start|-stop]");
                }
            } else {
                System.out.println("Usage: SshDaemon [-start|-stop]");
            }
        }
        catch (Exception e) {
            log.error((Object)("The server failed to process the " + (args.length > 0 ? args[0] : "") + " command"), (Throwable)e);
        }
    }

    public static void start() throws IOException {
        SshServer server = new SshServer(){

            public void configureServices(ConnectionProtocol connection) throws IOException {
                connection.addChannelFactory("session", new SessionChannelFactory());
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("com.sshtools.daemon.configuration.ServerConfiguration");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (ConfigurationLoader.isConfigurationAvailable(clazz)) {
                    Class<?> clazz2 = class$1;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$1 = Class.forName("com.sshtools.daemon.configuration.ServerConfiguration");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (((ServerConfiguration)ConfigurationLoader.getConfiguration(clazz2)).getAllowTcpForwarding()) {
                        ForwardingServer forwardingServer = new ForwardingServer(connection);
                    }
                }
            }

            public void shutdown(String msg) {
            }
        };
        server.startServer();
    }

    public static void stop(String msg) throws IOException {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("com.sshtools.daemon.configuration.ServerConfiguration");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Socket socket = new Socket(inetAddress, ((ServerConfiguration)ConfigurationLoader.getConfiguration(clazz)).getCommandPort());
            socket.getOutputStream().write(58);
            int len = msg.length() <= 255 ? msg.length() : 255;
            socket.getOutputStream().write(len);
            if (len > 0) {
                socket.getOutputStream().write(msg.substring(0, len).getBytes());
            }
            socket.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

