/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.daemon;

import com.sshtools.daemon.authentication.AuthenticationProtocolServer;
import com.sshtools.daemon.configuration.ServerConfiguration;
import com.sshtools.daemon.transport.TransportProtocolServer;
import com.sshtools.j2ssh.SshException;
import com.sshtools.j2ssh.SshThread;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.configuration.SshConnectionProperties;
import com.sshtools.j2ssh.connection.ConnectionProtocol;
import com.sshtools.j2ssh.net.ConnectedSocketTransportProvider;
import com.sshtools.j2ssh.transport.TransportProtocol;
import com.sshtools.j2ssh.transport.TransportProtocolEventAdapter;
import com.sshtools.j2ssh.util.StartStopState;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SshServer {
    private static Log log;
    private ConnectionListener listener = null;
    private ServerSocket server = null;
    private boolean shutdown = false;
    private ServerSocket commandServerSocket;
    protected List activeConnections = new Vector();
    Thread thread;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.sshtools.daemon.SshServer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public SshServer() throws IOException {
        Class<?> clazz;
        String serverId = System.getProperty("sshtools.serverid");
        if (serverId != null) {
            TransportProtocolServer.SOFTWARE_VERSION_COMMENTS = serverId;
        }
        if ((clazz = class$1) == null) {
            try {
                clazz = class$1 = Class.forName("com.sshtools.daemon.configuration.ServerConfiguration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!ConfigurationLoader.isConfigurationAvailable(clazz)) {
            throw new SshException("Server configuration not available!");
        }
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("com.sshtools.daemon.configuration.PlatformConfiguration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!ConfigurationLoader.isConfigurationAvailable(clazz2)) {
            throw new SshException("Platform configuration not available");
        }
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("com.sshtools.daemon.configuration.ServerConfiguration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (((ServerConfiguration)ConfigurationLoader.getConfiguration(clazz3)).getServerHostKeys().size() <= 0) {
            throw new SshException("Server cannot start because there are no server host keys available");
        }
    }

    public void startServer() throws IOException {
        log.info((Object)"Starting server");
        this.shutdown = false;
        this.startServerSocket();
        this.thread = new Thread(new Runnable(){

            public void run() {
                try {
                    SshServer.this.startCommandSocket();
                }
                catch (IOException ex) {
                    log.info((Object)"Failed to start command socket", (Throwable)ex);
                    try {
                        SshServer.this.stopServer("The command socket failed to start");
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
        this.thread.start();
        try {
            this.thread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    protected void processCommand(int command, Socket client) throws IOException {
        if (command == 58) {
            int len = client.getInputStream().read();
            byte[] msg = new byte[len];
            client.getInputStream().read(msg);
            this.stopServer(new String(msg));
        }
    }

    protected void startCommandSocket() throws IOException {
        block7: {
            try {
                Socket client;
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("com.sshtools.daemon.configuration.ServerConfiguration");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                this.commandServerSocket = new ServerSocket(((ServerConfiguration)ConfigurationLoader.getConfiguration(clazz)).getCommandPort(), 50, InetAddress.getLocalHost());
                while ((client = this.commandServerSocket.accept()) != null) {
                    log.info((Object)"Command request received");
                    this.processCommand(client.getInputStream().read(), client);
                    client.close();
                    if (this.shutdown) break;
                }
                this.commandServerSocket.close();
            }
            catch (Exception e) {
                if (this.shutdown) break block7;
                log.fatal((Object)"The command socket failed", (Throwable)e);
            }
        }
    }

    protected void startServerSocket() throws IOException {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("com.sshtools.daemon.configuration.ServerConfiguration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String string = ((ServerConfiguration)ConfigurationLoader.getConfiguration(clazz)).getListenAddress();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("com.sshtools.daemon.configuration.ServerConfiguration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listener = new ConnectionListener(string, ((ServerConfiguration)ConfigurationLoader.getConfiguration(clazz2)).getPort());
        this.listener.start();
    }

    public void stopServer(String msg) throws IOException {
        log.info((Object)"Shutting down server");
        this.shutdown = true;
        log.debug((Object)msg);
        this.shutdown(msg);
        this.listener.stop();
        log.debug((Object)"Stopping command server");
        try {
            if (this.commandServerSocket != null) {
                this.commandServerSocket.close();
            }
        }
        catch (IOException ioe) {
            log.error((Object)ioe);
        }
    }

    protected abstract void shutdown(String var1);

    protected abstract void configureServices(ConnectionProtocol var1) throws IOException;

    protected void refuseSession(Socket socket) throws IOException {
        TransportProtocolServer transport = new TransportProtocolServer(true);
        transport.startTransportProtocol(new ConnectedSocketTransportProvider(socket), new SshConnectionProperties());
    }

    protected TransportProtocolServer createSession(Socket socket) throws IOException {
        log.debug((Object)"Initializing connection");
        InetAddress address = socket.getInetAddress();
        log.debug((Object)("Remote Hostname: " + address.getHostName()));
        log.debug((Object)("Remote IP: " + address.getHostAddress()));
        TransportProtocolServer transport = new TransportProtocolServer();
        AuthenticationProtocolServer authentication = new AuthenticationProtocolServer();
        ConnectionProtocol connection = new ConnectionProtocol();
        this.configureServices(connection);
        authentication.acceptService(connection);
        transport.acceptService(authentication);
        transport.startTransportProtocol(new ConnectedSocketTransportProvider(socket), new SshConnectionProperties());
        return transport;
    }

    class ConnectionListener
    implements Runnable {
        private Log log;
        private ServerSocket server;
        private String listenAddress;
        private Thread thread;
        private int maxConnections;
        private int port;
        private StartStopState state;
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;

        public ConnectionListener(String listenAddress, int port) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.sshtools.daemon.SshServer$ConnectionListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.log = LogFactory.getLog((Class)clazz);
            this.state = new StartStopState(2);
            this.port = port;
            this.listenAddress = listenAddress;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                try {
                    block17: {
                        this.log.debug((Object)"Starting connection listener thread");
                        this.state.setValue(1);
                        this.server = new ServerSocket(this.port);
                        Class<?> clazz = class$1;
                        if (clazz == null) {
                            Class<?> clazz2;
                            try {
                                clazz2 = Class.forName("com.sshtools.daemon.configuration.ServerConfiguration");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            clazz = class$1 = clazz2;
                        }
                        this.maxConnections = ((ServerConfiguration)ConfigurationLoader.getConfiguration(clazz)).getMaxConnections();
                        boolean refuse = false;
                        TransportProtocolEventAdapter eventHandler = new TransportProtocolEventAdapter(this){
                            final /* synthetic */ ConnectionListener this$1;
                            {
                                this.this$1 = connectionListener;
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void onDisconnect(TransportProtocol transport) {
                                if (ConnectionListener.access$0(this.this$1).getValue() != 2) {
                                    List list = ConnectionListener.access$2((ConnectionListener)this.this$1).activeConnections;
                                    synchronized (list) {
                                        ConnectionListener.access$1(this.this$1).info((Object)(String.valueOf(transport.getUnderlyingProviderDetail()) + " connection closed"));
                                        ConnectionListener.access$2((ConnectionListener)this.this$1).activeConnections.remove(transport);
                                    }
                                }
                            }
                        };
                        try {
                            Socket socket;
                            while ((socket = this.server.accept()) != null && this.state.getValue() == 1) {
                                this.log.debug((Object)"New connection requested");
                                if (this.maxConnections < SshServer.this.activeConnections.size()) {
                                    SshServer.this.refuseSession(socket);
                                    continue;
                                }
                                TransportProtocolServer transport = SshServer.this.createSession(socket);
                                this.log.info((Object)("Monitoring active session from " + socket.getInetAddress().getHostName()));
                                List list = SshServer.this.activeConnections;
                                synchronized (list) {
                                    SshServer.this.activeConnections.add(transport);
                                }
                                transport.addEventHandler(eventHandler);
                            }
                        }
                        catch (IOException ex) {
                            if (this.state.getValue() == 2) break block17;
                            this.log.info((Object)"The server was shutdown unexpectedly", (Throwable)ex);
                        }
                    }
                    this.state.setValue(2);
                    this.log.info((Object)"Disconnecting active sessions");
                    Iterator it = SshServer.this.activeConnections.iterator();
                    while (true) {
                        if (!it.hasNext()) {
                            SshServer.this.listener = null;
                            this.log.info((Object)"Exiting connection listener thread");
                        }
                        ((TransportProtocolServer)it.next()).disconnect("The server is shuting down");
                    }
                }
                catch (IOException ex) {
                    this.log.info((Object)"The server thread failed", (Throwable)ex);
                }
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                this.thread = null;
                throw throwable;
            }
            {
                Object var6_10 = null;
                this.thread = null;
                return;
            }
        }

        public void start() {
            this.thread = new SshThread(this, "Connection listener", true);
            this.thread.start();
        }

        public void stop() {
            try {
                this.state.setValue(2);
                this.server.close();
                if (this.thread != null) {
                    this.thread.interrupt();
                }
            }
            catch (IOException ioe) {
                this.log.warn((Object)"The listening socket reported an error during shutdown", (Throwable)ioe);
            }
        }

        static /* synthetic */ StartStopState access$0(ConnectionListener connectionListener) {
            return connectionListener.state;
        }

        static /* synthetic */ Log access$1(ConnectionListener connectionListener) {
            return connectionListener.log;
        }

        static /* synthetic */ SshServer access$2(ConnectionListener connectionListener) {
            return connectionListener.SshServer.this;
        }
    }
}

