/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.daemon.authentication;

import com.sshtools.daemon.authentication.SshAuthenticationServer;
import com.sshtools.daemon.authentication.SshAuthenticationServerFactory;
import com.sshtools.daemon.configuration.ServerConfiguration;
import com.sshtools.daemon.platform.NativeAuthenticationProvider;
import com.sshtools.j2ssh.SshException;
import com.sshtools.j2ssh.SshThread;
import com.sshtools.j2ssh.authentication.AuthenticationProtocolException;
import com.sshtools.j2ssh.authentication.SshMsgUserAuthBanner;
import com.sshtools.j2ssh.authentication.SshMsgUserAuthFailure;
import com.sshtools.j2ssh.authentication.SshMsgUserAuthRequest;
import com.sshtools.j2ssh.authentication.SshMsgUserAuthSuccess;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.transport.AsyncService;
import com.sshtools.j2ssh.transport.Service;
import com.sshtools.j2ssh.transport.SshMessage;
import com.sshtools.j2ssh.transport.SshMessageStore;
import com.sshtools.j2ssh.transport.TransportProtocolState;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuthenticationProtocolServer
extends AsyncService {
    private static Log log;
    private List completedAuthentications = new ArrayList();
    private Map acceptServices = new HashMap();
    private List availableAuths;
    private String serviceToStart;
    private int[] messageFilter = new int[1];
    private SshMessageStore methodMessages = new SshMessageStore();
    private int attempts = 0;
    private boolean completed = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.sshtools.daemon.authentication.AuthenticationProtocolServer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public AuthenticationProtocolServer() {
        super("ssh-userauth");
        this.messageFilter[0] = 50;
    }

    protected void onServiceAccept() throws IOException {
    }

    protected void onServiceInit(int startMode) throws IOException {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("com.sshtools.j2ssh.authentication.SshMsgUserAuthRequest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.messageStore.registerMessage(50, clazz);
        this.transport.addMessageStore(this.methodMessages);
    }

    public byte[] getSessionIdentifier() {
        return this.transport.getSessionIdentifier();
    }

    public TransportProtocolState getConnectionState() {
        return this.transport.getState();
    }

    public void sendMessage(SshMessage msg) throws IOException {
        this.transport.sendMessage(msg, this);
    }

    public SshMessage readMessage() throws IOException {
        try {
            return this.methodMessages.nextMessage();
        }
        catch (InterruptedException ex) {
            throw new SshException("The thread was interrupted");
        }
    }

    public void registerMessage(int messageId, Class cls) {
        this.methodMessages.registerMessage(messageId, cls);
    }

    protected void onServiceRequest() throws IOException {
        ServerConfiguration server;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("com.sshtools.daemon.configuration.ServerConfiguration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((server = (ServerConfiguration)ConfigurationLoader.getConfiguration(clazz)) == null) {
            throw new AuthenticationProtocolException("Server configuration unavailable");
        }
        this.availableAuths = new ArrayList();
        Iterator it = SshAuthenticationServerFactory.getSupportedMethods().iterator();
        List allowed = server.getAllowedAuthentications();
        while (it.hasNext()) {
            String method = (String)it.next();
            if (!allowed.contains(method)) continue;
            this.availableAuths.add(method);
        }
        if (this.availableAuths.size() <= 0) {
            throw new AuthenticationProtocolException("No valid authentication methods have been specified");
        }
        this.sendServiceAccept();
        String bannerFile = server.getAuthenticationBanner();
        if (bannerFile != null && bannerFile.length() > 0) {
            InputStream in = ConfigurationLoader.loadFile(bannerFile);
            if (in != null) {
                byte[] data = new byte[in.available()];
                in.read(data);
                in.close();
                SshMsgUserAuthBanner bannerMsg = new SshMsgUserAuthBanner(new String(data));
                this.transport.sendMessage(bannerMsg, this);
            } else {
                log.info((Object)("The banner file '" + bannerFile + "' was not found"));
            }
        }
    }

    protected void onMessageReceived(SshMessage msg) throws IOException {
        switch (msg.getMessageId()) {
            case 50: {
                this.onMsgUserAuthRequest((SshMsgUserAuthRequest)msg);
                break;
            }
            default: {
                throw new AuthenticationProtocolException("Unregistered message received!");
            }
        }
    }

    protected int[] getAsyncMessageFilter() {
        return this.messageFilter;
    }

    public void acceptService(Service service) {
        this.acceptServices.put(service.getServiceName(), service);
    }

    private void sendUserAuthFailure(boolean success) throws IOException {
        Iterator it = this.availableAuths.iterator();
        String auths = null;
        while (it.hasNext()) {
            auths = String.valueOf(auths == null ? "" : String.valueOf(auths) + ",") + (String)it.next();
        }
        SshMsgUserAuthFailure reply = new SshMsgUserAuthFailure(auths, success);
        this.transport.sendMessage(reply, this);
    }

    protected void onStop() {
        block4: {
            try {
                if (!this.completed) break block4;
                try {
                    this.transport.getState().waitForState(5);
                }
                catch (InterruptedException ex) {
                    log.warn((Object)"The authentication service was interrupted");
                }
                NativeAuthenticationProvider nap = NativeAuthenticationProvider.getInstance();
                nap.logoffUser();
            }
            catch (IOException ex) {
                log.warn((Object)("Failed to logoff " + SshThread.getCurrentThreadUser()));
            }
        }
    }

    private void sendUserAuthSuccess() throws IOException {
        SshMsgUserAuthSuccess msg = new SshMsgUserAuthSuccess();
        Service service = (Service)this.acceptServices.get(this.serviceToStart);
        service.init(2, this.transport);
        service.start();
        this.transport.sendMessage(msg, this);
        this.completed = true;
        this.stop();
    }

    private void onMsgUserAuthRequest(SshMsgUserAuthRequest msg) throws IOException {
        if (msg.getMethodName().equals("none")) {
            this.sendUserAuthFailure(false);
        } else {
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("com.sshtools.daemon.configuration.ServerConfiguration");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (this.attempts >= ((ServerConfiguration)ConfigurationLoader.getConfiguration(clazz)).getMaxAuthentications()) {
                this.transport.disconnect("Too many failed authentication attempts");
            } else {
                if (this.acceptServices.containsKey(msg.getServiceName())) {
                    String method = msg.getMethodName();
                    if (this.availableAuths.contains(method)) {
                        SshAuthenticationServer auth = SshAuthenticationServerFactory.newInstance(method);
                        this.serviceToStart = msg.getServiceName();
                        int result = auth.authenticate(this, msg);
                        if (result == 2) {
                            this.sendUserAuthFailure(false);
                        } else if (result == 4) {
                            this.completedAuthentications.add(auth.getMethodName());
                            Class<?> clazz2 = class$2;
                            if (clazz2 == null) {
                                try {
                                    clazz2 = class$2 = Class.forName("com.sshtools.daemon.configuration.ServerConfiguration");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            ServerConfiguration sc = (ServerConfiguration)ConfigurationLoader.getConfiguration(clazz2);
                            Iterator it = sc.getRequiredAuthentications().iterator();
                            while (it.hasNext()) {
                                if (this.completedAuthentications.contains(it.next())) continue;
                                this.sendUserAuthFailure(true);
                                return;
                            }
                            this.thread.setUsername(msg.getUsername());
                            this.sendUserAuthSuccess();
                        }
                    } else {
                        this.sendUserAuthFailure(false);
                    }
                } else {
                    this.sendUserAuthFailure(false);
                }
                ++this.attempts;
            }
        }
    }
}

