/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.daemon.authentication;

import com.sshtools.common.configuration.Authorization;
import com.sshtools.daemon.authentication.PublicKeyVerification;
import com.sshtools.daemon.configuration.ServerConfiguration;
import com.sshtools.daemon.platform.NativeAuthenticationProvider;
import com.sshtools.j2ssh.authentication.AuthenticationProtocolException;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.publickey.SshKeyPair;
import com.sshtools.j2ssh.transport.publickey.SshKeyPairFactory;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import com.sshtools.j2ssh.transport.publickey.SshPublicKeyFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuthorizationFileVerification
implements PublicKeyVerification {
    private static Log log;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.sshtools.daemon.authentication.AuthorizationFileVerification");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public boolean verifyKeySignature(String username, String algorithm, byte[] encoded, String service, byte[] sessionId, byte[] signature) throws IOException {
        try {
            SshPublicKey key = this.getAuthorizedKey(username, algorithm, encoded);
            ByteArrayWriter data = new ByteArrayWriter();
            data.writeBinaryString(sessionId);
            data.write(50);
            data.writeString(username);
            data.writeString(service);
            data.writeString("publickey");
            data.write(1);
            data.writeString(key.getAlgorithmName());
            data.writeBinaryString(key.getEncoded());
            if (key.verifySignature(signature, data.toByteArray())) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private SshPublicKey getAuthorizedKey(String username, String algorithm, byte[] encoded) throws IOException {
        Authorization keys;
        String authorizationFile;
        File file;
        StringBuffer buf;
        Class<?> clazz;
        NativeAuthenticationProvider provider = NativeAuthenticationProvider.getInstance();
        String userHome = provider.getHomeDirectory(username);
        if (userHome == null) {
            log.warn((Object)("There is no home directory for " + username + " is available"));
        }
        if (userHome != null) {
            userHome = userHome.replace('\\', '/');
        }
        if ((clazz = class$1) == null) {
            try {
                clazz = class$1 = Class.forName("com.sshtools.daemon.configuration.ServerConfiguration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ServerConfiguration config = (ServerConfiguration)ConfigurationLoader.getConfiguration(clazz);
        String userConfigDir = config.getUserConfigDirectory();
        if ((userConfigDir = userConfigDir.replace('\\', '/')).indexOf("%D") > -1 && userHome == null) {
            throw new IOException("<UserConfigDirectory> requires home directory, but none available for " + username);
        }
        int idx = 0;
        while ((idx = userConfigDir.indexOf("%D", idx + 1)) > -1) {
            buf = new StringBuffer(userConfigDir);
            buf = buf.replace(idx, idx + 1, userHome);
            userConfigDir = buf.toString();
        }
        idx = 0;
        while ((idx = userConfigDir.indexOf("%U", idx + 1)) > -1) {
            buf = new StringBuffer(userConfigDir);
            buf = buf.replace(idx, idx + 1, username);
            userConfigDir = buf.toString();
        }
        if (!(userConfigDir = userConfigDir.replace('/', File.separatorChar).trim()).endsWith(File.separator)) {
            userConfigDir = String.valueOf(userConfigDir) + File.separator;
        }
        if (!(file = new File(authorizationFile = String.valueOf(userConfigDir) + config.getAuthorizationFile())).exists()) {
            log.info((Object)("authorizationFile: " + authorizationFile + " does not exist."));
            throw new IOException("authorizationFile: " + authorizationFile + " does not exist.");
        }
        FileInputStream in = new FileInputStream(file);
        try {
            keys = new Authorization(in);
        }
        catch (Exception e) {
            throw new AuthenticationProtocolException("Failed to load authorized keys file " + authorizationFile);
        }
        Iterator it = keys.getAuthorizedKeys().iterator();
        SshKeyPair pair = SshKeyPairFactory.newInstance(algorithm);
        SshPublicKey authorizedKey = null;
        SshPublicKey key = pair.decodePublicKey(encoded);
        boolean valid = false;
        while (it.hasNext()) {
            String keyfile = (String)it.next();
            file = new File(String.valueOf(userConfigDir) + keyfile);
            if (!file.exists()) {
                file = new File(keyfile);
            }
            if (file.exists()) {
                SshPublicKeyFile pkf = SshPublicKeyFile.parse(file);
                authorizedKey = pkf.toPublicKey();
                if (!authorizedKey.equals(key)) continue;
                return authorizedKey;
            }
            log.info((Object)("Failed attempt to load key file " + keyfile));
        }
        throw new IOException("");
    }

    public boolean acceptKey(String username, String algorithm, byte[] encoded) throws IOException {
        try {
            this.getAuthorizedKey(username, algorithm, encoded);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }
}

