/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.daemon.authentication;

import com.sshtools.daemon.authentication.AuthenticationProtocolServer;
import com.sshtools.daemon.authentication.SshAuthenticationServer;
import com.sshtools.daemon.platform.NativeAuthenticationProvider;
import com.sshtools.daemon.platform.PasswordChangeException;
import com.sshtools.j2ssh.authentication.SshMsgUserAuthPwdChangeReq;
import com.sshtools.j2ssh.authentication.SshMsgUserAuthRequest;
import com.sshtools.j2ssh.io.ByteArrayReader;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PasswordAuthenticationServer
extends SshAuthenticationServer {
    private static Log log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.sshtools.daemon.authentication.PasswordAuthenticationServer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public final String getMethodName() {
        return "password";
    }

    public void setAuthenticatedTokens(Map tokens) {
    }

    public int authenticate(AuthenticationProtocolServer authentication, SshMsgUserAuthRequest msg) throws IOException {
        NativeAuthenticationProvider authImpl = NativeAuthenticationProvider.getInstance();
        if (authImpl == null) {
            log.error((Object)"Cannot perfrom authentication witout native authentication provider");
            return 2;
        }
        ByteArrayReader bar = new ByteArrayReader(msg.getRequestData());
        boolean changepwd = bar.read() != 0;
        String password = bar.readString();
        String newpassword = null;
        if (changepwd) {
            newpassword = bar.readString();
            try {
                if (!authImpl.changePassword(msg.getUsername(), password, newpassword)) {
                    return 2;
                }
                if (authImpl.logonUser(msg.getUsername(), newpassword)) {
                    return 4;
                }
                return 2;
            }
            catch (PasswordChangeException ex1) {
                return 2;
            }
        }
        try {
            if (authImpl.logonUser(msg.getUsername(), password)) {
                log.info((Object)(String.valueOf(msg.getUsername()) + " has passed password authentication"));
                return 4;
            }
            log.info((Object)(String.valueOf(msg.getUsername()) + " has failed password authentication"));
            return 2;
        }
        catch (PasswordChangeException ex) {
            SshMsgUserAuthPwdChangeReq reply = new SshMsgUserAuthPwdChangeReq(String.valueOf(msg.getUsername()) + " is required to change password", "");
            authentication.sendMessage(reply);
            return 1;
        }
    }
}

