/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.daemon.authentication;

import com.sshtools.daemon.authentication.SshAuthenticationServer;
import com.sshtools.j2ssh.configuration.ConfigurationException;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.configuration.ExtensionAlgorithm;
import com.sshtools.j2ssh.configuration.SshAPIConfiguration;
import com.sshtools.j2ssh.transport.AlgorithmNotSupportedException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshAuthenticationServerFactory {
    private static Map auths;
    private static Log log;
    public static final String AUTH_PASSWORD = "password";
    public static final String AUTH_PK = "publickey";
    public static final String AUTH_KBI = "keyboard-interactive";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    static {
        block30: {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.sshtools.daemon.authentication.SshAuthenticationServerFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            log = LogFactory.getLog((Class)clazz);
            auths = new HashMap();
            log.info((Object)"Loading supported authentication methods");
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("com.sshtools.daemon.authentication.PasswordAuthenticationServer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            auths.put(AUTH_PASSWORD, clazz2);
            Class<?> clazz3 = class$2;
            if (clazz3 == null) {
                try {
                    clazz3 = class$2 = Class.forName("com.sshtools.daemon.authentication.PublicKeyAuthenticationServer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            auths.put(AUTH_PK, clazz3);
            Class<?> clazz4 = class$3;
            if (clazz4 == null) {
                try {
                    clazz4 = class$3 = Class.forName("com.sshtools.daemon.authentication.KBIPasswordAuthenticationServer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            auths.put(AUTH_KBI, clazz4);
            try {
                Class<?> clazz5 = class$4;
                if (clazz5 == null) {
                    try {
                        clazz5 = class$4 = Class.forName("com.sshtools.j2ssh.configuration.SshAPIConfiguration");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!ConfigurationLoader.isConfigurationAvailable(clazz5)) break block30;
                Class<?> clazz6 = class$4;
                if (clazz6 == null) {
                    try {
                        clazz6 = class$4 = Class.forName("com.sshtools.j2ssh.configuration.SshAPIConfiguration");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                SshAPIConfiguration config = (SshAPIConfiguration)ConfigurationLoader.getConfiguration(clazz6);
                List addons = config.getAuthenticationExtensions();
                Iterator it = addons.iterator();
                while (it.hasNext()) {
                    ExtensionAlgorithm method = (ExtensionAlgorithm)it.next();
                    String name = method.getAlgorithmName();
                    if (auths.containsKey(name)) {
                        log.debug((Object)("Standard authentication implementation for " + name + " is being overidden by " + method.getImplementationClass()));
                    } else {
                        log.debug((Object)(String.valueOf(name) + " authentication is implemented by " + method.getImplementationClass()));
                    }
                    try {
                        Class cls = ConfigurationLoader.getExtensionClass(method.getImplementationClass());
                        Object obj = cls.newInstance();
                        if (!(obj instanceof SshAuthenticationServer)) continue;
                        auths.put(name, cls);
                    }
                    catch (Exception e) {
                        log.warn((Object)("Failed to load extension authentication implementation " + method.getImplementationClass()), (Throwable)e);
                    }
                }
            }
            catch (ConfigurationException configurationException) {
                // empty catch block
            }
        }
    }

    protected SshAuthenticationServerFactory() {
    }

    public static void initialize() {
    }

    public static List getSupportedMethods() {
        ArrayList list = new ArrayList(auths.keySet());
        return list;
    }

    public static SshAuthenticationServer newInstance(String methodName) throws AlgorithmNotSupportedException {
        try {
            return (SshAuthenticationServer)((Class)auths.get(methodName)).newInstance();
        }
        catch (Exception e) {
            throw new AlgorithmNotSupportedException(String.valueOf(methodName) + " is not supported!");
        }
    }
}

