/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.daemon.scp;

import com.sshtools.daemon.platform.InvalidHandleException;
import com.sshtools.daemon.platform.NativeFileSystemProvider;
import com.sshtools.daemon.platform.NativeProcessProvider;
import com.sshtools.daemon.platform.PermissionDeniedException;
import com.sshtools.daemon.util.StringPattern;
import com.sshtools.daemon.util.StringUtil;
import com.sshtools.j2ssh.SshThread;
import com.sshtools.j2ssh.io.UnsignedInteger32;
import com.sshtools.j2ssh.io.UnsignedInteger64;
import com.sshtools.j2ssh.sftp.SftpFile;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScpServer
extends NativeProcessProvider
implements Runnable {
    private static Log log;
    private static int BUFFER_SIZE;
    private InputStream in;
    private InputStream err;
    private OutputStream out;
    private String destination;
    private PipedOutputStream pipeIn;
    private PipedOutputStream pipeErr;
    private PipedInputStream pipeOut;
    private SshThread scpServerThread;
    private int verbosity = 0;
    private int exitCode;
    private boolean directory;
    private boolean recursive;
    private boolean from;
    private boolean to;
    private NativeFileSystemProvider nfs;
    private byte[] buffer = new byte[BUFFER_SIZE];
    private String currentDirectory;
    private boolean preserveAttributes;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.sshtools.daemon.scp.ScpServer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
        BUFFER_SIZE = 16384;
    }

    public ScpServer() {
        this.nfs = NativeFileSystemProvider.getInstance();
    }

    public boolean allocatePseudoTerminal(String term, int cols, int rows, int width, int height, String modes) {
        return false;
    }

    public boolean createProcess(String command, Map environment) throws IOException {
        log.info((Object)"Creating ScpServer");
        if (this.nfs == null) {
            throw new IOException("NativeFileSystem was not instantiated. Please check logs");
        }
        this.scp(command.substring(4));
        return true;
    }

    public String getDefaultTerminalProvider() {
        return null;
    }

    public InputStream getInputStream() throws IOException {
        return this.in;
    }

    public InputStream getStderrInputStream() {
        return this.err;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.out;
    }

    public void kill() {
        log.info((Object)"Killing ScpServer");
        try {
            if (this.pipeIn != null) {
                this.pipeIn.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.pipeOut != null) {
                this.pipeOut.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.pipeErr != null) {
                this.pipeErr.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void start() throws IOException {
        log.debug((Object)"Starting ScpServer thread");
        this.scpServerThread = SshThread.getCurrentThread().cloneThread(this, "ScpServer");
        this.scpServerThread.start();
    }

    public boolean stillActive() {
        return false;
    }

    public boolean supportsPseudoTerminal(String term) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitForExitCode() {
        try {
            ScpServer scpServer = this;
            synchronized (scpServer) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        log.debug((Object)("Returning exit code of " + this.exitCode));
        return this.exitCode;
    }

    private void scp(String args) throws IOException {
        log.debug((Object)("Parsing ScpServer options " + args));
        String[] a = StringUtil.current().allParts(args, " ");
        this.destination = null;
        this.directory = false;
        this.from = false;
        this.to = false;
        this.recursive = false;
        this.verbosity = 0;
        boolean remote = false;
        int i = 0;
        while (i < a.length) {
            if (a[i].startsWith("-")) {
                String s = a[i].substring(1);
                int j = 0;
                while (j < s.length()) {
                    char ch = s.charAt(j);
                    switch (ch) {
                        case 't': {
                            this.to = true;
                            break;
                        }
                        case 'd': {
                            this.directory = true;
                            break;
                        }
                        case 'f': {
                            this.from = true;
                            break;
                        }
                        case 'r': {
                            this.recursive = true;
                            break;
                        }
                        case 'v': {
                            ++this.verbosity;
                            break;
                        }
                        case 'p': {
                            this.preserveAttributes = true;
                            break;
                        }
                        default: {
                            log.warn((Object)"Unsupported argument, allowing to continue.");
                        }
                    }
                    ++j;
                }
            } else if (this.destination == null) {
                this.destination = a[i];
            } else {
                throw new IOException("More than one destination supplied " + a[i]);
            }
            ++i;
        }
        if (!this.to && !this.from) {
            throw new IOException("Must supply either -t or -f.");
        }
        if (this.destination == null) {
            throw new IOException("Destination not supplied.");
        }
        log.debug((Object)("Destination is " + this.destination));
        log.debug((Object)("Recursive is " + this.recursive));
        log.debug((Object)("Directory is " + this.directory));
        log.debug((Object)("Verbosity is " + this.verbosity));
        log.debug((Object)("From is " + this.from));
        log.debug((Object)("To is " + this.to));
        log.debug((Object)("Preserve Attributes " + this.preserveAttributes));
        log.debug((Object)"Creating pipes");
        this.pipeIn = new PipedOutputStream();
        this.pipeErr = new PipedOutputStream();
        this.pipeOut = new PipedInputStream();
        this.in = new PipedInputStream(this.pipeIn);
        this.err = new PipedInputStream(this.pipeErr);
        this.out = new PipedOutputStream(this.pipeOut);
    }

    private void writeOk() throws IOException {
        log.debug((Object)"Sending client ok command");
        this.pipeIn.write(0);
        this.pipeIn.flush();
    }

    private void writeCommand(String cmd) throws IOException {
        log.debug((Object)("Sending command '" + cmd + "'"));
        this.pipeIn.write(cmd.getBytes());
        if (!cmd.endsWith("\n")) {
            this.pipeIn.write("\n".getBytes());
        }
        this.pipeIn.flush();
    }

    private void writeError(String msg) throws IOException {
        this.writeError(msg, false);
    }

    private void writeError(String msg, boolean serious) throws IOException {
        log.debug((Object)("Sending error message '" + msg + "' to client (serious=" + serious + ")"));
        this.pipeIn.write(serious ? 2 : 1);
        this.pipeIn.write(msg.getBytes());
        if (!msg.endsWith("\n")) {
            this.pipeIn.write(10);
        }
        this.pipeIn.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block25: {
            log.debug((Object)"Running ScpServer thread");
            try {
                if (this.from) {
                    log.info((Object)"From mode");
                    try {
                        block24: {
                            this.waitForResponse();
                            StringPattern sp = new StringPattern(this.destination);
                            if (sp.hasWildcard()) {
                                log.debug((Object)"Path contains wildcard");
                                String base = this.destination;
                                String dir = ".";
                                int idx = base.lastIndexOf(47);
                                if (idx != -1) {
                                    if (idx > 0) {
                                        dir = base.substring(0, idx);
                                    }
                                    base = base.substring(idx + 1);
                                }
                                log.debug((Object)("Looking for matches in " + dir + " for " + base));
                                sp = new StringPattern(base);
                                byte[] handle = null;
                                try {
                                    handle = this.nfs.openDirectory(dir);
                                    SftpFile[] files = this.nfs.readDirectory(handle);
                                    int i = 0;
                                    while (i < files.length) {
                                        log.debug((Object)("Testing for match against " + files[i].getFilename()));
                                        if (sp.matches(files[i].getFilename())) {
                                            log.debug((Object)"Matched");
                                            this.writeFileToRemote(String.valueOf(dir) + "/" + files[i].getFilename());
                                        } else {
                                            log.debug((Object)"No match");
                                        }
                                        ++i;
                                    }
                                }
                                catch (Throwable throwable) {
                                    Object var8_14 = null;
                                    if (handle == null) throw throwable;
                                    try {
                                        this.nfs.closeFile(handle);
                                        throw throwable;
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    throw throwable;
                                }
                                {
                                    Object var8_15 = null;
                                    if (handle != null) {
                                        try {}
                                        catch (Exception exception) {}
                                        this.nfs.closeFile(handle);
                                    }
                                    break block24;
                                }
                            }
                            log.debug((Object)"No wildcards");
                            this.writeFileToRemote(this.destination);
                        }
                        log.debug((Object)"File transfers complete");
                        break block25;
                    }
                    catch (FileNotFoundException fnfe) {
                        log.error((Object)fnfe);
                        this.writeError(fnfe.getMessage(), true);
                        throw new IOException(fnfe.getMessage());
                    }
                    catch (PermissionDeniedException pde) {
                        log.error((Object)pde);
                        this.writeError(pde.getMessage(), true);
                        throw new IOException(pde.getMessage());
                    }
                    catch (InvalidHandleException ihe) {
                        log.error((Object)ihe);
                        this.writeError(ihe.getMessage(), true);
                        throw new IOException(ihe.getMessage());
                    }
                    catch (IOException ioe) {
                        log.error((Object)ioe);
                        this.writeError(ioe.getMessage(), true);
                        throw new IOException(ioe.getMessage());
                    }
                }
                log.info((Object)"To mode");
                this.readFromRemote(this.destination);
            }
            catch (Throwable t) {
                t.printStackTrace();
                log.error((Object)t);
                this.exitCode = 1;
            }
        }
        log.debug((Object)"ScpServer stopped, notify block on waitForExitCode().");
        ScpServer scpServer = this;
        synchronized (scpServer) {
            this.notify();
            return;
        }
    }

    /*
     * Exception decompiling
     */
    private boolean writeDirToRemote(String path) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 281->284)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeFileToRemote(String path) throws IOException, PermissionDeniedException, InvalidHandleException {
        block14: {
            attr = this.nfs.getFileAttributes(path);
            if (attr.isDirectory()) {
                if (!this.writeDirToRemote(path)) {
                    return;
                }
            } else {
                if (attr.isFile() == false) throw new IOException(String.valueOf(path) + " not valid for SCP.");
                basename = path;
                idx = basename.lastIndexOf(47);
                if (idx != -1) {
                    basename = path.substring(idx + 1);
                }
                this.writeCommand("C" + attr.getMaskString() + " " + attr.getSize() + " " + basename + "\n");
                this.waitForResponse();
                ScpServer.log.debug((Object)("Opening file " + path));
                handle = null;
                try {
                    handle = this.nfs.openFile(path, new UnsignedInteger32(1L), attr);
                    ScpServer.log.debug((Object)"Sending file");
                    for (count = 0; count < attr.getSize().intValue(); count += buf.length) {
                        try {
                            buf = this.nfs.readFile(handle, new UnsignedInteger64(String.valueOf(count)), new UnsignedInteger32(ScpServer.BUFFER_SIZE));
                            ScpServer.log.debug((Object)("Writing block of " + buf.length + " bytes"));
                            this.pipeIn.write(buf);
                            continue;
                        }
                        catch (EOFException eofe) {
                            ScpServer.log.debug((Object)"End of file - finishing transfer");
                            break;
                        }
                    }
                    this.pipeIn.flush();
                    if (count < attr.getSize().intValue()) {
                        throw new IOException("File transfer terminated abnormally.");
                    }
                    ScpServer.log.info((Object)"File transfer complete.");
                    this.writeOk();
                }
                catch (Throwable var9_9) {
                    var8_10 = null;
                    if (handle == null) throw var9_9;
                    try {
                        this.nfs.closeFile(handle);
                        throw var9_9;
                    }
                    catch (Exception e) {
                        ScpServer.log.error((Object)e);
                    }
                    throw var9_9;
                }
                {
                    var8_11 = null;
                    if (handle == null) break block14;
                    ** try [egrp 2[TRYBLOCK] [3 : 360->372)] { 
lbl46:
                    // 1 sources

                    this.nfs.closeFile(handle);
lbl48:
                    // 1 sources

                    catch (Exception e) {
                        ScpServer.log.error((Object)e);
                    }
                }
            }
        }
        this.waitForResponse();
    }

    private void waitForResponse() throws IOException {
        log.debug((Object)"Waiting for response");
        int r = this.pipeOut.read();
        if (r == 0) {
            log.debug((Object)"Got Ok");
            return;
        }
        if (r == -1) {
            throw new EOFException("SCP returned unexpected EOF");
        }
        String msg = this.readString();
        log.debug((Object)("Got error '" + msg + "'"));
        if (r == 2) {
            log.debug((Object)"This is a serious error");
            throw new IOException(msg);
        }
        throw new IOException("SCP returned an unexpected error: " + msg);
    }

    /*
     * Exception decompiling
     */
    private void readFromRemote(String path) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 7[TRYBLOCK] [9 : 875->878)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void parseCommand(String cmd, String[] cmdParts) throws IOException {
        int l = cmd.indexOf(32);
        int r = cmd.indexOf(32, l + 1);
        if (l == -1 || r == -1) {
            this.writeError("Syntax error in cmd");
            throw new IOException("Syntax error in cmd");
        }
        cmdParts[0] = cmd.substring(1, l);
        cmdParts[1] = cmd.substring(l + 1, r);
        cmdParts[2] = cmd.substring(r + 1);
    }

    private String readString() throws IOException {
        int ch;
        int i = 0;
        while ((ch = this.pipeOut.read()) != 10 && ch >= 0) {
            this.buffer[i++] = (byte)ch;
        }
        if (ch == -1) {
            throw new EOFException("SCP returned unexpected EOF");
        }
        if (this.buffer[0] == 10) {
            throw new IOException("Unexpected <NL>");
        }
        if (this.buffer[0] == 2 || this.buffer[0] == 1) {
            String msg = new String(this.buffer, 1, i - 1);
            if (this.buffer[0] == 2) {
                throw new IOException(msg);
            }
            throw new IOException("SCP returned an unexpected error: " + msg);
        }
        return new String(this.buffer, 0, i);
    }
}

