/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.daemon.sftp;

import com.sshtools.daemon.platform.InvalidHandleException;
import com.sshtools.daemon.platform.NativeFileSystemProvider;
import com.sshtools.daemon.platform.PermissionDeniedException;
import com.sshtools.daemon.platform.UnsupportedFileOperationException;
import com.sshtools.daemon.session.SessionChannelServer;
import com.sshtools.daemon.subsystem.SubsystemServer;
import com.sshtools.j2ssh.SshThread;
import com.sshtools.j2ssh.connection.Channel;
import com.sshtools.j2ssh.connection.ChannelEventListener;
import com.sshtools.j2ssh.io.UnsignedInteger32;
import com.sshtools.j2ssh.sftp.SftpFile;
import com.sshtools.j2ssh.sftp.SshFxpAttrs;
import com.sshtools.j2ssh.sftp.SshFxpClose;
import com.sshtools.j2ssh.sftp.SshFxpData;
import com.sshtools.j2ssh.sftp.SshFxpFSetStat;
import com.sshtools.j2ssh.sftp.SshFxpFStat;
import com.sshtools.j2ssh.sftp.SshFxpHandle;
import com.sshtools.j2ssh.sftp.SshFxpInit;
import com.sshtools.j2ssh.sftp.SshFxpLStat;
import com.sshtools.j2ssh.sftp.SshFxpMkdir;
import com.sshtools.j2ssh.sftp.SshFxpName;
import com.sshtools.j2ssh.sftp.SshFxpOpen;
import com.sshtools.j2ssh.sftp.SshFxpOpenDir;
import com.sshtools.j2ssh.sftp.SshFxpRead;
import com.sshtools.j2ssh.sftp.SshFxpReadDir;
import com.sshtools.j2ssh.sftp.SshFxpReadlink;
import com.sshtools.j2ssh.sftp.SshFxpRealPath;
import com.sshtools.j2ssh.sftp.SshFxpRemove;
import com.sshtools.j2ssh.sftp.SshFxpRename;
import com.sshtools.j2ssh.sftp.SshFxpRmdir;
import com.sshtools.j2ssh.sftp.SshFxpSetStat;
import com.sshtools.j2ssh.sftp.SshFxpStat;
import com.sshtools.j2ssh.sftp.SshFxpStatus;
import com.sshtools.j2ssh.sftp.SshFxpSymlink;
import com.sshtools.j2ssh.sftp.SshFxpVersion;
import com.sshtools.j2ssh.sftp.SshFxpWrite;
import com.sshtools.j2ssh.subsystem.SubsystemMessage;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SftpSubsystemServer
extends SubsystemServer {
    public static final int VERSION_1 = 1;
    public static final int VERSION_2 = 2;
    public static final int VERSION_3 = 3;
    public static final int VERSION_4 = 4;
    private static Log log;
    private NativeFileSystemProvider nfs;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;
    static /* synthetic */ Class class$13;
    static /* synthetic */ Class class$14;
    static /* synthetic */ Class class$15;
    static /* synthetic */ Class class$16;
    static /* synthetic */ Class class$17;
    static /* synthetic */ Class class$18;
    static /* synthetic */ Class class$19;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.sshtools.daemon.sftp.SftpSubsystemServer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public SftpSubsystemServer() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("com.sshtools.j2ssh.sftp.SshFxpInit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.registerMessage(1, clazz);
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("com.sshtools.j2ssh.sftp.SshFxpMkdir");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.registerMessage(14, clazz2);
        Class<?> clazz3 = class$3;
        if (clazz3 == null) {
            try {
                clazz3 = class$3 = Class.forName("com.sshtools.j2ssh.sftp.SshFxpRealPath");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.registerMessage(16, clazz3);
        Class<?> clazz4 = class$4;
        if (clazz4 == null) {
            try {
                clazz4 = class$4 = Class.forName("com.sshtools.j2ssh.sftp.SshFxpOpenDir");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.registerMessage(11, clazz4);
        Class<?> clazz5 = class$5;
        if (clazz5 == null) {
            try {
                clazz5 = class$5 = Class.forName("com.sshtools.j2ssh.sftp.SshFxpOpen");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.registerMessage(3, clazz5);
        Class<?> clazz6 = class$6;
        if (clazz6 == null) {
            try {
                clazz6 = class$6 = Class.forName("com.sshtools.j2ssh.sftp.SshFxpRead");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.registerMessage(5, clazz6);
        Class<?> clazz7 = class$7;
        if (clazz7 == null) {
            try {
                clazz7 = class$7 = Class.forName("com.sshtools.j2ssh.sftp.SshFxpWrite");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.registerMessage(6, clazz7);
        Class<?> clazz8 = class$8;
        if (clazz8 == null) {
            try {
                clazz8 = class$8 = Class.forName("com.sshtools.j2ssh.sftp.SshFxpReadDir");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.registerMessage(12, clazz8);
        Class<?> clazz9 = class$9;
        if (clazz9 == null) {
            try {
                clazz9 = class$9 = Class.forName("com.sshtools.j2ssh.sftp.SshFxpClose");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.registerMessage(4, clazz9);
        Class<?> clazz10 = class$10;
        if (clazz10 == null) {
            try {
                clazz10 = class$10 = Class.forName("com.sshtools.j2ssh.sftp.SshFxpLStat");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.registerMessage(7, clazz10);
        Class<?> clazz11 = class$11;
        if (clazz11 == null) {
            try {
                clazz11 = class$11 = Class.forName("com.sshtools.j2ssh.sftp.SshFxpStat");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.registerMessage(17, clazz11);
        Class<?> clazz12 = class$12;
        if (clazz12 == null) {
            try {
                clazz12 = class$12 = Class.forName("com.sshtools.j2ssh.sftp.SshFxpRemove");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.registerMessage(13, clazz12);
        Class<?> clazz13 = class$13;
        if (clazz13 == null) {
            try {
                clazz13 = class$13 = Class.forName("com.sshtools.j2ssh.sftp.SshFxpRename");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.registerMessage(18, clazz13);
        Class<?> clazz14 = class$14;
        if (clazz14 == null) {
            try {
                clazz14 = class$14 = Class.forName("com.sshtools.j2ssh.sftp.SshFxpRmdir");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.registerMessage(15, clazz14);
        Class<?> clazz15 = class$15;
        if (clazz15 == null) {
            try {
                clazz15 = class$15 = Class.forName("com.sshtools.j2ssh.sftp.SshFxpSetStat");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.registerMessage(9, clazz15);
        Class<?> clazz16 = class$16;
        if (clazz16 == null) {
            try {
                clazz16 = class$16 = Class.forName("com.sshtools.j2ssh.sftp.SshFxpFStat");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.registerMessage(8, clazz16);
        Class<?> clazz17 = class$17;
        if (clazz17 == null) {
            try {
                clazz17 = class$17 = Class.forName("com.sshtools.j2ssh.sftp.SshFxpFSetStat");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.registerMessage(10, clazz17);
        Class<?> clazz18 = class$18;
        if (clazz18 == null) {
            try {
                clazz18 = class$18 = Class.forName("com.sshtools.j2ssh.sftp.SshFxpReadlink");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.registerMessage(19, clazz18);
        Class<?> clazz19 = class$19;
        if (clazz19 == null) {
            try {
                clazz19 = class$19 = Class.forName("com.sshtools.j2ssh.sftp.SshFxpSymlink");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.registerMessage(20, clazz19);
    }

    public void setSession(SessionChannelServer session) {
        session.addEventListener(new ChannelEventListener(){

            public void onChannelOpen(Channel channel) {
            }

            public void onChannelEOF(Channel channel) {
                try {
                    SftpSubsystemServer.this.session.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            public void onChannelClose(Channel channel) {
            }

            public void onDataReceived(Channel channel, byte[] data) {
            }

            public void onDataSent(Channel channel, byte[] data) {
            }
        });
        super.setSession(session);
    }

    protected void onMessageReceived(SubsystemMessage msg) {
        switch (msg.getMessageType()) {
            case 1: {
                this.onInitialize((SshFxpInit)msg);
                break;
            }
            case 14: {
                this.onMakeDirectory((SshFxpMkdir)msg);
                break;
            }
            case 16: {
                this.onRealPath((SshFxpRealPath)msg);
                break;
            }
            case 11: {
                this.onOpenDirectory((SshFxpOpenDir)msg);
                break;
            }
            case 3: {
                this.onOpenFile((SshFxpOpen)msg);
                break;
            }
            case 5: {
                this.onReadFile((SshFxpRead)msg);
                break;
            }
            case 6: {
                this.onWriteFile((SshFxpWrite)msg);
                break;
            }
            case 12: {
                this.onReadDirectory((SshFxpReadDir)msg);
                break;
            }
            case 7: {
                this.onLStat((SshFxpLStat)msg);
                break;
            }
            case 17: {
                this.onStat((SshFxpStat)msg);
                break;
            }
            case 8: {
                this.onFStat((SshFxpFStat)msg);
                break;
            }
            case 4: {
                this.onCloseFile((SshFxpClose)msg);
                break;
            }
            case 13: {
                this.onRemoveFile((SshFxpRemove)msg);
                break;
            }
            case 18: {
                this.onRenameFile((SshFxpRename)msg);
                break;
            }
            case 15: {
                this.onRemoveDirectory((SshFxpRmdir)msg);
                break;
            }
            case 9: {
                this.onSetAttributes((SshFxpSetStat)msg);
                break;
            }
            case 10: {
                this.onSetAttributes((SshFxpFSetStat)msg);
                break;
            }
            case 19: {
                this.onReadlink((SshFxpReadlink)msg);
                break;
            }
            case 20: {
                this.onSymlink((SshFxpSymlink)msg);
            }
        }
    }

    private void onSetAttributes(SshFxpSetStat msg) {
        SshFxpStatus reply;
        try {
            this.nfs.setFileAttributes(this.checkDefaultPath(msg.getPath()), msg.getAttributes());
            reply = new SshFxpStatus(msg.getId(), new UnsignedInteger32(0L), "The attributes were set", "");
        }
        catch (FileNotFoundException fnfe) {
            reply = new SshFxpStatus(msg.getId(), new UnsignedInteger32(2L), fnfe.getMessage(), "");
        }
        catch (PermissionDeniedException pde) {
            reply = new SshFxpStatus(msg.getId(), new UnsignedInteger32(3L), pde.getMessage(), "");
        }
        catch (IOException ioe) {
            reply = new SshFxpStatus(msg.getId(), new UnsignedInteger32(4L), ioe.getMessage(), "");
        }
        this.sendMessage(reply);
    }

    private void onSetAttributes(SshFxpFSetStat msg) {
        SshFxpStatus reply;
        try {
            this.nfs.setFileAttributes(msg.getHandle(), msg.getAttributes());
            reply = new SshFxpStatus(msg.getId(), new UnsignedInteger32(0L), "The attributes were set", "");
        }
        catch (InvalidHandleException ihe) {
            reply = new SshFxpStatus(msg.getId(), new UnsignedInteger32(4L), ihe.getMessage(), "");
        }
        catch (PermissionDeniedException pde) {
            reply = new SshFxpStatus(msg.getId(), new UnsignedInteger32(3L), pde.getMessage(), "");
        }
        catch (IOException ioe) {
            reply = new SshFxpStatus(msg.getId(), new UnsignedInteger32(4L), ioe.getMessage(), "");
        }
        this.sendMessage(reply);
    }

    private void onReadlink(SshFxpReadlink msg) {
        SubsystemMessage reply;
        try {
            reply = new SshFxpName(msg.getId(), new SftpFile[]{this.nfs.readSymbolicLink(this.checkDefaultPath(msg.getPath()))});
        }
        catch (FileNotFoundException ioe) {
            reply = new SshFxpStatus(msg.getId(), new UnsignedInteger32(2L), ioe.getMessage(), "");
        }
        catch (PermissionDeniedException pde) {
            reply = new SshFxpStatus(msg.getId(), new UnsignedInteger32(3L), pde.getMessage(), "");
        }
        catch (UnsupportedFileOperationException uso) {
            reply = new SshFxpStatus(msg.getId(), new UnsignedInteger32(8L), uso.getMessage(), "");
        }
        catch (IOException ioe2) {
            reply = new SshFxpStatus(msg.getId(), new UnsignedInteger32(4L), ioe2.getMessage(), "");
        }
        this.sendMessage(reply);
    }

    private void onSymlink(SshFxpSymlink msg) {
        SshFxpStatus reply;
        try {
            this.nfs.createSymbolicLink(this.checkDefaultPath(msg.getLinkPath()), this.checkDefaultPath(msg.getTargetPath()));
            reply = new SshFxpStatus(msg.getId(), new UnsignedInteger32(0L), "The symbolic link was created", "");
        }
        catch (FileNotFoundException ioe) {
            reply = new SshFxpStatus(msg.getId(), new UnsignedInteger32(2L), ioe.getMessage(), "");
        }
        catch (PermissionDeniedException pde) {
            reply = new SshFxpStatus(msg.getId(), new UnsignedInteger32(3L), pde.getMessage(), "");
        }
        catch (IOException ioe2) {
            reply = new SshFxpStatus(msg.getId(), new UnsignedInteger32(4L), ioe2.getMessage(), "");
        }
        catch (UnsupportedFileOperationException uso) {
            reply = new SshFxpStatus(msg.getId(), new UnsignedInteger32(8L), uso.getMessage(), "");
        }
        this.sendMessage(reply);
    }

    private void onRemoveDirectory(SshFxpRmdir msg) {
        SshFxpStatus reply;
        try {
            this.nfs.removeDirectory(this.checkDefaultPath(msg.getPath()));
            reply = new SshFxpStatus(msg.getId(), new UnsignedInteger32(0L), "The directory was removed", "");
        }
        catch (FileNotFoundException ioe) {
            reply = new SshFxpStatus(msg.getId(), new UnsignedInteger32(2L), ioe.getMessage(), "");
        }
        catch (IOException ioe2) {
            reply = new SshFxpStatus(msg.getId(), new UnsignedInteger32(4L), ioe2.getMessage(), "");
        }
        catch (PermissionDeniedException pde) {
            reply = new SshFxpStatus(msg.getId(), new UnsignedInteger32(3L), pde.getMessage(), "");
        }
        this.sendMessage(reply);
    }

    private void onRenameFile(SshFxpRename msg) {
        SshFxpStatus reply;
        try {
            this.nfs.renameFile(this.checkDefaultPath(msg.getOldPath()), this.checkDefaultPath(msg.getNewPath()));
            reply = new SshFxpStatus(msg.getId(), new UnsignedInteger32(0L), "The file was removed", "");
        }
        catch (FileNotFoundException ioe) {
            reply = new SshFxpStatus(msg.getId(), new UnsignedInteger32(2L), ioe.getMessage(), "");
        }
        catch (IOException ioe2) {
            reply = new SshFxpStatus(msg.getId(), new UnsignedInteger32(4L), ioe2.getMessage(), "");
        }
        catch (PermissionDeniedException pde) {
            reply = new SshFxpStatus(msg.getId(), new UnsignedInteger32(3L), pde.getMessage(), "");
        }
        this.sendMessage(reply);
    }

    private void onRemoveFile(SshFxpRemove msg) {
        SshFxpStatus reply;
        try {
            this.nfs.removeFile(this.checkDefaultPath(msg.getFilename()));
            reply = new SshFxpStatus(msg.getId(), new UnsignedInteger32(0L), "The file was removed", "");
        }
        catch (FileNotFoundException ioe) {
            reply = new SshFxpStatus(msg.getId(), new UnsignedInteger32(2L), ioe.getMessage(), "");
        }
        catch (IOException ioe2) {
            reply = new SshFxpStatus(msg.getId(), new UnsignedInteger32(4L), ioe2.getMessage(), "");
        }
        catch (PermissionDeniedException pde) {
            reply = new SshFxpStatus(msg.getId(), new UnsignedInteger32(3L), pde.getMessage(), "");
        }
        this.sendMessage(reply);
    }

    private void onOpenFile(SshFxpOpen msg) {
        SubsystemMessage reply;
        try {
            reply = new SshFxpHandle(msg.getId(), this.nfs.openFile(this.checkDefaultPath(msg.getFilename()), msg.getPflags(), msg.getAttributes()));
        }
        catch (FileNotFoundException ioe) {
            reply = new SshFxpStatus(msg.getId(), new UnsignedInteger32(2L), ioe.getMessage(), "");
        }
        catch (IOException ioe2) {
            reply = new SshFxpStatus(msg.getId(), new UnsignedInteger32(4L), ioe2.getMessage(), "");
        }
        catch (PermissionDeniedException pde) {
            reply = new SshFxpStatus(msg.getId(), new UnsignedInteger32(3L), pde.getMessage(), "");
        }
        this.sendMessage(reply);
    }

    private void onReadFile(SshFxpRead msg) {
        SubsystemMessage reply;
        try {
            reply = new SshFxpData(msg.getId(), this.nfs.readFile(msg.getHandle(), msg.getOffset(), msg.getLength()));
        }
        catch (EOFException eof) {
            reply = new SshFxpStatus(msg.getId(), new UnsignedInteger32(1L), eof.getMessage(), "");
        }
        catch (InvalidHandleException ihe) {
            reply = new SshFxpStatus(msg.getId(), new UnsignedInteger32(4L), ihe.getMessage(), "");
        }
        catch (IOException ioe2) {
            reply = new SshFxpStatus(msg.getId(), new UnsignedInteger32(4L), ioe2.getMessage(), "");
        }
        this.sendMessage(reply);
    }

    private void onWriteFile(SshFxpWrite msg) {
        SshFxpStatus reply;
        try {
            this.nfs.writeFile(msg.getHandle(), msg.getOffset(), msg.getData(), 0, msg.getData().length);
            reply = new SshFxpStatus(msg.getId(), new UnsignedInteger32(0L), "The write completed successfully", "");
        }
        catch (InvalidHandleException ihe) {
            reply = new SshFxpStatus(msg.getId(), new UnsignedInteger32(4L), ihe.getMessage(), "");
        }
        catch (IOException ioe2) {
            reply = new SshFxpStatus(msg.getId(), new UnsignedInteger32(4L), ioe2.getMessage(), "");
        }
        this.sendMessage(reply);
    }

    private void onCloseFile(SshFxpClose msg) {
        SshFxpStatus reply;
        try {
            this.nfs.closeFile(msg.getHandle());
            reply = new SshFxpStatus(msg.getId(), new UnsignedInteger32(0L), "The operation completed", "");
        }
        catch (InvalidHandleException ihe) {
            reply = new SshFxpStatus(msg.getId(), new UnsignedInteger32(4L), ihe.getMessage(), "");
        }
        catch (IOException ioe2) {
            reply = new SshFxpStatus(msg.getId(), new UnsignedInteger32(4L), ioe2.getMessage(), "");
        }
        this.sendMessage(reply);
    }

    private void onFStat(SshFxpFStat msg) {
        SubsystemMessage reply;
        try {
            reply = new SshFxpAttrs(msg.getId(), this.nfs.getFileAttributes(msg.getHandle()));
        }
        catch (InvalidHandleException ihe) {
            reply = new SshFxpStatus(msg.getId(), new UnsignedInteger32(4L), ihe.getMessage(), "");
        }
        catch (IOException ioe2) {
            reply = new SshFxpStatus(msg.getId(), new UnsignedInteger32(4L), ioe2.getMessage(), "");
        }
        this.sendMessage(reply);
    }

    private void onStat(SshFxpStat msg) {
        SubsystemMessage reply;
        try {
            String path = this.checkDefaultPath(msg.getPath());
            if (this.nfs.fileExists(path)) {
                SftpFile[] files = new SftpFile[1];
                reply = new SshFxpAttrs(msg.getId(), this.nfs.getFileAttributes(msg.getPath()));
            } else {
                reply = new SshFxpStatus(msg.getId(), new UnsignedInteger32(2L), String.valueOf(path) + " is not a valid file path", "");
            }
        }
        catch (FileNotFoundException ioe) {
            reply = new SshFxpStatus(msg.getId(), new UnsignedInteger32(2L), ioe.getMessage(), "");
        }
        catch (IOException ioe2) {
            reply = new SshFxpStatus(msg.getId(), new UnsignedInteger32(4L), ioe2.getMessage(), "");
        }
        this.sendMessage(reply);
    }

    private void onLStat(SshFxpLStat msg) {
        SubsystemMessage reply;
        try {
            String path = this.checkDefaultPath(msg.getPath());
            if (this.nfs.fileExists(path)) {
                SftpFile[] files = new SftpFile[1];
                reply = new SshFxpAttrs(msg.getId(), this.nfs.getFileAttributes(this.nfs.getCanonicalPath(msg.getPath())));
            } else {
                reply = new SshFxpStatus(msg.getId(), new UnsignedInteger32(2L), String.valueOf(path) + " is not a valid file path", "");
            }
        }
        catch (FileNotFoundException ioe) {
            reply = new SshFxpStatus(msg.getId(), new UnsignedInteger32(2L), ioe.getMessage(), "");
        }
        catch (IOException ioe2) {
            reply = new SshFxpStatus(msg.getId(), new UnsignedInteger32(4L), ioe2.getMessage(), "");
        }
        this.sendMessage(reply);
    }

    private void onReadDirectory(SshFxpReadDir msg) {
        SubsystemMessage reply;
        try {
            SftpFile[] sftpfiles = this.nfs.readDirectory(msg.getHandle());
            reply = new SshFxpName(msg.getId(), sftpfiles);
        }
        catch (FileNotFoundException ioe) {
            reply = new SshFxpStatus(msg.getId(), new UnsignedInteger32(2L), ioe.getMessage(), "");
        }
        catch (InvalidHandleException ihe) {
            reply = new SshFxpStatus(msg.getId(), new UnsignedInteger32(4L), ihe.getMessage(), "");
        }
        catch (EOFException eof) {
            reply = new SshFxpStatus(msg.getId(), new UnsignedInteger32(1L), eof.getMessage(), "");
        }
        catch (IOException ioe2) {
            reply = new SshFxpStatus(msg.getId(), new UnsignedInteger32(4L), ioe2.getMessage(), "");
        }
        this.sendMessage(reply);
    }

    private void onOpenDirectory(SshFxpOpenDir msg) {
        SubsystemMessage reply;
        try {
            String path = this.checkDefaultPath(msg.getPath());
            reply = new SshFxpHandle(msg.getId(), this.nfs.openDirectory(path));
        }
        catch (FileNotFoundException ioe) {
            reply = new SshFxpStatus(msg.getId(), new UnsignedInteger32(2L), ioe.getMessage(), "");
        }
        catch (IOException ioe2) {
            reply = new SshFxpStatus(msg.getId(), new UnsignedInteger32(4L), ioe2.getMessage(), "");
        }
        catch (PermissionDeniedException pde) {
            reply = new SshFxpStatus(msg.getId(), new UnsignedInteger32(3L), pde.getMessage(), "");
        }
        this.sendMessage(reply);
    }

    private void onRealPath(SshFxpRealPath msg) {
        SubsystemMessage reply;
        try {
            String path = this.nfs.getRealPath(this.checkDefaultPath(msg.getPath()));
            if (path != null) {
                SftpFile[] files = new SftpFile[]{new SftpFile(path)};
                reply = new SshFxpName(msg.getId(), files);
            } else {
                reply = new SshFxpStatus(msg.getId(), new UnsignedInteger32(4L), String.valueOf(msg.getPath()) + " could not be translated into a system dependent path", "");
            }
        }
        catch (FileNotFoundException ioe) {
            reply = new SshFxpStatus(msg.getId(), new UnsignedInteger32(2L), ioe.getMessage(), "");
        }
        catch (IOException ioe) {
            reply = new SshFxpStatus(msg.getId(), new UnsignedInteger32(4L), ioe.getMessage(), "");
        }
        this.sendMessage(reply);
    }

    private void onMakeDirectory(SshFxpMkdir msg) {
        SshFxpStatus reply;
        try {
            String path = this.checkDefaultPath(msg.getPath());
            reply = this.nfs.makeDirectory(path) ? new SshFxpStatus(msg.getId(), new UnsignedInteger32(0L), "The operation completed sucessfully", "") : new SshFxpStatus(msg.getId(), new UnsignedInteger32(4L), "The operation failed", "");
        }
        catch (FileNotFoundException ioe) {
            reply = new SshFxpStatus(msg.getId(), new UnsignedInteger32(2L), ioe.getMessage(), "");
        }
        catch (PermissionDeniedException pde) {
            reply = new SshFxpStatus(msg.getId(), new UnsignedInteger32(3L), pde.getMessage(), "");
        }
        catch (IOException ioe) {
            reply = new SshFxpStatus(msg.getId(), new UnsignedInteger32(4L), ioe.getMessage(), "");
        }
        this.sendMessage(reply);
    }

    private String checkDefaultPath(String path) throws IOException {
        if (path.equals("")) {
            return this.nfs.getDefaultPath(SshThread.getCurrentThreadUser());
        }
        return path;
    }

    private void onInitialize(SshFxpInit msg) {
        this.nfs = NativeFileSystemProvider.getInstance();
        if (msg.getVersion().intValue() == 3) {
            SshFxpVersion reply = new SshFxpVersion(new UnsignedInteger32(3L), null);
            this.sendMessage(reply);
        }
    }
}

