/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh;

import com.sshtools.j2ssh.SshClient;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.connection.ChannelEventListener;
import com.sshtools.j2ssh.session.SessionChannelClient;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public final class ScpClient {
    private SshClient ssh;
    private File cwd;
    private boolean verbose;
    private ChannelEventListener eventListener;

    public ScpClient(SshClient ssh, boolean verbose, ChannelEventListener eventListener) {
        this(new File(ConfigurationLoader.checkAndGetProperty("user.dir", ".")), ssh, verbose, eventListener);
    }

    public ScpClient(File cwd, SshClient ssh, boolean verbose, ChannelEventListener eventListener) {
        this.ssh = ssh;
        this.cwd = cwd;
        this.verbose = verbose;
        this.eventListener = eventListener;
    }

    public void put(InputStream in, long length, String localFile, String remoteFile) throws IOException {
        ScpChannel scp = new ScpChannel("scp -t " + (this.verbose ? "-v " : "") + remoteFile);
        scp.addEventListener(this.eventListener);
        if (!this.ssh.openChannel(scp)) {
            throw new IOException("Failed to open SCP channel");
        }
        scp.waitForResponse();
        scp.writeStreamToRemote(in, length, localFile);
        scp.close();
    }

    public InputStream get(String remoteFile) throws IOException {
        ScpChannel scp = new ScpChannel("scp -f " + (this.verbose ? "-v " : "") + remoteFile);
        scp.addEventListener(this.eventListener);
        if (!this.ssh.openChannel(scp)) {
            throw new IOException("Failed to open SCP Channel");
        }
        return scp.readStreamFromRemote();
    }

    public void put(String localFile, String remoteFile, boolean recursive) throws IOException {
        File lf = new File(localFile);
        if (!lf.isAbsolute()) {
            lf = new File(this.cwd, localFile);
        }
        if (!lf.exists()) {
            throw new IOException(String.valueOf(localFile) + " does not exist");
        }
        if (!lf.isFile() && !lf.isDirectory()) {
            throw new IOException(String.valueOf(localFile) + " is not a regular file or directory");
        }
        if (lf.isDirectory() && !recursive) {
            throw new IOException(String.valueOf(localFile) + " is a directory, use recursive mode");
        }
        if (remoteFile == null || remoteFile.equals("")) {
            remoteFile = ".";
        }
        ScpChannel scp = new ScpChannel("scp " + (lf.isDirectory() ? "-d " : "") + "-t " + (recursive ? "-r " : "") + (this.verbose ? "-v " : "") + remoteFile);
        scp.addEventListener(this.eventListener);
        if (!this.ssh.openChannel(scp)) {
            throw new IOException("Failed to open SCP channel");
        }
        scp.waitForResponse();
        scp.writeFileToRemote(lf, recursive);
        scp.close();
    }

    public void put(String[] localFiles, String remoteFile, boolean recursive) throws IOException {
        if (remoteFile == null || remoteFile.equals("")) {
            remoteFile = ".";
        }
        if (localFiles.length == 1) {
            this.put(localFiles[0], remoteFile, recursive);
        } else {
            ScpChannel scp = new ScpChannel("scp -d -t " + (recursive ? "-r " : "") + (this.verbose ? "-v " : "") + remoteFile);
            scp.addEventListener(this.eventListener);
            if (!this.ssh.openChannel(scp)) {
                throw new IOException("Failed to open SCP channel");
            }
            scp.waitForResponse();
            int i = 0;
            while (i < localFiles.length) {
                File lf = new File(localFiles[i]);
                if (!lf.isAbsolute()) {
                    lf = new File(this.cwd, localFiles[i]);
                }
                if (!lf.isFile() && !lf.isDirectory()) {
                    throw new IOException(String.valueOf(lf.getName()) + " is not a regular file or directory");
                }
                scp.writeFileToRemote(lf, recursive);
                ++i;
            }
            scp.close();
        }
    }

    public void get(String localFile, String[] remoteFiles, boolean recursive) throws IOException {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < remoteFiles.length) {
            buf.append("\"");
            buf.append(remoteFiles[i]);
            buf.append("\" ");
            ++i;
        }
        String remoteFile = buf.toString();
        remoteFile = remoteFile.trim();
        this.get(localFile, remoteFile, recursive);
    }

    public void get(String localFile, String remoteFile, boolean recursive) throws IOException {
        File lf;
        if (localFile == null || localFile.equals("")) {
            localFile = ".";
        }
        if (!(lf = new File(localFile)).isAbsolute()) {
            lf = new File(this.cwd, localFile);
        }
        if (lf.exists() && !lf.isFile() && !lf.isDirectory()) {
            throw new IOException(String.valueOf(localFile) + " is not a regular file or directory");
        }
        ScpChannel scp = new ScpChannel("scp -f " + (recursive ? "-r " : "") + (this.verbose ? "-v " : "") + remoteFile);
        scp.addEventListener(this.eventListener);
        if (!this.ssh.openChannel(scp)) {
            throw new IOException("Failed to open SCP Channel");
        }
        scp.readFromRemote(lf);
        scp.close();
    }

    class ScpChannel
    extends SessionChannelClient {
        byte[] buffer = new byte[16384];
        String cmd;

        ScpChannel(String cmd) {
            this.cmd = cmd;
            this.setName("scp");
        }

        protected void onChannelOpen() throws IOException {
            if (!this.executeCommand(this.cmd)) {
                throw new IOException("Failed to execute the command " + this.cmd);
            }
        }

        private boolean writeDirToRemote(File dir, boolean recursive) throws IOException {
            if (!recursive) {
                this.writeError("File " + dir.getName() + " is a directory, use recursive mode");
                return false;
            }
            String cmd = "D0755 0 " + dir.getName() + "\n";
            this.out.write(cmd.getBytes());
            this.waitForResponse();
            String[] list = dir.list();
            int i = 0;
            while (i < list.length) {
                File f = new File(dir, list[i]);
                this.writeFileToRemote(f, recursive);
                ++i;
            }
            this.out.write("E\n".getBytes());
            return true;
        }

        private void writeStreamToRemote(InputStream in, long length, String localName) throws IOException {
            String cmd = "C0644 " + length + " " + localName + "\n";
            this.out.write(cmd.getBytes());
            this.waitForResponse();
            this.writeCompleteFile(in, length);
            this.writeOk();
            this.waitForResponse();
        }

        private void writeFileToRemote(File file, boolean recursive) throws IOException {
            if (file.isDirectory()) {
                if (!this.writeDirToRemote(file, recursive)) {
                    return;
                }
            } else if (file.isFile()) {
                String cmd = "C0644 " + file.length() + " " + file.getName() + "\n";
                this.out.write(cmd.getBytes());
                this.waitForResponse();
                FileInputStream fi = new FileInputStream(file);
                this.writeCompleteFile(fi, file.length());
                this.writeOk();
            } else {
                throw new IOException(String.valueOf(file.getName()) + " not valid for SCP");
            }
            this.waitForResponse();
        }

        private void readFromRemote(File file) throws IOException {
            String cmd;
            String[] cmdParts = new String[3];
            this.writeOk();
            block7: while (true) {
                try {
                    cmd = this.readString();
                }
                catch (EOFException e) {
                    return;
                }
                char cmdChar = cmd.charAt(0);
                switch (cmdChar) {
                    case 'E': {
                        this.writeOk();
                        return;
                    }
                    case 'T': {
                        throw new IOException("SCP time not supported: " + cmd);
                    }
                    case 'C': 
                    case 'D': {
                        String targetName = file.getAbsolutePath();
                        this.parseCommand(cmd, cmdParts);
                        if (file.isDirectory()) {
                            targetName = String.valueOf(targetName) + File.separator + cmdParts[2];
                        }
                        File targetFile = new File(targetName);
                        if (cmdChar == 'D') {
                            String msg;
                            if (targetFile.exists()) {
                                if (!targetFile.isDirectory()) {
                                    msg = "Invalid target " + targetFile.getName() + ", must be a directory";
                                    this.writeError(msg);
                                    throw new IOException(msg);
                                }
                            } else if (!targetFile.mkdir()) {
                                msg = "Could not create directory: " + targetFile.getName();
                                this.writeError(msg);
                                throw new IOException(msg);
                            }
                            this.readFromRemote(targetFile);
                            continue block7;
                        }
                        FileOutputStream fo = new FileOutputStream(targetFile);
                        this.writeOk();
                        long len = Long.parseLong(cmdParts[1]);
                        this.readCompleteFile(fo, len);
                        this.waitForResponse();
                        this.writeOk();
                        continue block7;
                    }
                }
                break;
            }
            this.writeError("Unexpected cmd: " + cmd);
            throw new IOException("SCP unexpected cmd: " + cmd);
        }

        private InputStream readStreamFromRemote() throws IOException {
            String cmd;
            String[] cmdParts = new String[3];
            this.writeOk();
            try {
                cmd = this.readString();
            }
            catch (EOFException e) {
                return null;
            }
            char cmdChar = cmd.charAt(0);
            switch (cmdChar) {
                case 'E': {
                    this.writeOk();
                    return null;
                }
                case 'T': {
                    throw new IOException("SCP time not supported: " + cmd);
                }
                case 'D': {
                    throw new IOException("Directories cannot be copied to a stream");
                }
                case 'C': {
                    this.parseCommand(cmd, cmdParts);
                    this.writeOk();
                    long len = Long.parseLong(cmdParts[1]);
                    return new BufferedInputStream(new ScpInputStream(len, this.in, this), 16384);
                }
            }
            this.writeError("Unexpected cmd: " + cmd);
            throw new IOException("SCP unexpected cmd: " + cmd);
        }

        private void parseCommand(String cmd, String[] cmdParts) throws IOException {
            int l = cmd.indexOf(32);
            int r = cmd.indexOf(32, l + 1);
            if (l == -1 || r == -1) {
                this.writeError("Syntax error in cmd");
                throw new IOException("Syntax error in cmd");
            }
            cmdParts[0] = cmd.substring(1, l);
            cmdParts[1] = cmd.substring(l + 1, r);
            cmdParts[2] = cmd.substring(r + 1);
        }

        private String readString() throws IOException {
            int ch;
            int i = 0;
            while ((ch = this.in.read()) != 10 && ch >= 0) {
                this.buffer[i++] = (byte)ch;
            }
            if (ch == -1) {
                throw new EOFException("SCP returned unexpected EOF");
            }
            if (this.buffer[0] == 10) {
                throw new IOException("Unexpected <NL>");
            }
            if (this.buffer[0] == 2 || this.buffer[0] == 1) {
                String msg = new String(this.buffer, 1, i - 1);
                if (this.buffer[0] == 2) {
                    throw new IOException(msg);
                }
                throw new IOException("SCP returned an unexpected error: " + msg);
            }
            return new String(this.buffer, 0, i);
        }

        private void waitForResponse() throws IOException {
            int r = this.in.read();
            if (r == 0) {
                return;
            }
            if (r == -1) {
                throw new EOFException("SCP returned unexpected EOF");
            }
            String msg = this.readString();
            if (r == 2) {
                throw new IOException(msg);
            }
            throw new IOException("SCP returned an unexpected error: " + msg);
        }

        private void writeOk() throws IOException {
            this.out.write(0);
        }

        private void writeError(String reason) throws IOException {
            this.out.write(1);
            this.out.write(reason.getBytes());
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void writeCompleteFile(InputStream file, long size) throws IOException {
            int count = 0;
            try {
                while ((long)count < size) {
                    int read = file.read(this.buffer, 0, (int)(size - (long)count < (long)this.buffer.length ? size - (long)count : (long)this.buffer.length));
                    if (read == -1) {
                        throw new EOFException("SCP received an unexpected EOF");
                    }
                    count += read;
                    this.out.write(this.buffer, 0, read);
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                file.close();
                throw throwable;
            }
            {
                Object var6_7 = null;
            }
            file.close();
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void readCompleteFile(FileOutputStream file, long size) throws IOException {
            int count = 0;
            try {
                while ((long)count < size) {
                    int read = this.in.read(this.buffer, 0, (int)(size - (long)count < (long)this.buffer.length ? size - (long)count : (long)this.buffer.length));
                    if (read == -1) {
                        throw new EOFException("SCP received an unexpected EOF");
                    }
                    count += read;
                    file.write(this.buffer, 0, read);
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                file.close();
                throw throwable;
            }
            {
                Object var6_7 = null;
            }
            file.close();
        }
    }

    class ScpInputStream
    extends InputStream {
        long length;
        InputStream in;
        long count;
        ScpChannel channel;

        ScpInputStream(long length, InputStream in, ScpChannel channel) {
            this.length = length;
            this.in = in;
            this.channel = channel;
        }

        public int read() throws IOException {
            if (this.count == this.length) {
                return -1;
            }
            if (this.count >= this.length) {
                throw new EOFException("End of file.");
            }
            int r = this.in.read();
            if (r == -1) {
                throw new EOFException("Unexpected EOF.");
            }
            ++this.count;
            if (this.count == this.length) {
                this.channel.waitForResponse();
                this.channel.writeOk();
            }
            return r;
        }

        public void close() throws IOException {
            this.channel.close();
        }
    }
}

