/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh;

import com.sshtools.j2ssh.DirectoryOperation;
import com.sshtools.j2ssh.FileTransferProgress;
import com.sshtools.j2ssh.SshClient;
import com.sshtools.j2ssh.SshException;
import com.sshtools.j2ssh.TransferCancelledException;
import com.sshtools.j2ssh.connection.ChannelEventListener;
import com.sshtools.j2ssh.io.IOUtil;
import com.sshtools.j2ssh.io.UnsignedInteger32;
import com.sshtools.j2ssh.sftp.FileAttributes;
import com.sshtools.j2ssh.sftp.SftpFile;
import com.sshtools.j2ssh.sftp.SftpFileInputStream;
import com.sshtools.j2ssh.sftp.SftpFileOutputStream;
import com.sshtools.j2ssh.sftp.SftpSubsystemClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class SftpClient {
    SftpSubsystemClient sftp;
    String cwd;
    String lcwd;
    private int BLOCKSIZE = 65535;
    int umask = 18;
    int default_permissions = 511;

    SftpClient(SshClient ssh) throws IOException {
        this(ssh, null);
    }

    SftpClient(SshClient ssh, ChannelEventListener eventListener) throws IOException {
        if (!ssh.isConnected()) {
            throw new IOException("SshClient is not connected");
        }
        this.sftp = ssh.openSftpChannel(eventListener);
        this.cwd = this.sftp.getDefaultDirectory();
        this.lcwd = System.getProperty("user.home");
    }

    public int umask(int umask) {
        int old = umask;
        this.umask = umask;
        return old;
    }

    public void cd(String dir) throws IOException {
        try {
            String actual;
            if (dir.equals("")) {
                actual = this.sftp.getDefaultDirectory();
            } else {
                actual = this.resolveRemotePath(dir);
                actual = this.sftp.getAbsolutePath(actual);
            }
            FileAttributes attr = this.sftp.getAttributes(actual);
            if (!attr.isDirectory()) {
                throw new IOException(String.valueOf(dir) + " is not a directory");
            }
            this.cwd = actual;
        }
        catch (IOException ex) {
            throw new FileNotFoundException(String.valueOf(dir) + " could not be found");
        }
    }

    private File resolveLocalPath(String path) throws IOException {
        File f = new File(path);
        if (!f.isAbsolute()) {
            f = new File(this.lcwd, path);
        }
        return f;
    }

    private String resolveRemotePath(String path) throws IOException {
        this.verifyConnection();
        String actual = !path.startsWith("/") ? String.valueOf(this.cwd) + (this.cwd.endsWith("/") ? "" : "/") + path : path;
        return actual;
    }

    private void verifyConnection() throws SshException {
        if (this.sftp.isClosed()) {
            throw new SshException("The SFTP connection has been closed");
        }
    }

    public void mkdir(String dir) throws IOException {
        String actual = this.resolveRemotePath(dir);
        try {
            FileAttributes attrs = this.stat(actual);
            if (!attrs.isDirectory()) {
                throw new IOException("File already exists named " + dir);
            }
        }
        catch (IOException ex) {
            this.sftp.makeDirectory(actual);
            this.chmod(this.default_permissions ^ this.umask, actual);
        }
    }

    public void mkdirs(String dir) {
        StringTokenizer tokens = new StringTokenizer(dir, "/");
        String path = dir.startsWith("/") ? "/" : "";
        while (tokens.hasMoreElements()) {
            path = String.valueOf(path) + (String)tokens.nextElement();
            try {
                this.stat(path);
            }
            catch (IOException ex) {
                try {
                    this.mkdir(path);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            path = String.valueOf(path) + "/";
        }
    }

    public String pwd() {
        return this.cwd;
    }

    public List ls() throws IOException {
        return this.ls(this.cwd);
    }

    public List ls(String path) throws IOException {
        String actual = this.resolveRemotePath(path);
        FileAttributes attrs = this.sftp.getAttributes(actual);
        if (!attrs.isDirectory()) {
            throw new IOException(String.valueOf(path) + " is not a directory");
        }
        SftpFile file = this.sftp.openDirectory(actual);
        Vector children = new Vector();
        while (this.sftp.listChildren(file, children) > -1) {
        }
        file.close();
        return children;
    }

    public void lcd(String path) throws IOException {
        File actual = !SftpClient.isLocalAbsolutePath(path) ? new File(this.lcwd, path) : new File(path);
        if (!actual.isDirectory()) {
            throw new IOException(String.valueOf(path) + " is not a directory");
        }
        this.lcwd = actual.getCanonicalPath();
    }

    private static boolean isLocalAbsolutePath(String path) {
        return new File(path).isAbsolute();
    }

    public String lpwd() {
        return this.lcwd;
    }

    public FileAttributes get(String path, FileTransferProgress progress) throws IOException, TransferCancelledException {
        String localfile = path.lastIndexOf("/") > -1 ? path.substring(path.lastIndexOf("/") + 1) : path;
        return this.get(path, localfile, progress);
    }

    public FileAttributes get(String path) throws IOException {
        return this.get(path, (FileTransferProgress)null);
    }

    private void transferFile(InputStream in, OutputStream out) throws IOException, TransferCancelledException {
        this.transferFile(in, out, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void transferFile(InputStream in, OutputStream out, FileTransferProgress progress) throws IOException, TransferCancelledException {
        try {
            int read;
            long bytesSoFar = 0L;
            byte[] buffer = new byte[this.BLOCKSIZE];
            while ((read = in.read(buffer)) > -1) {
                if (progress != null && progress.isCancelled()) {
                    throw new TransferCancelledException();
                }
                if (read <= 0) continue;
                out.write(buffer, 0, read);
                bytesSoFar += (long)read;
                if (progress == null) continue;
                progress.progressed(bytesSoFar);
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            try {
                in.close();
                out.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        {
            Object var8_9 = null;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        in.close();
        out.close();
    }

    public FileAttributes get(String remote, String local, FileTransferProgress progress) throws IOException, TransferCancelledException {
        File localPath = this.resolveLocalPath(local);
        if (!localPath.exists()) {
            localPath.getParentFile().mkdirs();
            localPath.createNewFile();
        }
        FileOutputStream out = new FileOutputStream(localPath);
        return this.get(remote, out, progress);
    }

    public FileAttributes get(String remote, String local) throws IOException {
        return this.get(remote, local, null);
    }

    public FileAttributes get(String remote, OutputStream local, FileTransferProgress progress) throws IOException, TransferCancelledException {
        String remotePath = this.resolveRemotePath(remote);
        FileAttributes attrs = this.stat(remotePath);
        if (progress != null) {
            progress.started(attrs.getSize().longValue(), remotePath);
        }
        SftpFileInputStream in = new SftpFileInputStream(this.sftp.openFile(remotePath, 1));
        this.transferFile(in, local, progress);
        if (progress != null) {
            progress.completed();
        }
        return attrs;
    }

    public FileAttributes get(String remote, OutputStream local) throws IOException {
        return this.get(remote, local, null);
    }

    public boolean isClosed() {
        return this.sftp.isClosed();
    }

    public void put(String local, FileTransferProgress progress) throws IOException, TransferCancelledException {
        File f = new File(local);
        this.put(local, f.getName(), progress);
    }

    public void put(String local) throws IOException {
        this.put(local, (FileTransferProgress)null);
    }

    public void put(String local, String remote, FileTransferProgress progress) throws IOException, TransferCancelledException {
        File localPath = this.resolveLocalPath(local);
        FileInputStream in = new FileInputStream(localPath);
        try {
            FileAttributes attrs = this.stat(remote);
            if (attrs.isDirectory()) {
                File f = new File(local);
                remote = String.valueOf(remote) + (remote.endsWith("/") ? "" : "/") + f.getName();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.put(in, remote, progress);
    }

    public void put(String local, String remote) throws IOException {
        this.put(local, remote, null);
    }

    public void put(InputStream in, String remote, FileTransferProgress progress) throws IOException, TransferCancelledException {
        SftpFileOutputStream out;
        String remotePath = this.resolveRemotePath(remote);
        boolean newfile = false;
        try {
            FileAttributes attrs = this.stat(remotePath);
            out = new SftpFileOutputStream(this.sftp.openFile(remotePath, 26));
        }
        catch (IOException ex) {
            FileAttributes attrs = new FileAttributes();
            newfile = true;
            attrs.setPermissions(new UnsignedInteger32(this.default_permissions ^ this.umask));
            out = new SftpFileOutputStream(this.sftp.openFile(remotePath, 10, attrs));
        }
        if (progress != null) {
            progress.started(in.available(), remotePath);
        }
        this.transferFile(in, out, progress);
        if (progress != null) {
            progress.completed();
        }
        if (newfile) {
            this.chmod(this.default_permissions ^ this.umask, remotePath);
        }
    }

    public void put(InputStream in, String remote) throws IOException {
        this.put(in, remote, null);
    }

    public void chown(int uid, String path) throws IOException {
        String actual = this.resolveRemotePath(path);
        FileAttributes attrs = this.sftp.getAttributes(actual);
        attrs.setUID(new UnsignedInteger32(uid));
        this.sftp.setAttributes(actual, attrs);
    }

    public void chgrp(int gid, String path) throws IOException {
        String actual = this.resolveRemotePath(path);
        FileAttributes attrs = this.sftp.getAttributes(actual);
        attrs.setGID(new UnsignedInteger32(gid));
        this.sftp.setAttributes(actual, attrs);
    }

    public void chmod(int permissions, String path) throws IOException {
        String actual = this.resolveRemotePath(path);
        this.sftp.changePermissions(actual, permissions);
    }

    public void umask(String umask) throws IOException {
        try {
            this.umask = Integer.parseInt(umask, 8);
        }
        catch (NumberFormatException ex) {
            throw new IOException("umask must be 4 digit octal number e.g. 0022");
        }
    }

    public void rename(String oldpath, String newpath) throws IOException {
        String from = this.resolveRemotePath(oldpath);
        String to = this.resolveRemotePath(newpath);
        this.sftp.renameFile(from, to);
    }

    public void rm(String path) throws IOException {
        String actual = this.resolveRemotePath(path);
        FileAttributes attrs = this.sftp.getAttributes(actual);
        if (attrs.isDirectory()) {
            this.sftp.removeDirectory(actual);
        } else {
            this.sftp.removeFile(actual);
        }
    }

    public void rm(String path, boolean force, boolean recurse) throws IOException {
        String actual = this.resolveRemotePath(path);
        FileAttributes attrs = this.sftp.getAttributes(actual);
        if (attrs.isDirectory()) {
            List list = this.ls(path);
            if (!force && list.size() > 0) {
                throw new IOException("You cannot delete non-empty directory, use force=true to overide");
            }
            Iterator it = list.iterator();
            while (it.hasNext()) {
                SftpFile file = (SftpFile)it.next();
                if (file.isDirectory() && !file.getFilename().equals(".") && !file.getFilename().equals("..")) {
                    if (recurse) {
                        this.rm(file.getAbsolutePath(), force, recurse);
                        continue;
                    }
                    throw new IOException("Directory has contents, cannot delete without recurse=true");
                }
                if (!file.isFile()) continue;
                this.sftp.removeFile(file.getAbsolutePath());
            }
            this.sftp.removeDirectory(actual);
        } else {
            this.sftp.removeFile(actual);
        }
    }

    public void symlink(String path, String link) throws IOException {
        String actualPath = this.resolveRemotePath(path);
        String actualLink = this.resolveRemotePath(link);
        this.sftp.createSymbolicLink(actualPath, actualLink);
    }

    public FileAttributes stat(String path) throws IOException {
        String actual = this.resolveRemotePath(path);
        return this.sftp.getAttributes(actual);
    }

    public String getAbsolutePath(String path) throws IOException {
        String actual = this.resolveRemotePath(path);
        return this.sftp.getAbsolutePath(path);
    }

    public void quit() throws IOException {
        this.sftp.close();
    }

    public DirectoryOperation copyLocalDirectory(String localdir, String remotedir, boolean recurse, boolean sync, boolean commit, FileTransferProgress progress) throws IOException {
        File[] ls;
        DirectoryOperation op = new DirectoryOperation();
        String pwd = this.pwd();
        String lpwd = this.lpwd();
        File local = this.resolveLocalPath(localdir);
        remotedir = this.resolveRemotePath(remotedir);
        remotedir = String.valueOf(remotedir) + (remotedir.endsWith("/") ? "" : "/");
        remotedir = String.valueOf(remotedir) + local.getName();
        remotedir = String.valueOf(remotedir) + (remotedir.endsWith("/") ? "" : "/");
        if (commit) {
            try {
                FileAttributes attrs = this.stat(remotedir);
            }
            catch (IOException ex) {
                this.mkdir(remotedir);
            }
        }
        if ((ls = local.listFiles()) != null) {
            int i = 0;
            while (i < ls.length) {
                if (ls[i].isDirectory() && !ls[i].getName().equals(".") && !ls[i].getName().equals("..")) {
                    if (recurse) {
                        File f = new File(local, ls[i].getName());
                        op.addDirectoryOperation(this.copyLocalDirectory(f.getAbsolutePath(), remotedir, recurse, sync, commit, progress), f);
                    }
                } else if (ls[i].isFile()) {
                    FileAttributes attrs;
                    try {
                        attrs = this.stat(String.valueOf(remotedir) + ls[i].getName());
                        if (ls[i].length() == attrs.getSize().longValue() && ls[i].lastModified() / 1000L == attrs.getModifiedTime().longValue()) {
                            op.addUnchangedFile(ls[i]);
                        } else {
                            op.addUpdatedFile(ls[i]);
                        }
                    }
                    catch (IOException ex1) {
                        op.addNewFile(ls[i]);
                    }
                    if (commit) {
                        this.put(ls[i].getAbsolutePath(), String.valueOf(remotedir) + ls[i].getName(), progress);
                        attrs = this.stat(String.valueOf(remotedir) + ls[i].getName());
                        attrs.setTimes(new UnsignedInteger32(ls[i].lastModified() / 1000L), new UnsignedInteger32(ls[i].lastModified() / 1000L));
                        this.sftp.setAttributes(String.valueOf(remotedir) + ls[i].getName(), attrs);
                    }
                }
                ++i;
            }
        }
        if (sync) {
            try {
                List files = this.ls(remotedir);
                Iterator it = files.iterator();
                while (it.hasNext()) {
                    SftpFile file = (SftpFile)it.next();
                    File f = new File(local, file.getFilename());
                    if (op.containsFile(file) || file.getFilename().equals(".") || file.getFilename().equals("..")) continue;
                    op.addDeletedFile(file);
                    if (!commit) continue;
                    if (file.isDirectory()) {
                        this.recurseMarkForDeletion(file, op);
                        if (!commit) continue;
                        this.rm(file.getAbsolutePath(), true, true);
                        continue;
                    }
                    if (!file.isFile()) continue;
                    this.rm(file.getAbsolutePath());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return op;
    }

    public void addEventListener(ChannelEventListener eventListener) {
        this.sftp.addEventListener(eventListener);
    }

    private void recurseMarkForDeletion(SftpFile file, DirectoryOperation op) throws IOException {
        List list = this.ls(file.getAbsolutePath());
        op.addDeletedFile(file);
        Iterator it = list.iterator();
        while (it.hasNext()) {
            file = (SftpFile)it.next();
            if (file.isDirectory() && !file.getFilename().equals(".") && !file.getFilename().equals("..")) {
                this.recurseMarkForDeletion(file, op);
                continue;
            }
            if (!file.isFile()) continue;
            op.addDeletedFile(file);
        }
    }

    private void recurseMarkForDeletion(File file, DirectoryOperation op) throws IOException {
        File[] list = file.listFiles();
        op.addDeletedFile(file);
        if (list != null) {
            int i = 0;
            while (i < list.length) {
                file = list[i];
                if (file.isDirectory() && !file.getName().equals(".") && !file.getName().equals("..")) {
                    this.recurseMarkForDeletion(file, op);
                } else if (file.isFile()) {
                    op.addDeletedFile(file);
                }
                ++i;
            }
        }
    }

    public DirectoryOperation copyRemoteDirectory(String remotedir, String localdir, boolean recurse, boolean sync, boolean commit, FileTransferProgress progress) throws IOException {
        File[] contents;
        File local;
        DirectoryOperation op = new DirectoryOperation();
        String pwd = this.pwd();
        String lpwd = this.lpwd();
        this.cd(remotedir);
        String base = remotedir;
        int idx = base.lastIndexOf(47);
        if (idx != -1) {
            base = base.substring(idx + 1);
        }
        if (!(local = new File(localdir, base)).isAbsolute()) {
            local = new File(this.lpwd(), localdir);
        }
        if (!local.exists() && commit) {
            local.mkdir();
        }
        List files = this.ls();
        Iterator it = files.iterator();
        while (it.hasNext()) {
            File f;
            SftpFile file = (SftpFile)it.next();
            if (file.isDirectory() && !file.getFilename().equals(".") && !file.getFilename().equals("..")) {
                if (!recurse) continue;
                f = new File(local, file.getFilename());
                op.addDirectoryOperation(this.copyRemoteDirectory(file.getFilename(), local.getAbsolutePath(), recurse, sync, commit, progress), f);
                continue;
            }
            if (!file.isFile()) continue;
            f = new File(local, file.getFilename());
            if (f.exists() && f.length() == file.getAttributes().getSize().longValue() && f.lastModified() / 1000L == file.getAttributes().getModifiedTime().longValue()) {
                if (commit) {
                    op.addUnchangedFile(f);
                    continue;
                }
                op.addUnchangedFile(file);
                continue;
            }
            if (f.exists()) {
                if (commit) {
                    op.addUpdatedFile(f);
                } else {
                    op.addUpdatedFile(file);
                }
            } else if (commit) {
                op.addNewFile(f);
            } else {
                op.addNewFile(file);
            }
            if (!commit) continue;
            FileAttributes attrs = this.get(file.getFilename(), f.getAbsolutePath(), progress);
            f.setLastModified(attrs.getModifiedTime().longValue() * 1000L);
        }
        if (sync && (contents = local.listFiles()) != null) {
            int i = 0;
            while (i < contents.length) {
                if (!op.containsFile(contents[i])) {
                    op.addDeletedFile(contents[i]);
                    if (contents[i].isDirectory() && !contents[i].getName().equals(".") && !contents[i].getName().equals("..")) {
                        this.recurseMarkForDeletion(contents[i], op);
                        if (commit) {
                            IOUtil.recurseDeleteDirectory(contents[i]);
                        }
                    } else if (commit) {
                        contents[i].delete();
                    }
                }
                ++i;
            }
        }
        this.cd(pwd);
        return op;
    }
}

