/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.agent;

import com.sshtools.j2ssh.agent.AgentNotAvailableException;
import com.sshtools.j2ssh.agent.KeyConstraints;
import com.sshtools.j2ssh.agent.SshAgentAddKey;
import com.sshtools.j2ssh.agent.SshAgentAlive;
import com.sshtools.j2ssh.agent.SshAgentDeleteAllKeys;
import com.sshtools.j2ssh.agent.SshAgentDeleteKey;
import com.sshtools.j2ssh.agent.SshAgentForwardingNotice;
import com.sshtools.j2ssh.agent.SshAgentKeyList;
import com.sshtools.j2ssh.agent.SshAgentListKeys;
import com.sshtools.j2ssh.agent.SshAgentLock;
import com.sshtools.j2ssh.agent.SshAgentOperationComplete;
import com.sshtools.j2ssh.agent.SshAgentPing;
import com.sshtools.j2ssh.agent.SshAgentPrivateKeyOp;
import com.sshtools.j2ssh.agent.SshAgentRandom;
import com.sshtools.j2ssh.agent.SshAgentRandomData;
import com.sshtools.j2ssh.agent.SshAgentRequestVersion;
import com.sshtools.j2ssh.agent.SshAgentSuccess;
import com.sshtools.j2ssh.agent.SshAgentUnlock;
import com.sshtools.j2ssh.agent.SshAgentVersionResponse;
import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.subsystem.SubsystemMessage;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKey;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshAgentClient {
    private static Log log;
    public static final String HASH_AND_SIGN = "hash-and-sign";
    InputStream in;
    OutputStream out;
    boolean isForwarded = false;
    HashMap messages = new HashMap();
    Socket socket;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.sshtools.j2ssh.agent.SshAgentClient");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    SshAgentClient(boolean isForwarded, String application, InputStream in, OutputStream out) throws IOException {
        log.info((Object)"New SshAgentClient instance created");
        this.in = in;
        this.out = out;
        this.isForwarded = isForwarded;
        this.registerMessages();
        if (isForwarded) {
            this.sendForwardingNotice();
        } else {
            this.sendVersionRequest(application);
        }
    }

    SshAgentClient(boolean isForwarded, String application, Socket socket) throws IOException {
        log.info((Object)"New SshAgentClient instance created");
        this.socket = socket;
        this.in = socket.getInputStream();
        this.out = socket.getOutputStream();
        this.isForwarded = isForwarded;
        this.registerMessages();
        if (isForwarded) {
            this.sendForwardingNotice();
        } else {
            this.sendVersionRequest(application);
        }
    }

    public static SshAgentClient connectLocalAgent(String application, String location) throws AgentNotAvailableException, IOException {
        try {
            Socket socket = SshAgentClient.connectAgentSocket(location);
            return new SshAgentClient(false, application, socket);
        }
        catch (IOException ex) {
            throw new AgentNotAvailableException();
        }
    }

    public static Socket connectAgentSocket(String location) throws AgentNotAvailableException, IOException {
        try {
            if (location == null) {
                throw new AgentNotAvailableException();
            }
            int idx = location.indexOf(":");
            if (idx == -1) {
                throw new AgentNotAvailableException();
            }
            String host = location.substring(0, idx);
            int port = Integer.parseInt(location.substring(idx + 1));
            Socket socket = new Socket(host, port);
            return socket;
        }
        catch (IOException ex) {
            throw new AgentNotAvailableException();
        }
    }

    public void close() {
        log.info((Object)"Closing agent client");
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void registerMessages() {
        Integer n = new Integer(103);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("com.sshtools.j2ssh.agent.SshAgentVersionResponse");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.messages.put(n, clazz);
        Integer n2 = new Integer(101);
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("com.sshtools.j2ssh.agent.SshAgentSuccess");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.messages.put(n2, clazz2);
        Integer n3 = new Integer(102);
        Class<?> clazz3 = class$3;
        if (clazz3 == null) {
            try {
                clazz3 = class$3 = Class.forName("com.sshtools.j2ssh.agent.SshAgentFailure");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.messages.put(n3, clazz3);
        Integer n4 = new Integer(104);
        Class<?> clazz4 = class$4;
        if (clazz4 == null) {
            try {
                clazz4 = class$4 = Class.forName("com.sshtools.j2ssh.agent.SshAgentKeyList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.messages.put(n4, clazz4);
        Integer n5 = new Integer(106);
        Class<?> clazz5 = class$5;
        if (clazz5 == null) {
            try {
                clazz5 = class$5 = Class.forName("com.sshtools.j2ssh.agent.SshAgentRandomData");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.messages.put(n5, clazz5);
        Integer n6 = new Integer(150);
        Class<?> clazz6 = class$6;
        if (clazz6 == null) {
            try {
                clazz6 = class$6 = Class.forName("com.sshtools.j2ssh.agent.SshAgentAlive");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.messages.put(n6, clazz6);
        Integer n7 = new Integer(105);
        Class<?> clazz7 = class$7;
        if (clazz7 == null) {
            try {
                clazz7 = class$7 = Class.forName("com.sshtools.j2ssh.agent.SshAgentOperationComplete");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.messages.put(n7, clazz7);
    }

    protected void sendVersionRequest(String application) throws IOException {
        SubsystemMessage msg = new SshAgentRequestVersion(application);
        this.sendMessage(msg);
        msg = this.readMessage();
        if (msg instanceof SshAgentVersionResponse) {
            SshAgentVersionResponse reply = (SshAgentVersionResponse)msg;
            if (reply.getVersion() != 2) {
                throw new IOException("The agent verison is not compatible with verison 2");
            }
        } else {
            throw new IOException("The agent did not respond with the appropriate version");
        }
    }

    public void addKey(SshPrivateKey prvkey, SshPublicKey pubkey, String description, KeyConstraints constraints) throws IOException {
        SubsystemMessage msg = new SshAgentAddKey(prvkey, pubkey, description, constraints);
        this.sendMessage(msg);
        msg = this.readMessage();
        if (!(msg instanceof SshAgentSuccess)) {
            throw new IOException("The key could not be added");
        }
    }

    public byte[] hashAndSign(SshPublicKey key, byte[] data) throws IOException {
        SubsystemMessage msg = new SshAgentPrivateKeyOp(key, HASH_AND_SIGN, data);
        this.sendMessage(msg);
        msg = this.readMessage();
        if (msg instanceof SshAgentOperationComplete) {
            return ((SshAgentOperationComplete)msg).getData();
        }
        throw new IOException("The operation failed");
    }

    public Map listKeys() throws IOException {
        SubsystemMessage msg = new SshAgentListKeys();
        this.sendMessage(msg);
        msg = this.readMessage();
        if (msg instanceof SshAgentKeyList) {
            return ((SshAgentKeyList)msg).getKeys();
        }
        throw new IOException("The agent responsed with an invalid message");
    }

    public boolean lockAgent(String password) throws IOException {
        SubsystemMessage msg = new SshAgentLock(password);
        this.sendMessage(msg);
        msg = this.readMessage();
        return msg instanceof SshAgentSuccess;
    }

    public boolean unlockAgent(String password) throws IOException {
        SubsystemMessage msg = new SshAgentUnlock(password);
        this.sendMessage(msg);
        msg = this.readMessage();
        return msg instanceof SshAgentSuccess;
    }

    public byte[] getRandomData(int count) throws IOException {
        SubsystemMessage msg = new SshAgentRandom(count);
        this.sendMessage(msg);
        msg = this.readMessage();
        if (msg instanceof SshAgentRandomData) {
            return ((SshAgentRandomData)msg).getRandomData();
        }
        throw new IOException("Agent failed to provide the request random data");
    }

    public void ping(byte[] padding) throws IOException {
        SubsystemMessage msg = new SshAgentPing(padding);
        this.sendMessage(msg);
        msg = this.readMessage();
        if (msg instanceof SshAgentAlive) {
            if (!Arrays.equals(padding, ((SshAgentAlive)msg).getPadding())) {
                throw new IOException("Agent failed to reply with expected data");
            }
        } else {
            throw new IOException("Agent failed to provide the request random data");
        }
    }

    public void deleteKey(SshPublicKey key, String description) throws IOException {
        SubsystemMessage msg = new SshAgentDeleteKey(key, description);
        this.sendMessage(msg);
        msg = this.readMessage();
        if (!(msg instanceof SshAgentSuccess)) {
            throw new IOException("The agent failed to delete the key");
        }
    }

    public void deleteAllKeys() throws IOException {
        SubsystemMessage msg = new SshAgentDeleteAllKeys();
        this.sendMessage(msg);
        msg = this.readMessage();
        if (!(msg instanceof SshAgentSuccess)) {
            throw new IOException("The agent failed to delete all keys");
        }
    }

    protected void sendForwardingNotice() throws IOException {
        InetAddress addr = InetAddress.getLocalHost();
        SshAgentForwardingNotice msg = new SshAgentForwardingNotice(addr.getHostName(), addr.getHostAddress(), 22);
        this.sendMessage(msg);
    }

    protected void sendMessage(SubsystemMessage msg) throws IOException {
        log.info((Object)("Sending message " + msg.getMessageName()));
        byte[] msgdata = msg.toByteArray();
        this.out.write(ByteArrayWriter.encodeInt(msgdata.length));
        this.out.write(msgdata);
        this.out.flush();
    }

    protected SubsystemMessage readMessage() throws InvalidMessageException {
        try {
            byte[] lendata = new byte[4];
            int len = 0;
            while (len < 3) {
                len += this.in.read(lendata, len, lendata.length - len);
            }
            len = (int)ByteArrayReader.readInt(lendata, 0);
            byte[] msgdata = new byte[len];
            len = 0;
            while (len < msgdata.length) {
                len += this.in.read(msgdata, len, msgdata.length - len);
            }
            Integer id = new Integer(msgdata[0] & 0xFF);
            if (this.messages.containsKey(id)) {
                Class cls = (Class)this.messages.get(id);
                SubsystemMessage msg = (SubsystemMessage)cls.newInstance();
                msg.fromByteArray(msgdata);
                log.info((Object)("Received message " + msg.getMessageName()));
                return msg;
            }
            throw new InvalidMessageException("Unrecognised message id " + id.toString());
        }
        catch (Exception ex) {
            throw new InvalidMessageException(ex.getMessage());
        }
    }
}

