/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.agent;

import com.sshtools.j2ssh.agent.ForwardingNotice;
import com.sshtools.j2ssh.agent.KeyStore;
import com.sshtools.j2ssh.agent.KeyTimeoutException;
import com.sshtools.j2ssh.agent.SshAgentAddKey;
import com.sshtools.j2ssh.agent.SshAgentAlive;
import com.sshtools.j2ssh.agent.SshAgentDeleteAllKeys;
import com.sshtools.j2ssh.agent.SshAgentDeleteKey;
import com.sshtools.j2ssh.agent.SshAgentFailure;
import com.sshtools.j2ssh.agent.SshAgentForwardingNotice;
import com.sshtools.j2ssh.agent.SshAgentKeyList;
import com.sshtools.j2ssh.agent.SshAgentListKeys;
import com.sshtools.j2ssh.agent.SshAgentLock;
import com.sshtools.j2ssh.agent.SshAgentOperationComplete;
import com.sshtools.j2ssh.agent.SshAgentPing;
import com.sshtools.j2ssh.agent.SshAgentPrivateKeyOp;
import com.sshtools.j2ssh.agent.SshAgentRandom;
import com.sshtools.j2ssh.agent.SshAgentRandomData;
import com.sshtools.j2ssh.agent.SshAgentRequestVersion;
import com.sshtools.j2ssh.agent.SshAgentSuccess;
import com.sshtools.j2ssh.agent.SshAgentUnlock;
import com.sshtools.j2ssh.agent.SshAgentVersionResponse;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.subsystem.SubsystemMessage;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshAgentConnection
implements Runnable {
    private static Log log;
    InputStream in;
    OutputStream out;
    KeyStore keystore;
    Thread thread;
    Vector forwardingNodes = new Vector();
    Socket socket;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.sshtools.j2ssh.agent.SshAgentConnection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    SshAgentConnection(KeyStore keystore, InputStream in, OutputStream out) {
        this.keystore = keystore;
        this.in = in;
        this.out = out;
        this.thread = new Thread(this);
        this.thread.start();
    }

    SshAgentConnection(KeyStore keystore, Socket socket) throws IOException {
        this.keystore = keystore;
        this.in = socket.getInputStream();
        this.out = socket.getOutputStream();
        this.socket = socket;
        socket.setSoTimeout(5000);
        this.thread = new Thread(this);
        this.thread.start();
    }

    protected void sendAgentSuccess() throws IOException {
        SshAgentSuccess msg = new SshAgentSuccess();
        this.sendMessage(msg);
    }

    protected void sendAgentFailure(int errorcode) throws IOException {
        SshAgentFailure msg = new SshAgentFailure(errorcode);
        this.sendMessage(msg);
    }

    protected void sendVersionResponse() throws IOException {
        SshAgentVersionResponse msg = new SshAgentVersionResponse(2);
        this.sendMessage(msg);
    }

    protected void sendAgentKeyList() throws IOException {
        SshAgentKeyList msg = new SshAgentKeyList(this.keystore.getPublicKeys());
        this.sendMessage(msg);
    }

    protected void sendOperationComplete(byte[] data) throws IOException {
        SshAgentOperationComplete msg = new SshAgentOperationComplete(data);
        this.sendMessage(msg);
    }

    protected void sendRandomData(byte[] data) throws IOException {
        SshAgentRandomData msg = new SshAgentRandomData(data);
        this.sendMessage(msg);
    }

    protected void sendAgentAlive(byte[] padding) throws IOException {
        SshAgentAlive msg = new SshAgentAlive(padding);
        this.sendMessage(msg);
    }

    protected void sendMessage(SubsystemMessage msg) throws IOException {
        log.info((Object)("Sending message " + msg.getMessageName()));
        byte[] msgdata = msg.toByteArray();
        this.out.write(ByteArrayWriter.encodeInt(msgdata.length));
        this.out.write(msgdata);
        this.out.flush();
    }

    protected void onForwardingNotice(SshAgentForwardingNotice msg) {
        this.forwardingNodes.add(new ForwardingNotice(msg.getRemoteHostname(), msg.getRemoteIPAddress(), msg.getRemotePort()));
    }

    protected void onRequestVersion(SshAgentRequestVersion msg) throws IOException {
        this.sendVersionResponse();
    }

    protected void onAddKey(SshAgentAddKey msg) throws IOException {
        if (this.keystore.addKey(msg.getPrivateKey(), msg.getPublicKey(), msg.getDescription(), msg.getKeyConstraints())) {
            this.sendAgentSuccess();
        } else {
            this.sendAgentFailure(7);
        }
    }

    protected void onDeleteAllKeys(SshAgentDeleteAllKeys msg) throws IOException {
        this.keystore.deleteAllKeys();
        this.sendAgentSuccess();
    }

    protected void onListKeys(SshAgentListKeys msg) throws IOException {
        this.sendAgentKeyList();
    }

    protected void onPrivateKeyOp(SshAgentPrivateKeyOp msg) throws IOException {
        try {
            if (msg.getOperation().equals("sign")) {
                this.sendAgentFailure(5);
            } else if (msg.getOperation().equals("hash-and-sign")) {
                byte[] sig = this.keystore.performHashAndSign(msg.getPublicKey(), this.forwardingNodes, msg.getOperationData());
                this.sendOperationComplete(sig);
            } else if (msg.getOperation().equals("decrypt")) {
                this.sendAgentFailure(5);
            } else if (msg.getOperation().equals("ssh1-challenge-response")) {
                this.sendAgentFailure(5);
            } else {
                this.sendAgentFailure(8);
            }
        }
        catch (KeyTimeoutException ex) {
            this.sendAgentFailure(1);
        }
        catch (InvalidSshKeyException ex) {
            this.sendAgentFailure(2);
        }
    }

    protected void onDeleteKey(SshAgentDeleteKey msg) throws IOException {
        if (this.keystore.deleteKey(msg.getPublicKey(), msg.getDescription())) {
            this.sendAgentSuccess();
        } else {
            this.sendAgentFailure(2);
        }
    }

    protected void onLock(SshAgentLock msg) throws IOException {
        if (this.keystore.lock(msg.getPassword())) {
            this.sendAgentSuccess();
        } else {
            this.sendAgentFailure(6);
        }
    }

    protected void onUnlock(SshAgentUnlock msg) throws IOException {
        if (this.keystore.unlock(msg.getPassword())) {
            this.sendAgentSuccess();
        } else {
            this.sendAgentFailure(6);
        }
    }

    protected void onPing(SshAgentPing msg) throws IOException {
        this.sendAgentAlive(msg.getPadding());
    }

    protected void onRandom(SshAgentRandom msg) throws IOException {
        if (msg.getLength() > 0) {
            byte[] random = new byte[msg.getLength()];
            ConfigurationLoader.getRND().nextBytes(random);
            this.sendRandomData(random);
        } else {
            this.sendAgentFailure(7);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block17: {
            try {
                try {
                    SshAgentConnection.log.info((Object)"Starting agent connection thread");
                    lendata = new byte[4];
                    alive = true;
                    block12: while (alive) {
                        len = 0;
                        while (len < lendata.length) {
                            try {
                                read = 0;
                                read = this.in.read(lendata, len, lendata.length - len);
                                if (read >= 0) {
                                    len += read;
                                    continue;
                                }
                                alive = false;
                                break;
                            }
                            catch (InterruptedIOException ex) {
                                if (ex.bytesTransferred <= 0) continue;
                                len += ex.bytesTransferred;
                            }
                        }
                        if (!alive) continue;
                        len = (int)ByteArrayReader.readInt(lendata, 0);
                        msgdata = new byte[len];
                        len = 0;
                        while (true) {
                            if (len >= msgdata.length) {
                                this.onMessageReceived(msgdata);
                                continue block12;
                            }
                            try {
                                len += this.in.read(msgdata, len, msgdata.length - len);
                            }
                            catch (InterruptedIOException ex1) {
                                len += ex1.bytesTransferred;
                            }
                        }
                    }
                }
                catch (IOException ex) {
                    SshAgentConnection.log.info((Object)"The agent connection terminated");
                }
            }
            catch (Throwable var8_10) {
                var7_11 = null;
                try {
                    this.socket.close();
                    throw var8_10;
                }
                catch (Exception var9_13) {
                    // empty catch block
                }
                throw var8_10;
            }
            {
                var7_12 = null;
            }
            ** try [egrp 4[TRYBLOCK] [5 : 184->194)] { 
lbl50:
            // 1 sources

            this.socket.close();
            break block17;
lbl52:
            // 1 sources

            catch (Exception var9_14) {
                // empty catch block
            }
        }
        SshAgentConnection.log.info((Object)"Exiting agent connection thread");
    }

    protected void onMessageReceived(byte[] msgdata) throws IOException {
        switch (msgdata[0] & 0xFF) {
            case 206: {
                log.info((Object)"Agent forwarding notice received");
                SshAgentForwardingNotice msg = new SshAgentForwardingNotice();
                msg.fromByteArray(msgdata);
                this.onForwardingNotice(msg);
                break;
            }
            case 1: {
                log.info((Object)"Agent version request received");
                SshAgentRequestVersion msg = new SshAgentRequestVersion();
                msg.fromByteArray(msgdata);
                this.onRequestVersion(msg);
                break;
            }
            case 202: {
                log.info((Object)"Adding key to agent");
                SshAgentAddKey msg = new SshAgentAddKey();
                msg.fromByteArray(msgdata);
                this.onAddKey(msg);
                break;
            }
            case 203: {
                log.info((Object)"Deleting all keys from agent");
                SshAgentDeleteAllKeys msg = new SshAgentDeleteAllKeys();
                msg.fromByteArray(msgdata);
                this.onDeleteAllKeys(msg);
                break;
            }
            case 204: {
                log.info((Object)"Listing agent keys");
                SshAgentListKeys msg = new SshAgentListKeys();
                msg.fromByteArray(msgdata);
                this.onListKeys(msg);
                break;
            }
            case 205: {
                log.info((Object)"Performing agent private key operation");
                SshAgentPrivateKeyOp msg = new SshAgentPrivateKeyOp();
                msg.fromByteArray(msgdata);
                this.onPrivateKeyOp(msg);
                break;
            }
            case 207: {
                log.info((Object)"Deleting key from agent");
                SshAgentDeleteKey msg = new SshAgentDeleteKey();
                msg.fromByteArray(msgdata);
                this.onDeleteKey(msg);
                break;
            }
            case 208: {
                log.info((Object)"Locking agent");
                SshAgentLock msg = new SshAgentLock();
                msg.fromByteArray(msgdata);
                this.onLock(msg);
                break;
            }
            case 209: {
                log.info((Object)"Unlocking agent");
                SshAgentUnlock msg = new SshAgentUnlock();
                msg.fromByteArray(msgdata);
                this.onUnlock(msg);
                break;
            }
            case 212: {
                log.info((Object)"Ping Ping Ping Ping Ping");
                SshAgentPing msg = new SshAgentPing();
                msg.fromByteArray(msgdata);
                this.onPing(msg);
                break;
            }
            case 213: {
                log.info((Object)"Random message received");
                SshAgentRandom msg = new SshAgentRandom();
                msg.fromByteArray(msgdata);
                this.onRandom(msg);
                break;
            }
            default: {
                throw new IOException("Unrecognized message type " + String.valueOf(msgdata[0]) + " received");
            }
        }
    }
}

