/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.authentication;

import com.sshtools.j2ssh.SshException;
import com.sshtools.j2ssh.authentication.AuthenticationProtocolException;
import com.sshtools.j2ssh.authentication.AuthenticationProtocolListener;
import com.sshtools.j2ssh.authentication.SshAuthenticationClient;
import com.sshtools.j2ssh.authentication.SshMsgUserAuthBanner;
import com.sshtools.j2ssh.authentication.SshMsgUserAuthFailure;
import com.sshtools.j2ssh.authentication.SshMsgUserAuthRequest;
import com.sshtools.j2ssh.authentication.SshMsgUserAuthSuccess;
import com.sshtools.j2ssh.authentication.TerminatedStateException;
import com.sshtools.j2ssh.transport.MessageNotAvailableException;
import com.sshtools.j2ssh.transport.MessageStoreEOFException;
import com.sshtools.j2ssh.transport.Service;
import com.sshtools.j2ssh.transport.SshMessage;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuthenticationProtocolClient
extends Service {
    private static Log log;
    private int[] resultFilter = new int[2];
    private int[] singleIdFilter = new int[3];
    private Vector listeners = new Vector();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.sshtools.j2ssh.authentication.AuthenticationProtocolClient");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public AuthenticationProtocolClient() {
        super("ssh-userauth");
        this.resultFilter[0] = 52;
        this.resultFilter[1] = 51;
        this.singleIdFilter[0] = 52;
        this.singleIdFilter[1] = 51;
    }

    protected void onServiceAccept() throws IOException {
    }

    protected void onStart() {
    }

    protected void onServiceInit(int startMode) throws IOException {
        if (startMode == 2) {
            throw new IOException("The Authentication Protocol client cannot be accepted");
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("com.sshtools.j2ssh.authentication.SshMsgUserAuthFailure");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.messageStore.registerMessage(51, clazz);
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("com.sshtools.j2ssh.authentication.SshMsgUserAuthSuccess");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.messageStore.registerMessage(52, clazz2);
        Class<?> clazz3 = class$3;
        if (clazz3 == null) {
            try {
                clazz3 = class$3 = Class.forName("com.sshtools.j2ssh.authentication.SshMsgUserAuthBanner");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.messageStore.registerMessage(53, clazz3);
    }

    protected void onServiceRequest() throws IOException {
        throw new IOException("This class implements the client protocol only!");
    }

    public void addEventListener(AuthenticationProtocolListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public List getAvailableAuths(String username, String serviceName) throws IOException {
        log.info((Object)"Requesting authentication methods");
        SshMessage msg = new SshMsgUserAuthRequest(username, serviceName, "none", null);
        this.transport.sendMessage(msg, this);
        try {
            msg = this.messageStore.getMessage(this.resultFilter);
        }
        catch (InterruptedException ex) {
            throw new SshException("The thread was interrupted whilst waiting for an authentication message");
        }
        if (msg instanceof SshMsgUserAuthFailure) {
            return ((SshMsgUserAuthFailure)msg).getAvailableAuthentications();
        }
        throw new IOException("None request returned success! Insecure feature not supported");
    }

    /*
     * Unable to fully structure code
     */
    public int authenticate(SshAuthenticationClient auth, Service serviceToStart) throws IOException {
        block5: {
            try {
                if (!auth.canAuthenticate() && auth.canPrompt() && !(prompt = auth.getAuthenticationPrompt()).showPrompt(auth)) {
                    return 5;
                }
                auth.authenticate(this, serviceToStart.getServiceName());
                msg = this.parseMessage(this.messageStore.getMessage(this.resultFilter));
                throw new AuthenticationProtocolException("Unexpected authentication message " + msg.getMessageName());
            }
            catch (TerminatedStateException tse) {
                if (tse.getState() != 4) break block5;
                serviceToStart.init(2, this.transport);
                serviceToStart.start();
                it = this.listeners.iterator();
                ** while (it.hasNext())
            }
lbl-1000:
            // 1 sources

            {
                listener = (AuthenticationProtocolListener)it.next();
                if (listener == null) continue;
                listener.onAuthenticationComplete();
                continue;
            }
        }
        return tse.getState();
        catch (InterruptedException ex) {
            throw new SshException("The thread was interrupted whilst waiting for an authentication message");
        }
    }

    public void sendMessage(SshMessage msg) throws IOException {
        this.transport.sendMessage(msg, this);
    }

    public byte[] getSessionIdentifier() {
        return this.transport.getSessionIdentifier();
    }

    public void registerMessage(Class cls, int messageId) {
        this.messageStore.registerMessage(messageId, cls);
    }

    public SshMessage readMessage(int messageId) throws TerminatedStateException, IOException {
        this.singleIdFilter[2] = messageId;
        return this.internalReadMessage(this.singleIdFilter);
    }

    private SshMessage internalReadMessage(int[] messageIdFilter) throws TerminatedStateException, IOException {
        try {
            SshMessage msg = this.messageStore.getMessage(messageIdFilter);
            return this.parseMessage(msg);
        }
        catch (MessageStoreEOFException meof) {
            throw new AuthenticationProtocolException("Failed to read messages");
        }
        catch (InterruptedException ex) {
            throw new SshException("The thread was interrupted whilst waiting for an authentication message");
        }
    }

    public SshMessage readMessage(int[] messageId) throws TerminatedStateException, IOException {
        int[] messageIdFilter = new int[messageId.length + this.resultFilter.length];
        System.arraycopy(this.resultFilter, 0, messageIdFilter, 0, this.resultFilter.length);
        System.arraycopy(messageId, 0, messageIdFilter, this.resultFilter.length, messageId.length);
        return this.internalReadMessage(messageIdFilter);
    }

    public void readAuthenticationState() throws IOException, TerminatedStateException {
        this.internalReadMessage(this.resultFilter);
    }

    private SshMessage parseMessage(SshMessage msg) throws TerminatedStateException {
        if (msg instanceof SshMsgUserAuthFailure) {
            if (((SshMsgUserAuthFailure)msg).getPartialSuccess()) {
                throw new TerminatedStateException(3);
            }
            throw new TerminatedStateException(2);
        }
        if (msg instanceof SshMsgUserAuthSuccess) {
            throw new TerminatedStateException(4);
        }
        return msg;
    }

    public String getBannerMessage(int timeout) throws IOException {
        try {
            log.debug((Object)"getBannerMessage is attempting to read the authentication banner");
            SshMessage msg = this.messageStore.peekMessage(53, timeout);
            return ((SshMsgUserAuthBanner)msg).getBanner();
        }
        catch (MessageNotAvailableException e) {
            return "";
        }
        catch (MessageStoreEOFException eof) {
            log.error((Object)"Failed to retreive banner becasue the message store is EOF");
            return "";
        }
        catch (InterruptedException ex) {
            throw new SshException("The thread was interrupted whilst waiting for an authentication message");
        }
    }
}

