/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.authentication;

import com.sshtools.j2ssh.authentication.AuthenticationProtocolClient;
import com.sshtools.j2ssh.authentication.AuthenticationProtocolException;
import com.sshtools.j2ssh.authentication.SshAuthenticationClient;
import com.sshtools.j2ssh.authentication.SshMsgUserAuthRequest;
import com.sshtools.j2ssh.authentication.TerminatedStateException;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKey;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostbasedAuthenticationClient
extends SshAuthenticationClient {
    private static Log log;
    protected SshPrivateKey key;
    private String privateKeyFile = null;
    private String passphrase = null;
    private String clientUser = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.sshtools.j2ssh.authentication.HostbasedAuthenticationClient");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public void setKey(SshPrivateKey key) {
        this.key = key;
    }

    public void reset() {
        this.privateKeyFile = null;
        this.passphrase = null;
        this.clientUser = null;
    }

    public void setClientUsername(String clientUser) {
        this.clientUser = clientUser;
    }

    public String getMethodName() {
        return "hostbased";
    }

    public void authenticate(AuthenticationProtocolClient authentication, String serviceToStart) throws IOException, TerminatedStateException {
        if (this.getUsername() == null || this.key == null) {
            throw new AuthenticationProtocolException("You must supply a username and a key");
        }
        ByteArrayWriter baw = new ByteArrayWriter();
        log.info((Object)"Generating data to sign");
        SshPublicKey pub = this.key.getPublicKey();
        InetAddress addr = InetAddress.getLocalHost();
        String hostname = addr.getHostName();
        log.info((Object)("Preparing hostbased authentication request for " + hostname));
        baw.writeString(pub.getAlgorithmName());
        baw.writeBinaryString(pub.getEncoded());
        baw.writeString(hostname);
        if (this.clientUser != null) {
            baw.writeString(this.clientUser);
        } else {
            baw.writeString(this.getUsername());
        }
        ByteArrayWriter data = new ByteArrayWriter();
        data.writeBinaryString(authentication.getSessionIdentifier());
        data.write(50);
        data.writeString(this.getUsername());
        data.writeString(serviceToStart);
        data.writeString(this.getMethodName());
        data.writeString(pub.getAlgorithmName());
        data.writeBinaryString(pub.getEncoded());
        data.writeString(hostname);
        if (this.clientUser != null) {
            data.writeString(this.clientUser);
        } else {
            data.writeString(this.getUsername());
        }
        baw.writeBinaryString(this.key.generateSignature(data.toByteArray()));
        SshMsgUserAuthRequest msg = new SshMsgUserAuthRequest(this.getUsername(), serviceToStart, this.getMethodName(), baw.toByteArray());
        authentication.sendMessage(msg);
    }

    public Properties getPersistableProperties() {
        Properties properties = new Properties();
        if (this.getUsername() != null) {
            properties.setProperty("Username", this.getUsername());
        }
        if (this.privateKeyFile != null) {
            properties.setProperty("PrivateKey", this.privateKeyFile);
        }
        return properties;
    }

    public void setPersistableProperties(Properties properties) {
        this.setUsername(properties.getProperty("Username"));
        if (properties.getProperty("PrivateKey") != null) {
            this.privateKeyFile = properties.getProperty("PrivateKey");
        }
        if (properties.getProperty("Passphrase") != null) {
            this.passphrase = properties.getProperty("Passphrase");
        }
    }

    public boolean canAuthenticate() {
        return this.getUsername() != null && this.key != null;
    }
}

