/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.authentication;

import com.sshtools.j2ssh.authentication.SshAuthenticationClient;
import com.sshtools.j2ssh.configuration.ConfigurationException;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.configuration.ExtensionAlgorithm;
import com.sshtools.j2ssh.configuration.SshAPIConfiguration;
import com.sshtools.j2ssh.transport.AlgorithmNotSupportedException;
import java.io.FilePermission;
import java.security.AccessControlException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshAuthenticationClientFactory {
    private static Map auths;
    private static Log log;
    public static final String AUTH_PASSWORD = "password";
    public static final String AUTH_PK = "publickey";
    public static final String AUTH_KBI = "keyboard-interactive";
    public static final String AUTH_HOSTBASED = "hostbased";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    static {
        block33: {
            Class<?> clazz;
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("com.sshtools.j2ssh.authentication.SshAuthenticationClientFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            log = LogFactory.getLog((Class)clazz2);
            auths = new HashMap();
            log.info((Object)"Loading supported authentication methods");
            Class<?> clazz3 = class$1;
            if (clazz3 == null) {
                try {
                    clazz3 = class$1 = Class.forName("com.sshtools.j2ssh.authentication.PasswordAuthenticationClient");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            auths.put(AUTH_PASSWORD, clazz3);
            try {
                Class<?> clazz4;
                if (System.getSecurityManager() != null) {
                    AccessController.checkPermission(new FilePermission("<<ALL FILES>>", "read"));
                }
                if ((clazz4 = class$2) == null) {
                    try {
                        clazz4 = class$2 = Class.forName("com.sshtools.j2ssh.authentication.PublicKeyAuthenticationClient");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                auths.put(AUTH_PK, clazz4);
            }
            catch (AccessControlException ace) {
                log.info((Object)"The security manager prevents use of Public Key Authentication on the client");
            }
            if ((clazz = class$3) == null) {
                try {
                    clazz = class$3 = Class.forName("com.sshtools.j2ssh.authentication.KBIAuthenticationClient");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            auths.put(AUTH_KBI, clazz);
            try {
                Class<?> clazz5 = class$4;
                if (clazz5 == null) {
                    try {
                        clazz5 = class$4 = Class.forName("com.sshtools.j2ssh.configuration.SshAPIConfiguration");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!ConfigurationLoader.isConfigurationAvailable(clazz5)) break block33;
                Class<?> clazz6 = class$4;
                if (clazz6 == null) {
                    try {
                        clazz6 = class$4 = Class.forName("com.sshtools.j2ssh.configuration.SshAPIConfiguration");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                SshAPIConfiguration config = (SshAPIConfiguration)ConfigurationLoader.getConfiguration(clazz6);
                List addons = config.getAuthenticationExtensions();
                Iterator it = addons.iterator();
                while (it.hasNext()) {
                    ExtensionAlgorithm method = (ExtensionAlgorithm)it.next();
                    String name = method.getAlgorithmName();
                    if (auths.containsKey(name)) {
                        log.debug((Object)("Standard authentication implementation for " + name + " is being overidden by " + method.getImplementationClass()));
                    } else {
                        log.debug((Object)(String.valueOf(name) + " authentication is implemented by " + method.getImplementationClass()));
                    }
                    try {
                        Class cls = ConfigurationLoader.getExtensionClass(method.getImplementationClass());
                        Object obj = cls.newInstance();
                        if (!(obj instanceof SshAuthenticationClient)) continue;
                        auths.put(name, cls);
                    }
                    catch (Exception e) {
                        log.warn((Object)("Failed to load extension authentication implementation" + method.getImplementationClass()), (Throwable)e);
                    }
                }
            }
            catch (ConfigurationException configurationException) {
                // empty catch block
            }
        }
    }

    protected SshAuthenticationClientFactory() {
    }

    public static void initialize() {
    }

    public static List getSupportedMethods() {
        ArrayList list = new ArrayList(auths.keySet());
        return list;
    }

    public static SshAuthenticationClient newInstance(String methodName) throws AlgorithmNotSupportedException {
        try {
            return (SshAuthenticationClient)((Class)auths.get(methodName)).newInstance();
        }
        catch (Exception e) {
            throw new AlgorithmNotSupportedException(String.valueOf(methodName) + " is not supported!");
        }
    }
}

