/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.configuration;

import com.sshtools.j2ssh.forwarding.ForwardingConfiguration;
import com.sshtools.j2ssh.transport.cipher.SshCipherFactory;
import com.sshtools.j2ssh.transport.compression.SshCompressionFactory;
import com.sshtools.j2ssh.transport.hmac.SshHmacFactory;
import com.sshtools.j2ssh.transport.kex.SshKeyExchangeFactory;
import com.sshtools.j2ssh.transport.publickey.SshKeyPairFactory;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshConnectionProperties {
    private static Log log;
    public static final int USE_STANDARD_SOCKET = 1;
    public static final int USE_HTTP_PROXY = 2;
    public static final int USE_SOCKS4_PROXY = 3;
    public static final int USE_SOCKS5_PROXY = 4;
    protected int transportProvider = 1;
    protected String proxyHostname;
    protected int proxyPort;
    protected String proxyUsername;
    protected String proxyPassword;
    protected String host;
    protected String prefDecryption = SshCipherFactory.getDefaultCipher();
    protected String prefEncryption = SshCipherFactory.getDefaultCipher();
    protected String prefKex = SshKeyExchangeFactory.getDefaultKeyExchange();
    protected String prefPK = SshKeyPairFactory.getDefaultPublicKey();
    protected String prefRecvComp = SshCompressionFactory.getDefaultCompression();
    protected String prefRecvMac = SshHmacFactory.getDefaultHmac();
    protected String prefSendComp = SshCompressionFactory.getDefaultCompression();
    protected String prefSendMac = SshHmacFactory.getDefaultHmac();
    protected String username;
    protected int port = 22;
    protected Map localForwardings = new HashMap();
    protected Map remoteForwardings = new HashMap();
    protected boolean forwardingAutoStart = false;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.sshtools.j2ssh.configuration.SshConnectionProperties");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getHost() {
        return this.host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public int getTransportProvider() {
        return this.transportProvider;
    }

    public void setTransportProviderString(String name) {
        this.transportProvider = name != null ? (name.equalsIgnoreCase("http") ? 2 : (name.equalsIgnoreCase("socks4") ? 3 : (name.equalsIgnoreCase("socks5") ? 4 : 1))) : 1;
    }

    public String getTransportProviderString() {
        if (this.transportProvider == 2) {
            return "http";
        }
        if (this.transportProvider == 3) {
            return "socks4";
        }
        if (this.transportProvider == 4) {
            return "socks5";
        }
        return "socket";
    }

    public String getProxyHost() {
        return this.proxyHostname;
    }

    public void removeAllForwardings() {
        this.localForwardings.clear();
        this.remoteForwardings.clear();
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setTransportProvider(int transportProvider) {
        this.transportProvider = transportProvider;
    }

    public void setProxyHost(String proxyHostname) {
        this.proxyHostname = proxyHostname;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public void setPrefCSComp(String pref) {
        this.prefSendComp = pref;
    }

    public String getPrefCSComp() {
        return this.prefSendComp;
    }

    public void setPrefCSEncryption(String pref) {
        this.prefEncryption = pref;
    }

    public String getPrefCSEncryption() {
        return this.prefEncryption;
    }

    public void setPrefCSMac(String pref) {
        this.prefSendMac = pref;
    }

    public String getPrefCSMac() {
        return this.prefSendMac;
    }

    public void setPrefKex(String pref) {
        this.prefKex = pref;
    }

    public String getPrefKex() {
        return this.prefKex;
    }

    public void setPrefPublicKey(String pref) {
        this.prefPK = pref;
    }

    public String getPrefPublicKey() {
        return this.prefPK;
    }

    public void setPrefSCComp(String pref) {
        this.prefRecvComp = pref;
    }

    public String getPrefSCComp() {
        return this.prefRecvComp;
    }

    public void setPrefSCEncryption(String pref) {
        this.prefDecryption = pref;
    }

    public String getPrefSCEncryption() {
        return this.prefDecryption;
    }

    public Map getLocalForwardings() {
        return this.localForwardings;
    }

    public Map getRemoteForwardings() {
        return this.remoteForwardings;
    }

    public void addLocalForwarding(ForwardingConfiguration cf) {
        this.localForwardings.put(cf.getName(), cf);
    }

    public void addRemoteForwarding(ForwardingConfiguration cf) {
        this.remoteForwardings.put(cf.getName(), cf);
    }

    public boolean getForwardingAutoStartMode() {
        return this.forwardingAutoStart;
    }

    public void setForwardingAutoStartMode(boolean forwardingAutoStart) {
        this.forwardingAutoStart = forwardingAutoStart;
    }

    public void setPrefSCMac(String pref) {
        this.prefRecvMac = pref;
    }

    public String getPrefSCMac() {
        return this.prefRecvMac;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }
}

