/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.connection;

import com.sshtools.j2ssh.connection.ChannelDataWindow;
import com.sshtools.j2ssh.connection.ChannelEventListener;
import com.sshtools.j2ssh.connection.ChannelState;
import com.sshtools.j2ssh.connection.ConnectionProtocol;
import com.sshtools.j2ssh.connection.SshMsgChannelData;
import com.sshtools.j2ssh.connection.SshMsgChannelExtendedData;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class Channel {
    private static Log log;
    protected ChannelDataWindow localWindow = new ChannelDataWindow();
    protected ChannelDataWindow remoteWindow = new ChannelDataWindow();
    protected ConnectionProtocol connection;
    protected long localChannelId;
    protected long localPacketSize;
    protected long remoteChannelId;
    protected long remotePacketSize;
    protected ChannelState state = new ChannelState();
    private boolean isClosed = false;
    private boolean isLocalEOF = false;
    private boolean isRemoteEOF = false;
    private boolean localHasClosed = false;
    private boolean remoteHasClosed = false;
    private String name = "Unnamed Channel";
    private Vector eventListeners = new Vector();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.sshtools.j2ssh.connection.Channel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public Channel() {
        this.localPacketSize = this.getMaximumPacketSize();
        this.localWindow.increaseWindowSpace(this.getMaximumWindowSpace());
    }

    public abstract byte[] getChannelOpenData();

    public abstract byte[] getChannelConfirmationData();

    public abstract String getChannelType();

    protected abstract int getMinimumWindowSpace();

    protected abstract int getMaximumWindowSpace();

    protected abstract int getMaximumPacketSize();

    protected abstract void onChannelData(SshMsgChannelData var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processChannelData(SshMsgChannelData msg) throws IOException {
        ChannelState channelState = this.state;
        synchronized (channelState) {
            if (!this.isClosed()) {
                if (msg.getChannelDataLength() > this.localWindow.getWindowSpace()) {
                    throw new IOException("More data recieved than is allowed by the channel data window [" + this.name + "]");
                }
                long windowSpace = this.localWindow.consumeWindowSpace(msg.getChannelData().length);
                if (windowSpace < (long)this.getMinimumWindowSpace()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Channel " + String.valueOf(this.localChannelId) + " requires more window space [" + this.name + "]"));
                    }
                    windowSpace = (long)this.getMaximumWindowSpace() - windowSpace;
                    log.debug((Object)"Requesting connection protocol increase window");
                    this.connection.sendChannelWindowAdjust(this, windowSpace);
                    this.localWindow.increaseWindowSpace(windowSpace);
                }
                this.onChannelData(msg);
                Iterator it = this.eventListeners.iterator();
                while (it.hasNext()) {
                    ChannelEventListener eventListener = (ChannelEventListener)it.next();
                    if (eventListener == null) continue;
                    eventListener.onDataReceived(this, msg.getChannelData());
                }
            } else {
                throw new IOException("Channel data received but channel is closed [" + this.name + "]");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        ChannelState channelState = this.state;
        synchronized (channelState) {
            return this.state.getValue() == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpen() {
        ChannelState channelState = this.state;
        synchronized (channelState) {
            return this.state.getValue() == 2;
        }
    }

    protected void sendChannelData(byte[] data) throws IOException {
        if (!this.connection.isConnected()) {
            throw new IOException("The connection has been closed [" + this.name + "]");
        }
        if (!this.isClosed()) {
            this.connection.sendChannelData(this, data);
            Iterator it = this.eventListeners.iterator();
            while (it.hasNext()) {
                ChannelEventListener eventListener = (ChannelEventListener)it.next();
                if (eventListener == null) continue;
                eventListener.onDataSent(this, data);
            }
        } else {
            throw new IOException("The channel is closed [" + this.name + "]");
        }
    }

    protected void sendChannelExtData(int type, byte[] data) throws IOException {
        if (!this.connection.isConnected()) {
            throw new IOException("The connection has been closed [" + this.name + "]");
        }
        if (!this.isClosed()) {
            this.connection.sendChannelExtData(this, type, data);
            Iterator it = this.eventListeners.iterator();
            while (it.hasNext()) {
                ChannelEventListener eventListener = (ChannelEventListener)it.next();
                if (eventListener == null) continue;
                eventListener.onDataSent(this, data);
            }
        } else {
            throw new IOException("The channel is closed [" + this.name + "]");
        }
    }

    protected abstract void onChannelExtData(SshMsgChannelExtendedData var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processChannelData(SshMsgChannelExtendedData msg) throws IOException {
        ChannelState channelState = this.state;
        synchronized (channelState) {
            if ((long)msg.getChannelData().length > this.localWindow.getWindowSpace()) {
                throw new IOException("More data recieved than is allowed by the channel data window [" + this.name + "]");
            }
            long windowSpace = this.localWindow.consumeWindowSpace(msg.getChannelData().length);
            if (windowSpace < (long)this.getMinimumWindowSpace()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Channel " + String.valueOf(this.localChannelId) + " requires more window space [" + this.name + "]"));
                }
                windowSpace = (long)this.getMaximumWindowSpace() - windowSpace;
                this.connection.sendChannelWindowAdjust(this, windowSpace);
                this.localWindow.increaseWindowSpace(windowSpace);
            }
            this.onChannelExtData(msg);
            Iterator it = this.eventListeners.iterator();
            while (it.hasNext()) {
                ChannelEventListener eventListener = (ChannelEventListener)it.next();
                if (eventListener == null) continue;
                eventListener.onDataReceived(this, msg.getChannelData());
            }
        }
    }

    public long getLocalChannelId() {
        return this.localChannelId;
    }

    public long getLocalPacketSize() {
        return this.localPacketSize;
    }

    public ChannelDataWindow getLocalWindow() {
        return this.localWindow;
    }

    public long getRemoteChannelId() {
        return this.remoteChannelId;
    }

    public long getRemotePacketSize() {
        return this.remotePacketSize;
    }

    public ChannelDataWindow getRemoteWindow() {
        return this.remoteWindow;
    }

    public ChannelState getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        ChannelState channelState = this.state;
        synchronized (channelState) {
            if (this.isOpen()) {
                if (this.connection != null && !this.localHasClosed && this.connection.isConnected()) {
                    this.connection.closeChannel(this);
                }
                this.localHasClosed = true;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Connection is " + (this.connection == null ? "null" : (this.connection.isConnected() ? "connected" : "not connected"))));
                }
                if (this.remoteHasClosed || this.connection == null || !this.connection.isConnected()) {
                    log.info((Object)"Finializing channel close");
                    this.finalizeClose();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remoteClose() throws IOException {
        log.info((Object)"Remote side is closing channel");
        ChannelState channelState = this.state;
        synchronized (channelState) {
            this.remoteHasClosed = true;
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalizeClose() throws IOException {
        ChannelState channelState = this.state;
        synchronized (channelState) {
            this.state.setValue(3);
            this.onChannelClose();
            Iterator it = this.eventListeners.iterator();
            while (it.hasNext()) {
                ChannelEventListener eventListener = (ChannelEventListener)it.next();
                if (eventListener == null) continue;
                eventListener.onChannelClose(this);
            }
            if (this.connection != null) {
                this.connection.freeChannel(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocalEOF() throws IOException {
        ChannelState channelState = this.state;
        synchronized (channelState) {
            this.isLocalEOF = true;
            this.connection.sendChannelEOF(this);
        }
    }

    public boolean isLocalEOF() {
        return this.isLocalEOF;
    }

    public boolean isRemoteEOF() {
        return this.isRemoteEOF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRemoteEOF() throws IOException {
        ChannelState channelState = this.state;
        synchronized (channelState) {
            this.isRemoteEOF = true;
            this.onChannelEOF();
            Iterator it = this.eventListeners.iterator();
            while (it.hasNext()) {
                ChannelEventListener eventListener = (ChannelEventListener)it.next();
                if (eventListener == null) continue;
                eventListener.onChannelEOF(this);
            }
        }
    }

    public void addEventListener(ChannelEventListener eventListener) {
        this.eventListeners.add(eventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init(ConnectionProtocol connection, long localChannelId, long senderChannelId, long initialWindowSize, long maximumPacketSize) throws IOException {
        this.localChannelId = localChannelId;
        this.remoteChannelId = senderChannelId;
        this.remotePacketSize = maximumPacketSize;
        this.remoteWindow.increaseWindowSpace(initialWindowSize);
        this.connection = connection;
        ChannelState channelState = this.state;
        synchronized (channelState) {
            this.state.setValue(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void open() throws IOException {
        ChannelState channelState = this.state;
        synchronized (channelState) {
            this.state.setValue(2);
            this.onChannelOpen();
            Iterator it = this.eventListeners.iterator();
            while (it.hasNext()) {
                ChannelEventListener eventListener = (ChannelEventListener)it.next();
                if (eventListener == null) continue;
                eventListener.onChannelOpen(this);
            }
        }
    }

    protected void init(ConnectionProtocol connection, long localChannelId, long senderChannelId, long initialWindowSize, long maximumPacketSize, ChannelEventListener eventListener) throws IOException {
        if (eventListener != null) {
            this.addEventListener(eventListener);
        }
        this.init(connection, localChannelId, senderChannelId, initialWindowSize, maximumPacketSize);
    }

    protected abstract void onChannelClose() throws IOException;

    protected abstract void onChannelEOF() throws IOException;

    protected abstract void onChannelOpen() throws IOException;

    protected abstract void onChannelRequest(String var1, boolean var2, byte[] var3) throws IOException;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }
}

