/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.connection;

import com.sshtools.j2ssh.SshException;
import com.sshtools.j2ssh.connection.Channel;
import com.sshtools.j2ssh.connection.ChannelDataWindow;
import com.sshtools.j2ssh.connection.ChannelEventListener;
import com.sshtools.j2ssh.connection.ChannelFactory;
import com.sshtools.j2ssh.connection.ChannelState;
import com.sshtools.j2ssh.connection.GlobalRequestHandler;
import com.sshtools.j2ssh.connection.GlobalRequestResponse;
import com.sshtools.j2ssh.connection.InvalidChannelException;
import com.sshtools.j2ssh.connection.SshMsgChannelClose;
import com.sshtools.j2ssh.connection.SshMsgChannelData;
import com.sshtools.j2ssh.connection.SshMsgChannelEOF;
import com.sshtools.j2ssh.connection.SshMsgChannelExtendedData;
import com.sshtools.j2ssh.connection.SshMsgChannelFailure;
import com.sshtools.j2ssh.connection.SshMsgChannelOpen;
import com.sshtools.j2ssh.connection.SshMsgChannelOpenConfirmation;
import com.sshtools.j2ssh.connection.SshMsgChannelOpenFailure;
import com.sshtools.j2ssh.connection.SshMsgChannelRequest;
import com.sshtools.j2ssh.connection.SshMsgChannelSuccess;
import com.sshtools.j2ssh.connection.SshMsgChannelWindowAdjust;
import com.sshtools.j2ssh.connection.SshMsgGlobalRequest;
import com.sshtools.j2ssh.connection.SshMsgRequestFailure;
import com.sshtools.j2ssh.connection.SshMsgRequestSuccess;
import com.sshtools.j2ssh.transport.AsyncService;
import com.sshtools.j2ssh.transport.MessageStoreEOFException;
import com.sshtools.j2ssh.transport.SshMessage;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConnectionProtocol
extends AsyncService {
    private static Log log;
    private HashSet reusableChannels = new HashSet();
    private Map activeChannels = new HashMap();
    private Map allowedChannels = new HashMap();
    private Map globalRequests = new HashMap();
    private long nextChannelId = 0L;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;
    static /* synthetic */ Class class$13;
    static /* synthetic */ Class class$14;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.sshtools.j2ssh.connection.ConnectionProtocol");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public ConnectionProtocol() {
        super("ssh-connection");
    }

    public void addChannelFactory(String channelName, ChannelFactory cf) throws IOException {
        this.allowedChannels.put(channelName, cf);
    }

    public void removeChannelFactory(String channelName) {
        this.allowedChannels.remove(channelName);
    }

    public boolean containsChannelFactory(String channelName) {
        return this.allowedChannels.containsKey(channelName);
    }

    public void allowGlobalRequest(String requestName, GlobalRequestHandler handler) {
        this.globalRequests.put(requestName, handler);
    }

    public synchronized boolean openChannel(Channel channel) throws IOException {
        return this.openChannel(channel, null);
    }

    public boolean isConnected() {
        return (this.transport.getState().getValue() == 4 || this.transport.getState().getValue() == 3) && this.getState().getValue() == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long getChannelId() {
        Map map = this.activeChannels;
        synchronized (map) {
            if (this.reusableChannels.size() <= 0) {
                return new Long(this.nextChannelId++);
            }
            return (Long)this.reusableChannels.iterator().next();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean openChannel(Channel channel, ChannelEventListener eventListener) throws IOException {
        Map map = this.activeChannels;
        synchronized (map) {
            Long channelId = this.getChannelId();
            SshMsgChannelOpen msg = new SshMsgChannelOpen(channel.getChannelType(), channelId, channel.getLocalWindow().getWindowSpace(), channel.getLocalPacketSize(), channel.getChannelOpenData());
            this.transport.sendMessage(msg, this);
            int[] messageIdFilter = new int[]{91, 92};
            try {
                SshMessage result = this.messageStore.getMessage(messageIdFilter);
                if (result.getMessageId() == 91) {
                    SshMsgChannelOpenConfirmation conf = (SshMsgChannelOpenConfirmation)result;
                    this.activeChannels.put(channelId, channel);
                    log.debug((Object)"Initiating channel");
                    channel.init(this, channelId, conf.getSenderChannel(), conf.getInitialWindowSize(), conf.getMaximumPacketSize(), eventListener);
                    channel.open();
                    log.info((Object)("Channel " + String.valueOf(channel.getLocalChannelId()) + " is open [" + channel.getName() + "]"));
                    return true;
                }
                channel.getState().setValue(3);
                return false;
            }
            catch (MessageStoreEOFException mse) {
                throw new IOException(mse.getMessage());
            }
            catch (InterruptedException ex) {
                throw new SshException("The thread was interrupted whilst waiting for a connection protocol message");
            }
        }
    }

    protected void onStop() {
        log.info((Object)"Closing all active channels");
        try {
            Iterator x = this.activeChannels.values().iterator();
            while (x.hasNext()) {
                Channel channel = (Channel)x.next();
                if (channel == null) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Closing " + channel.getName() + " id=" + String.valueOf(channel.getLocalChannelId())));
                }
                channel.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.activeChannels.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void sendChannelData(Channel channel, byte[] data) throws IOException {
        ChannelState channelState = channel.getState();
        synchronized (channelState) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Sending " + String.valueOf(data.length) + " bytes for channel id " + String.valueOf(channel.getLocalChannelId())));
            }
            int sent = 0;
            ChannelDataWindow window = channel.getRemoteWindow();
            while (sent < data.length) {
                int remaining = data.length - sent;
                long max = window.getWindowSpace() < channel.getRemotePacketSize() && window.getWindowSpace() > 0L ? window.getWindowSpace() : channel.getRemotePacketSize();
                int block = max < (long)remaining ? (int)max : remaining;
                channel.remoteWindow.consumeWindowSpace(block);
                byte[] buffer = new byte[block];
                System.arraycopy(data, sent, buffer, 0, block);
                SshMsgChannelData msg = new SshMsgChannelData(channel.getRemoteChannelId(), buffer);
                this.transport.sendMessage(msg, this);
                sent += block;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendChannelEOF(Channel channel) throws IOException {
        Map map = this.activeChannels;
        synchronized (map) {
            if (!this.activeChannels.containsValue(channel)) {
                throw new IOException("Attempt to send EOF for a non existent channel " + String.valueOf(channel.getLocalChannelId()));
            }
            log.info((Object)("Local computer has set channel " + String.valueOf(channel.getLocalChannelId()) + " to EOF [" + channel.getName() + "]"));
            SshMsgChannelEOF msg = new SshMsgChannelEOF(channel.getRemoteChannelId());
            this.transport.sendMessage(msg, this);
        }
    }

    public synchronized void sendChannelExtData(Channel channel, int extendedType, byte[] data) throws IOException {
        channel.getRemoteWindow().consumeWindowSpace(data.length);
        int sent = 0;
        ChannelDataWindow window = channel.getRemoteWindow();
        while (sent < data.length) {
            int remaining = data.length - sent;
            long max = window.getWindowSpace() < channel.getRemotePacketSize() && window.getWindowSpace() > 0L ? window.getWindowSpace() : channel.getRemotePacketSize();
            int block = max < (long)remaining ? (int)max : remaining;
            channel.remoteWindow.consumeWindowSpace(block);
            byte[] buffer = new byte[block];
            System.arraycopy(data, sent, buffer, 0, block);
            SshMsgChannelExtendedData msg = new SshMsgChannelExtendedData(channel.getRemoteChannelId(), extendedType, buffer);
            this.transport.sendMessage(msg, this);
            sent += block;
        }
    }

    public synchronized boolean sendChannelRequest(Channel channel, String requestType, boolean wantReply, byte[] requestData) throws IOException {
        boolean success = true;
        log.debug((Object)("Sending " + requestType + " request for the " + channel.getChannelType() + " channel"));
        SshMsgChannelRequest msg = new SshMsgChannelRequest(channel.getRemoteChannelId(), requestType, wantReply, requestData);
        this.transport.sendMessage(msg, this);
        if (wantReply) {
            int[] messageIdFilter = new int[]{99, 100};
            log.debug((Object)"Waiting for channel request reply");
            try {
                SshMessage reply = this.messageStore.getMessage(messageIdFilter);
                switch (reply.getMessageId()) {
                    case 99: {
                        log.debug((Object)"Channel request succeeded");
                        success = true;
                        break;
                    }
                    case 100: {
                        log.debug((Object)"Channel request failed");
                        success = false;
                    }
                }
            }
            catch (InterruptedException ex) {
                throw new SshException("The thread was interrupted whilst waiting for a connection protocol message");
            }
        }
        return success;
    }

    public void sendChannelRequestFailure(Channel channel) throws IOException {
        SshMsgChannelFailure msg = new SshMsgChannelFailure(channel.getRemoteChannelId());
        this.transport.sendMessage(msg, this);
    }

    public void sendChannelRequestSuccess(Channel channel) throws IOException {
        SshMsgChannelSuccess msg = new SshMsgChannelSuccess(channel.getRemoteChannelId());
        this.transport.sendMessage(msg, this);
    }

    public void sendChannelWindowAdjust(Channel channel, long bytesToAdd) throws IOException {
        log.debug((Object)("Increasing window size by " + String.valueOf(bytesToAdd) + " bytes"));
        SshMsgChannelWindowAdjust msg = new SshMsgChannelWindowAdjust(channel.getRemoteChannelId(), bytesToAdd);
        this.transport.sendMessage(msg, this);
    }

    public synchronized byte[] sendGlobalRequest(String requestName, boolean wantReply, byte[] requestData) throws IOException {
        boolean success = true;
        SshMsgGlobalRequest msg = new SshMsgGlobalRequest(requestName, true, requestData);
        this.transport.sendMessage(msg, this);
        if (wantReply) {
            int[] messageIdFilter = new int[]{81, 82};
            log.debug((Object)"Waiting for global request reply");
            try {
                SshMessage reply = this.messageStore.getMessage(messageIdFilter);
                switch (reply.getMessageId()) {
                    case 81: {
                        log.debug((Object)"Global request succeeded");
                        return ((SshMsgRequestSuccess)reply).getRequestData();
                    }
                    case 82: {
                        log.debug((Object)"Global request failed");
                        throw new SshException("The request failed");
                    }
                }
            }
            catch (InterruptedException ex) {
                throw new SshException("The thread was interrupted whilst waiting for a connection protocol message");
            }
        }
        return null;
    }

    protected int[] getAsyncMessageFilter() {
        int[] messageFilter = new int[10];
        messageFilter[0] = 80;
        messageFilter[3] = 90;
        messageFilter[4] = 97;
        messageFilter[5] = 96;
        messageFilter[6] = 95;
        messageFilter[7] = 94;
        messageFilter[8] = 98;
        messageFilter[9] = 93;
        return messageFilter;
    }

    protected void closeChannel(Channel channel) throws IOException {
        SshMsgChannelClose msg = new SshMsgChannelClose(channel.getRemoteChannelId());
        log.info((Object)("Local computer has closed channel " + String.valueOf(channel.getLocalChannelId()) + "[" + channel.getName() + "]"));
        this.transport.sendMessage(msg, this);
    }

    protected void onGlobalRequest(String requestName, boolean wantReply, byte[] requestData) throws IOException {
        log.debug((Object)("Processing " + requestName + " global request"));
        if (!this.globalRequests.containsKey(requestName)) {
            this.sendGlobalRequestFailure();
        } else {
            GlobalRequestHandler handler = (GlobalRequestHandler)this.globalRequests.get(requestName);
            GlobalRequestResponse response = handler.processGlobalRequest(requestName, requestData);
            if (wantReply) {
                if (response.hasSucceeded()) {
                    this.sendGlobalRequestSuccess(response.getResponseData());
                } else {
                    this.sendGlobalRequestFailure();
                }
            }
        }
    }

    protected void onMessageReceived(SshMessage msg) throws IOException {
        switch (msg.getMessageId()) {
            case 80: {
                this.onMsgGlobalRequest((SshMsgGlobalRequest)msg);
                break;
            }
            case 90: {
                this.onMsgChannelOpen((SshMsgChannelOpen)msg);
                break;
            }
            case 97: {
                this.onMsgChannelClose((SshMsgChannelClose)msg);
                break;
            }
            case 96: {
                this.onMsgChannelEOF((SshMsgChannelEOF)msg);
                break;
            }
            case 94: {
                this.onMsgChannelData((SshMsgChannelData)msg);
                break;
            }
            case 95: {
                this.onMsgChannelExtendedData((SshMsgChannelExtendedData)msg);
                break;
            }
            case 98: {
                this.onMsgChannelRequest((SshMsgChannelRequest)msg);
                break;
            }
            case 93: {
                this.onMsgChannelWindowAdjust((SshMsgChannelWindowAdjust)msg);
                break;
            }
            default: {
                log.debug((Object)"Message not handled");
                throw new IOException("Unregistered message received!");
            }
        }
    }

    protected void onServiceAccept() {
    }

    protected void onServiceInit(int startMode) throws IOException {
        log.info((Object)"Registering connection protocol messages");
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("com.sshtools.j2ssh.connection.SshMsgChannelOpenConfirmation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.messageStore.registerMessage(91, clazz);
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("com.sshtools.j2ssh.connection.SshMsgChannelOpenFailure");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.messageStore.registerMessage(92, clazz2);
        Class<?> clazz3 = class$3;
        if (clazz3 == null) {
            try {
                clazz3 = class$3 = Class.forName("com.sshtools.j2ssh.connection.SshMsgChannelOpen");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.messageStore.registerMessage(90, clazz3);
        Class<?> clazz4 = class$4;
        if (clazz4 == null) {
            try {
                clazz4 = class$4 = Class.forName("com.sshtools.j2ssh.connection.SshMsgChannelClose");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.messageStore.registerMessage(97, clazz4);
        Class<?> clazz5 = class$5;
        if (clazz5 == null) {
            try {
                clazz5 = class$5 = Class.forName("com.sshtools.j2ssh.connection.SshMsgChannelEOF");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.messageStore.registerMessage(96, clazz5);
        Class<?> clazz6 = class$6;
        if (clazz6 == null) {
            try {
                clazz6 = class$6 = Class.forName("com.sshtools.j2ssh.connection.SshMsgChannelData");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.messageStore.registerMessage(94, clazz6);
        Class<?> clazz7 = class$7;
        if (clazz7 == null) {
            try {
                clazz7 = class$7 = Class.forName("com.sshtools.j2ssh.connection.SshMsgChannelExtendedData");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.messageStore.registerMessage(95, clazz7);
        Class<?> clazz8 = class$8;
        if (clazz8 == null) {
            try {
                clazz8 = class$8 = Class.forName("com.sshtools.j2ssh.connection.SshMsgChannelFailure");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.messageStore.registerMessage(100, clazz8);
        Class<?> clazz9 = class$9;
        if (clazz9 == null) {
            try {
                clazz9 = class$9 = Class.forName("com.sshtools.j2ssh.connection.SshMsgChannelRequest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.messageStore.registerMessage(98, clazz9);
        Class<?> clazz10 = class$10;
        if (clazz10 == null) {
            try {
                clazz10 = class$10 = Class.forName("com.sshtools.j2ssh.connection.SshMsgChannelSuccess");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.messageStore.registerMessage(99, clazz10);
        Class<?> clazz11 = class$11;
        if (clazz11 == null) {
            try {
                clazz11 = class$11 = Class.forName("com.sshtools.j2ssh.connection.SshMsgChannelWindowAdjust");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.messageStore.registerMessage(93, clazz11);
        Class<?> clazz12 = class$12;
        if (clazz12 == null) {
            try {
                clazz12 = class$12 = Class.forName("com.sshtools.j2ssh.connection.SshMsgGlobalRequest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.messageStore.registerMessage(80, clazz12);
        Class<?> clazz13 = class$13;
        if (clazz13 == null) {
            try {
                clazz13 = class$13 = Class.forName("com.sshtools.j2ssh.connection.SshMsgRequestFailure");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.messageStore.registerMessage(82, clazz13);
        Class<?> clazz14 = class$14;
        if (clazz14 == null) {
            try {
                clazz14 = class$14 = Class.forName("com.sshtools.j2ssh.connection.SshMsgRequestSuccess");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.messageStore.registerMessage(81, clazz14);
    }

    protected void onServiceRequest() {
    }

    protected void sendChannelFailure(Channel channel) throws IOException {
        SshMsgChannelFailure msg = new SshMsgChannelFailure(channel.getRemoteChannelId());
        this.transport.sendMessage(msg, this);
    }

    protected void sendChannelOpenConfirmation(Channel channel) throws IOException {
        SshMsgChannelOpenConfirmation msg = new SshMsgChannelOpenConfirmation(channel.getRemoteChannelId(), channel.getLocalChannelId(), channel.getLocalWindow().getWindowSpace(), channel.getLocalPacketSize(), channel.getChannelConfirmationData());
        this.transport.sendMessage(msg, this);
    }

    protected void sendChannelOpenFailure(long remoteChannelId, long reasonCode, String additionalInfo, String languageTag) throws IOException {
        SshMsgChannelOpenFailure msg = new SshMsgChannelOpenFailure(remoteChannelId, reasonCode, additionalInfo, languageTag);
        this.transport.sendMessage(msg, this);
    }

    protected void sendGlobalRequestFailure() throws IOException {
        SshMsgRequestFailure msg = new SshMsgRequestFailure();
        this.transport.sendMessage(msg, this);
    }

    protected void sendGlobalRequestSuccess(byte[] requestData) throws IOException {
        SshMsgRequestSuccess msg = new SshMsgRequestSuccess(requestData);
        this.transport.sendMessage(msg, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Channel getChannel(long channelId) throws IOException {
        Map map = this.activeChannels;
        synchronized (map) {
            Long l = new Long(channelId);
            if (!this.activeChannels.containsKey(l)) {
                throw new IOException("Non existent channel " + l.toString() + " requested");
            }
            return (Channel)this.activeChannels.get(l);
        }
    }

    private void onMsgChannelClose(SshMsgChannelClose msg) throws IOException {
        Channel channel = this.getChannel(msg.getRecipientChannel());
        if (channel == null) {
            throw new IOException("Remote computer tried to close a non existent channel " + String.valueOf(msg.getRecipientChannel()));
        }
        log.info((Object)("Remote computer has closed channel " + String.valueOf(channel.getLocalChannelId()) + "[" + channel.getName() + "]"));
        if (channel.getState().getValue() != 3) {
            channel.remoteClose();
        }
    }

    private void onMsgChannelData(SshMsgChannelData msg) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received " + String.valueOf(msg.getChannelData().length) + " bytes of data for channel id " + String.valueOf(msg.getRecipientChannel())));
        }
        Channel channel = this.getChannel(msg.getRecipientChannel());
        channel.processChannelData(msg);
    }

    private void onMsgChannelEOF(SshMsgChannelEOF msg) throws IOException {
        Channel channel = this.getChannel(msg.getRecipientChannel());
        try {
            log.info((Object)("Remote computer has set channel " + String.valueOf(msg.getRecipientChannel()) + " to EOF [" + channel.getName() + "]"));
            channel.setRemoteEOF();
        }
        catch (IOException ioe) {
            log.info((Object)"Failed to close the ChannelInputStream after EOF event");
        }
    }

    private void onMsgChannelExtendedData(SshMsgChannelExtendedData msg) throws IOException {
        Channel channel = this.getChannel(msg.getRecipientChannel());
        if (channel == null) {
            throw new IOException("Remote computer sent data for non existent channel");
        }
        channel.getLocalWindow().consumeWindowSpace(msg.getChannelData().length);
        channel.processChannelData(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onMsgChannelOpen(SshMsgChannelOpen msg) throws IOException {
        Map map = this.activeChannels;
        synchronized (map) {
            log.info((Object)("Request for " + msg.getChannelType() + " channel recieved"));
            ChannelFactory cf = (ChannelFactory)this.allowedChannels.get(msg.getChannelType());
            if (cf == null) {
                this.sendChannelOpenFailure(msg.getSenderChannelId(), 2L, "The channel type is not supported", "");
                log.info((Object)("Request for channel type " + msg.getChannelType() + " refused"));
                return;
            }
            try {
                log.info((Object)("Creating channel " + msg.getChannelType()));
                Channel channel = cf.createChannel(msg.getChannelType(), msg.getChannelData());
                log.info((Object)"Initiating channel");
                Long channelId = this.getChannelId();
                channel.init(this, channelId, msg.getSenderChannelId(), msg.getInitialWindowSize(), msg.getMaximumPacketSize());
                this.activeChannels.put(channelId, channel);
                log.info((Object)"Sending channel open confirmation");
                this.sendChannelOpenConfirmation(channel);
                channel.open();
            }
            catch (InvalidChannelException ice) {
                this.sendChannelOpenFailure(msg.getSenderChannelId(), 2L, ice.getMessage(), "");
            }
        }
    }

    private void onMsgChannelRequest(SshMsgChannelRequest msg) throws IOException {
        Channel channel = this.getChannel(msg.getRecipientChannel());
        if (channel == null) {
            log.warn((Object)"Remote computer tried to make a request for a non existence channel!");
        }
        channel.onChannelRequest(msg.getRequestType(), msg.getWantReply(), msg.getChannelData());
    }

    private void onMsgChannelWindowAdjust(SshMsgChannelWindowAdjust msg) throws IOException {
        Channel channel = this.getChannel(msg.getRecipientChannel());
        if (channel == null) {
            throw new IOException("Remote computer tried to increase window space for non existent channel " + String.valueOf(msg.getRecipientChannel()));
        }
        channel.getRemoteWindow().increaseWindowSpace(msg.getBytesToAdd());
        if (log.isDebugEnabled()) {
            log.debug((Object)(String.valueOf(String.valueOf(msg.getBytesToAdd())) + " bytes added to remote window"));
            log.debug((Object)("Remote window space is " + String.valueOf(channel.getRemoteWindow().getWindowSpace())));
        }
    }

    private void onMsgGlobalRequest(SshMsgGlobalRequest msg) throws IOException {
        this.onGlobalRequest(msg.getRequestName(), msg.getWantReply(), msg.getRequestData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void freeChannel(Channel channel) {
        Map map = this.activeChannels;
        synchronized (map) {
            log.info((Object)("Freeing channel " + String.valueOf(channel.getLocalChannelId()) + " [" + channel.getName() + "]"));
            Long channelId = new Long(channel.getLocalChannelId());
            this.activeChannels.remove(channelId);
        }
    }
}

