/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.io;

import com.sshtools.j2ssh.io.UnsignedInteger32;
import com.sshtools.j2ssh.io.UnsignedInteger64;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;

public class ByteArrayWriter
extends ByteArrayOutputStream {
    public void writeBigInteger(BigInteger bi) throws IOException {
        byte[] raw = bi.toByteArray();
        this.writeInt(raw.length);
        this.write(raw);
    }

    public void writeBoolean(boolean b) throws IOException {
        this.write(b ? 1 : 0);
    }

    public void writeBinaryString(byte[] data) throws IOException {
        this.writeInt(data.length);
        this.write(data);
    }

    public void writeInt(long i) throws IOException {
        byte[] raw = new byte[]{(byte)(i >> 24), (byte)(i >> 16), (byte)(i >> 8), (byte)i};
        this.write(raw);
    }

    public void writeInt(int i) throws IOException {
        byte[] raw = new byte[]{(byte)(i >> 24), (byte)(i >> 16), (byte)(i >> 8), (byte)i};
        this.write(raw);
    }

    public static byte[] encodeInt(int i) {
        byte[] raw = new byte[]{(byte)(i >> 24), (byte)(i >> 16), (byte)(i >> 8), (byte)i};
        return raw;
    }

    public void writeUINT32(UnsignedInteger32 value) throws IOException {
        this.writeInt(value.longValue());
    }

    public void writeUINT64(UnsignedInteger64 value) throws IOException {
        byte[] raw = new byte[8];
        byte[] bi = value.bigIntValue().toByteArray();
        System.arraycopy(bi, 0, raw, raw.length - bi.length, bi.length);
        this.write(raw);
    }

    public static void writeIntToArray(byte[] array, int pos, int value) throws IOException {
        if (array.length - pos < 4) {
            throw new IOException("Not enough data in array to write integer at position " + String.valueOf(pos));
        }
        array[pos] = (byte)(value >> 24);
        array[pos + 1] = (byte)(value >> 16);
        array[pos + 2] = (byte)(value >> 8);
        array[pos + 3] = (byte)value;
    }

    public void writeString(String str) throws IOException {
        if (str == null) {
            this.writeInt(0);
        } else {
            this.writeInt(str.length());
            this.write(str.getBytes("US-ASCII"));
        }
    }
}

