/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.io;

import com.sshtools.j2ssh.SshThread;
import com.sshtools.j2ssh.io.IOStreamConnectorListener;
import com.sshtools.j2ssh.io.IOStreamConnectorState;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.event.EventListenerList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IOStreamConnector {
    private static Log log;
    private IOStreamConnectorState state = new IOStreamConnectorState();
    private InputStream in = null;
    private OutputStream out = null;
    private Thread thread;
    private long bytes;
    private boolean closeInput = true;
    private boolean closeOutput = true;
    protected EventListenerList listenerList = new EventListenerList();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.sshtools.j2ssh.io.IOStreamConnector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public IOStreamConnector() {
    }

    public IOStreamConnector(InputStream in, OutputStream out) {
        this.connect(in, out);
    }

    public IOStreamConnectorState getState() {
        return this.state;
    }

    public void close() throws IOException {
        log.info((Object)"Closing IOStreamConnector");
        this.state.setValue(4);
        if (this.closeInput) {
            this.in.close();
        }
        if (this.closeOutput) {
            this.out.close();
        }
        this.thread = null;
    }

    public void setCloseInput(boolean closeInput) {
        this.closeInput = closeInput;
    }

    public void setCloseOutput(boolean closeOutput) {
        this.closeOutput = closeOutput;
    }

    public void connect(InputStream in, OutputStream out) {
        this.in = in;
        this.out = out;
        log.info((Object)"Connecting InputStream to OutputStream");
        this.state.setValue(2);
        this.thread = new SshThread(new IOStreamConnectorThread(), "IOStream connector", true);
        this.thread.start();
    }

    public long getBytes() {
        return this.bytes;
    }

    public void addIOStreamConnectorListener(IOStreamConnectorListener l) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("com.sshtools.j2ssh.io.IOStreamConnectorListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.add(clazz, l);
    }

    public void removeIOStreamConnectorListener(IOStreamConnectorListener l) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("com.sshtools.j2ssh.io.IOStreamConnectorListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.remove(clazz, l);
    }

    class IOStreamConnectorThread
    implements Runnable {
        private Log log;
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;

        IOStreamConnectorThread() {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.sshtools.j2ssh.io.IOStreamConnector$IOStreamConnectorThread");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.log = LogFactory.getLog((Class)clazz);
        }

        public void run() {
            byte[] buffer = new byte[4096];
            int read = 0;
            this.log.info((Object)"Starting IOStreamConnectorThread thread");
            while (IOStreamConnector.this.state.getValue() == 2) {
                try {
                    read = IOStreamConnector.this.in.read(buffer, 0, 1);
                    if (read > 0) {
                        int count = read;
                        int available = IOStreamConnector.this.in.available();
                        if (available > 0 && buffer.length - 1 < available) {
                            byte[] tmp = new byte[available + 1];
                            System.arraycopy(buffer, 0, tmp, 0, 1);
                            buffer = tmp;
                        }
                        if (available > 0) {
                            read = IOStreamConnector.this.in.read(buffer, 1, available);
                            count += read;
                        }
                        IOStreamConnector.this.out.write(buffer, 0, count);
                        IOStreamConnector iOStreamConnector = IOStreamConnector.this;
                        iOStreamConnector.bytes = iOStreamConnector.bytes + (long)count;
                        IOStreamConnector.this.out.flush();
                        EventListenerList eventListenerList = IOStreamConnector.this.listenerList;
                        Class<?> clazz = class$1;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("com.sshtools.j2ssh.io.IOStreamConnectorListener");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        IOStreamConnectorListener[] l = (IOStreamConnectorListener[])eventListenerList.getListeners(clazz);
                        int i = l.length - 1;
                        while (i >= 0) {
                            l[i].data(buffer, count);
                            --i;
                        }
                        continue;
                    }
                    this.log.debug((Object)("Blocking read returned with " + String.valueOf(read)));
                    if (read >= 0) continue;
                    IOStreamConnector.this.state.setValue(3);
                }
                catch (IOException ioe) {
                    if (IOStreamConnector.this.state.getValue() != 2) continue;
                    this.log.debug((Object)ioe.getMessage());
                    IOStreamConnector.this.state.setValue(3);
                }
            }
            try {
                if (IOStreamConnector.this.state.getValue() != 4) {
                    IOStreamConnector.this.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.log.info((Object)"IOStreamConnectorThread is exiting");
        }
    }
}

