/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.openssh;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class PEM {
    public static final String DSA_PRIVATE_KEY = "DSA PRIVATE KEY";
    public static final String RSA_PRIVATE_KEY = "RSA PRIVATE KEY";
    protected static final String PEM_BOUNDARY = "-----";
    protected static final String PEM_BEGIN = "-----BEGIN ";
    protected static final String PEM_END = "-----END ";
    protected static final int MAX_LINE_LENGTH = 75;
    protected static final char[] HEX_CHARS = "0123456789ABCDEF".toCharArray();
    private static final int MD5_HASH_BYTES = 16;

    protected static SecretKey getKeyFromPassphrase(String passphrase, byte[] iv, int keySize) throws NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] passphraseBytes;
        try {
            passphraseBytes = passphrase.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("Mandatory US-ASCII character encoding is not supported by the VM");
        }
        MessageDigest hash = MessageDigest.getInstance("MD5");
        byte[] key = new byte[keySize];
        int hashesSize = keySize & 0xFFFFFFF0;
        if ((keySize & 0xF) != 0) {
            hashesSize += 16;
        }
        byte[] hashes = new byte[hashesSize];
        int index = 0;
        while (index + 16 <= hashes.length) {
            hash.update(passphraseBytes, 0, passphraseBytes.length);
            hash.update(iv, 0, iv.length);
            byte[] previous = hash.digest();
            System.arraycopy(previous, 0, hashes, index, previous.length);
            index += previous.length;
            hash.update(previous, 0, previous.length);
        }
        System.arraycopy(hashes, 0, key, 0, key.length);
        return new SecretKeySpec(key, "DESede");
    }
}

