/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.openssh;

import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.openssh.PEM;
import com.sshtools.j2ssh.util.Base64;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class PEMWriter
extends PEM {
    private String type;
    private Map header = new HashMap();
    private byte[] payload;

    public void write(Writer w) throws IOException {
        PrintWriter writer = new PrintWriter(w, true);
        writer.println("-----BEGIN " + this.type + "-----");
        if (!this.header.isEmpty()) {
            Iterator i = this.header.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                String value = (String)this.header.get(key);
                writer.print(String.valueOf(key) + ": ");
                if (key.length() + value.length() + 2 > 75) {
                    int offset = Math.max(75 - key.length() - 2, 0);
                    writer.println(String.valueOf(value.substring(0, offset)) + "\\");
                    while (offset < value.length()) {
                        if (offset + 75 >= value.length()) {
                            writer.println(value.substring(offset));
                        } else {
                            writer.println(String.valueOf(value.substring(offset, offset + 75)) + "\\");
                        }
                        offset += 75;
                    }
                    continue;
                }
                writer.println(value);
            }
            writer.println();
        }
        writer.println(Base64.encodeBytes(this.payload, false));
        writer.println("-----END " + this.type + "-----");
    }

    public void encryptPayload(byte[] payload, String passphrase) throws GeneralSecurityException {
        if (passphrase == null || passphrase.length() == 0) {
            this.setPayload(payload);
            return;
        }
        SecureRandom rnd = ConfigurationLoader.getRND();
        byte[] iv = new byte[8];
        rnd.nextBytes(iv);
        StringBuffer ivString = new StringBuffer(16);
        int i = 0;
        while (i < iv.length) {
            ivString.append(HEX_CHARS[(iv[i] & 0xFF) >> 4]);
            ivString.append(HEX_CHARS[iv[i] & 0xF]);
            ++i;
        }
        this.header.put("DEK-Info", "DES-EDE3-CBC," + ivString);
        this.header.put("Proc-Type", "4,ENCRYPTED");
        Cipher cipher = Cipher.getInstance("DESede/CBC/NoPadding");
        SecretKey key = PEMWriter.getKeyFromPassphrase(passphrase, iv, 24);
        cipher.init(1, (Key)key, new IvParameterSpec(iv));
        byte[] encrypted = new byte[payload.length];
        cipher.update(payload, 0, payload.length, encrypted, 0);
        this.setPayload(encrypted);
    }

    public Map getHeader() {
        return this.header;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public String getType() {
        return this.type;
    }

    public void setPayload(byte[] bs) {
        this.payload = bs;
    }

    public void setType(String string) {
        this.type = string;
    }
}

