/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.sftp;

import com.sshtools.j2ssh.io.UnsignedInteger32;
import com.sshtools.j2ssh.io.UnsignedInteger64;
import com.sshtools.j2ssh.sftp.FileAttributes;
import com.sshtools.j2ssh.sftp.SftpFile;
import com.sshtools.j2ssh.sftp.SftpMessageStore;
import com.sshtools.j2ssh.sftp.SshFxpAttrs;
import com.sshtools.j2ssh.sftp.SshFxpClose;
import com.sshtools.j2ssh.sftp.SshFxpData;
import com.sshtools.j2ssh.sftp.SshFxpFSetStat;
import com.sshtools.j2ssh.sftp.SshFxpFStat;
import com.sshtools.j2ssh.sftp.SshFxpHandle;
import com.sshtools.j2ssh.sftp.SshFxpInit;
import com.sshtools.j2ssh.sftp.SshFxpMkdir;
import com.sshtools.j2ssh.sftp.SshFxpName;
import com.sshtools.j2ssh.sftp.SshFxpOpen;
import com.sshtools.j2ssh.sftp.SshFxpOpenDir;
import com.sshtools.j2ssh.sftp.SshFxpRead;
import com.sshtools.j2ssh.sftp.SshFxpReadDir;
import com.sshtools.j2ssh.sftp.SshFxpReadlink;
import com.sshtools.j2ssh.sftp.SshFxpRealPath;
import com.sshtools.j2ssh.sftp.SshFxpRemove;
import com.sshtools.j2ssh.sftp.SshFxpRename;
import com.sshtools.j2ssh.sftp.SshFxpRmdir;
import com.sshtools.j2ssh.sftp.SshFxpSetStat;
import com.sshtools.j2ssh.sftp.SshFxpStat;
import com.sshtools.j2ssh.sftp.SshFxpStatus;
import com.sshtools.j2ssh.sftp.SshFxpSymlink;
import com.sshtools.j2ssh.sftp.SshFxpVersion;
import com.sshtools.j2ssh.sftp.SshFxpWrite;
import com.sshtools.j2ssh.subsystem.SubsystemChannel;
import com.sshtools.j2ssh.subsystem.SubsystemMessage;
import com.sshtools.j2ssh.transport.MessageNotAvailableException;
import com.sshtools.j2ssh.transport.MessageStoreEOFException;
import java.io.IOException;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SftpSubsystemClient
extends SubsystemChannel {
    public static final int OPEN_READ = 1;
    public static final int OPEN_WRITE = 2;
    public static final int OPEN_APPEND = 4;
    public static final int OPEN_CREATE = 8;
    public static final int OPEN_TRUNCATE = 16;
    public static final int OPEN_EXCLUSIVE = 32;
    public static final int VERSION_1 = 1;
    public static final int VERSION_2 = 2;
    public static final int VERSION_3 = 3;
    public static final int VERSION_4 = 4;
    private static Log log;
    private List handles = new Vector();
    private UnsignedInteger32 nextRequestId = new UnsignedInteger32(1L);
    private int version = 3;
    private SftpMessageStore messageStore;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.sshtools.j2ssh.sftp.SftpSubsystemClient");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public SftpSubsystemClient() {
        super("sftp", new SftpMessageStore());
        this.messageStore = (SftpMessageStore)((SubsystemChannel)this).messageStore;
        this.registerMessages();
    }

    public String getName() {
        return "sftp";
    }

    protected long availableWindowSpace() {
        return this.getRemoteWindow().getWindowSpace();
    }

    protected long maximumPacketSize() {
        return this.getRemotePacketSize();
    }

    protected synchronized void closeHandle(byte[] handle) throws IOException {
        if (!this.isValidHandle(handle)) {
            throw new IOException("The handle is invalid!");
        }
        this.handles.remove(handle);
        UnsignedInteger32 requestId = this.nextRequestId();
        SshFxpClose msg = new SshFxpClose(requestId, handle);
        this.sendMessage(msg);
        this.getOKRequestStatus(requestId);
    }

    public void closeFile(SftpFile file) throws IOException {
        this.closeHandle(file.getHandle());
    }

    protected boolean isValidHandle(byte[] handle) {
        return this.handles.contains(handle);
    }

    public synchronized int listChildren(SftpFile file, List children) throws IOException {
        if (file.isDirectory()) {
            if (!this.isValidHandle(file.getHandle()) && !this.isValidHandle((file = this.openDirectory(file.getAbsolutePath())).getHandle())) {
                throw new IOException("Failed to open directory");
            }
        } else {
            throw new IOException("Cannot list children for this file object");
        }
        UnsignedInteger32 requestId = this.nextRequestId();
        SshFxpReadDir msg = new SshFxpReadDir(requestId, file.getHandle());
        this.sendMessage(msg);
        try {
            SubsystemMessage reply = this.messageStore.getMessage(requestId);
            if (reply instanceof SshFxpName) {
                SshFxpName names = (SshFxpName)reply;
                SftpFile[] files = names.getFiles();
                int i = 0;
                while (i < files.length) {
                    SftpFile f = new SftpFile(String.valueOf(file.getAbsolutePath()) + "/" + files[i].getFilename(), files[i].getAttributes());
                    f.setSFTPSubsystem(this);
                    children.add(f);
                    ++i;
                }
                return files.length;
            }
            if (reply instanceof SshFxpStatus) {
                SshFxpStatus status = (SshFxpStatus)reply;
                if (status.getErrorCode().intValue() == 1) {
                    return -1;
                }
                throw new IOException(status.getErrorMessage());
            }
            throw new IOException("Unexpected server response " + reply.getMessageName());
        }
        catch (InterruptedException ex) {
            throw new IOException("The thread was interrupted");
        }
    }

    public synchronized void makeDirectory(String path) throws IOException {
        UnsignedInteger32 requestId = this.nextRequestId();
        SshFxpMkdir msg = new SshFxpMkdir(requestId, path, new FileAttributes());
        this.sendMessage(msg);
        this.getOKRequestStatus(requestId);
    }

    /*
     * Unable to fully structure code
     */
    public void recurseMakeDirectory(String path) throws IOException {
        block6: {
            if (path.trim().length() > 0) {
                try {
                    file = this.openDirectory(path);
                    file.close();
                    break block6;
                }
                catch (IOException ioe) {
                    tokenizer = new StringTokenizer(path, "/", true);
                    dir = "";
                    ** while (tokenizer.hasMoreElements())
                }
lbl-1000:
                // 1 sources

                {
                    dir = String.valueOf(dir) + tokenizer.nextElement();
                    try {
                        file = this.openDirectory(dir);
                        file.close();
                    }
                    catch (IOException ioe2) {
                        SftpSubsystemClient.log.info((Object)("Creating " + dir));
                        this.makeDirectory(dir);
                    }
                    continue;
                }
            }
        }
    }

    public synchronized SftpFile openDirectory(String path) throws IOException {
        String absolutePath = this.getAbsolutePath(path);
        UnsignedInteger32 requestId = this.nextRequestId();
        SubsystemMessage msg = new SshFxpOpenDir(requestId, absolutePath);
        this.sendMessage(msg);
        byte[] handle = this.getHandleResponse(requestId);
        requestId = this.nextRequestId();
        msg = new SshFxpStat(requestId, absolutePath);
        this.sendMessage(msg);
        try {
            SubsystemMessage reply = this.messageStore.getMessage(requestId);
            if (reply instanceof SshFxpAttrs) {
                SftpFile file = new SftpFile(absolutePath, ((SshFxpAttrs)reply).getAttributes());
                file.setHandle(handle);
                file.setSFTPSubsystem(this);
                return file;
            }
            if (reply instanceof SshFxpStatus) {
                throw new IOException(((SshFxpStatus)reply).getErrorMessage());
            }
            throw new IOException("Unexpected server response " + reply.getMessageName());
        }
        catch (InterruptedException ex) {
            throw new IOException("The thread was interrupted");
        }
    }

    public String getDefaultDirectory() throws IOException {
        return this.getAbsolutePath("");
    }

    public synchronized String getAbsolutePath(String path) throws IOException {
        UnsignedInteger32 requestId = this.nextRequestId();
        SshFxpRealPath msg = new SshFxpRealPath(requestId, path);
        this.sendMessage(msg);
        try {
            SubsystemMessage reply = this.messageStore.getMessage(requestId);
            if (reply instanceof SshFxpName) {
                SftpFile[] files = ((SshFxpName)reply).getFiles();
                if (files.length != 1) {
                    throw new IOException("Server responded to SSH_FXP_REALPATH with too many files!");
                }
                return files[0].getAbsolutePath();
            }
            if (reply instanceof SshFxpStatus) {
                throw new IOException(((SshFxpStatus)reply).getErrorMessage());
            }
            throw new IOException("Unexpected server response " + reply.getMessageName());
        }
        catch (InterruptedException ex) {
            throw new IOException("The thread was interrupted");
        }
    }

    public String getAbsolutePath(SftpFile file) throws IOException {
        return this.getAbsolutePath(file.getFilename());
    }

    public SftpFile openFile(String filename, int flags) throws IOException {
        return this.openFile(filename, flags, null);
    }

    public synchronized SftpFile openFile(String absolutePath, int flags, FileAttributes attrs) throws IOException {
        if (attrs == null) {
            attrs = new FileAttributes();
        }
        UnsignedInteger32 requestId = this.nextRequestId();
        SshFxpOpen msg = new SshFxpOpen(requestId, absolutePath, new UnsignedInteger32(flags), attrs);
        this.sendMessage(msg);
        byte[] handle = this.getHandleResponse(requestId);
        SftpFile file = new SftpFile(absolutePath, null);
        file.setHandle(handle);
        file.setSFTPSubsystem(this);
        return file;
    }

    public synchronized FileAttributes getAttributes(String path) throws IOException {
        UnsignedInteger32 requestId = this.nextRequestId();
        SshFxpStat msg = new SshFxpStat(requestId, path);
        this.sendMessage(msg);
        try {
            SubsystemMessage reply = this.messageStore.getMessage(requestId);
            if (reply instanceof SshFxpAttrs) {
                return ((SshFxpAttrs)reply).getAttributes();
            }
            if (reply instanceof SshFxpStatus) {
                throw new IOException(((SshFxpStatus)reply).getErrorMessage());
            }
            throw new IOException("Unexpected server response " + reply.getMessageName());
        }
        catch (InterruptedException ex) {
            throw new IOException("The thread was interrupted");
        }
    }

    public synchronized FileAttributes getAttributes(SftpFile file) throws IOException {
        UnsignedInteger32 requestId = this.nextRequestId();
        SubsystemMessage msg = !this.isValidHandle(file.getHandle()) ? new SshFxpStat(requestId, file.getAbsolutePath()) : new SshFxpFStat(requestId, file.getHandle());
        this.sendMessage(msg);
        try {
            SubsystemMessage reply = this.messageStore.getMessage(requestId);
            if (reply instanceof SshFxpAttrs) {
                return ((SshFxpAttrs)reply).getAttributes();
            }
            if (reply instanceof SshFxpStatus) {
                throw new IOException(((SshFxpStatus)reply).getErrorMessage());
            }
            throw new IOException("Unexpected server response " + reply.getMessageName());
        }
        catch (InterruptedException ex) {
            throw new IOException("The thread was interrupted");
        }
    }

    protected synchronized int readFile(byte[] handle, UnsignedInteger64 offset, byte[] output, int off, int len) throws IOException {
        if (!this.handles.contains(handle)) {
            throw new IOException("The file handle is invalid!");
        }
        if (output.length - off < len) {
            throw new IOException("Output array size is smaller than read length!");
        }
        UnsignedInteger32 requestId = this.nextRequestId();
        SshFxpRead msg = new SshFxpRead(requestId, handle, offset, new UnsignedInteger32(len));
        this.sendMessage(msg);
        try {
            SubsystemMessage reply = this.messageStore.getMessage(requestId);
            if (reply instanceof SshFxpData) {
                byte[] msgdata = ((SshFxpData)reply).getData();
                System.arraycopy(msgdata, 0, output, off, msgdata.length);
                return msgdata.length;
            }
            if (reply instanceof SshFxpStatus) {
                SshFxpStatus status = (SshFxpStatus)reply;
                if (status.getErrorCode().intValue() == 1) {
                    return -1;
                }
                throw new IOException(((SshFxpStatus)reply).getErrorMessage());
            }
            throw new IOException("Unexpected server response " + reply.getMessageName());
        }
        catch (InterruptedException ex) {
            throw new IOException("The thread was interrupted");
        }
    }

    public synchronized void removeDirectory(String path) throws IOException {
        UnsignedInteger32 requestId = this.nextRequestId();
        SshFxpRmdir msg = new SshFxpRmdir(requestId, path);
        this.sendMessage(msg);
        this.getOKRequestStatus(requestId);
    }

    public synchronized void removeFile(String filename) throws IOException {
        UnsignedInteger32 requestId = this.nextRequestId();
        SshFxpRemove msg = new SshFxpRemove(requestId, filename);
        this.sendMessage(msg);
        this.getOKRequestStatus(requestId);
    }

    public synchronized void renameFile(String oldpath, String newpath) throws IOException {
        UnsignedInteger32 requestId = this.nextRequestId();
        SshFxpRename msg = new SshFxpRename(requestId, oldpath, newpath);
        this.sendMessage(msg);
        this.getOKRequestStatus(requestId);
    }

    protected synchronized void writeFile(byte[] handle, UnsignedInteger64 offset, byte[] data, int off, int len) throws IOException {
        if (!this.handles.contains(handle)) {
            throw new IOException("The handle is not valid!");
        }
        if (data.length - off < len) {
            throw new IOException("Incorrect data array size!");
        }
        UnsignedInteger32 requestId = this.nextRequestId();
        SshFxpWrite msg = new SshFxpWrite(requestId, handle, offset, data, off, len);
        this.sendMessage(msg);
        this.getOKRequestStatus(requestId);
    }

    public synchronized void createSymbolicLink(String targetpath, String linkpath) throws IOException {
        UnsignedInteger32 requestId = this.nextRequestId();
        SshFxpSymlink msg = new SshFxpSymlink(requestId, targetpath, linkpath);
        this.sendMessage(msg);
        this.getOKRequestStatus(requestId);
    }

    public synchronized String getSymbolicLinkTarget(String linkpath) throws IOException {
        UnsignedInteger32 requestId = this.nextRequestId();
        SshFxpReadlink msg = new SshFxpReadlink(requestId, linkpath);
        this.sendMessage(msg);
        try {
            SubsystemMessage reply = this.messageStore.getMessage(requestId);
            if (reply instanceof SshFxpName) {
                SftpFile[] files = ((SshFxpName)reply).getFiles();
                if (files.length != 1) {
                    throw new IOException("Server responded to SSH_FXP_REALLINK with too many files!");
                }
                return files[0].getAbsolutePath();
            }
            if (reply instanceof SshFxpStatus) {
                throw new IOException(((SshFxpStatus)reply).getErrorMessage());
            }
            throw new IOException("Unexpected server response " + reply.getMessageName());
        }
        catch (InterruptedException ex) {
            throw new IOException("The thread was interrupted");
        }
    }

    public synchronized void setAttributes(String path, FileAttributes attrs) throws IOException {
        UnsignedInteger32 requestId = this.nextRequestId();
        SshFxpSetStat msg = new SshFxpSetStat(requestId, path, attrs);
        this.sendMessage(msg);
        this.getOKRequestStatus(requestId);
    }

    public synchronized void setAttributes(SftpFile file, FileAttributes attrs) throws IOException {
        if (!this.isValidHandle(file.getHandle())) {
            throw new IOException("The handle is not an open file handle!");
        }
        UnsignedInteger32 requestId = this.nextRequestId();
        SshFxpFSetStat msg = new SshFxpFSetStat(requestId, file.getHandle(), attrs);
        this.sendMessage(msg);
        this.getOKRequestStatus(requestId);
    }

    public void changePermissions(SftpFile file, String permissions) throws IOException {
        FileAttributes attrs = new FileAttributes();
        attrs.setPermissions(permissions);
        this.setAttributes(file, attrs);
    }

    public void changePermissions(SftpFile file, int permissions) throws IOException {
        FileAttributes attrs = new FileAttributes();
        attrs.setPermissions(new UnsignedInteger32(permissions));
        this.setAttributes(file, attrs);
    }

    public void changePermissions(String filename, int permissions) throws IOException {
        FileAttributes attrs = new FileAttributes();
        attrs.setPermissions(new UnsignedInteger32(permissions));
        this.setAttributes(filename, attrs);
    }

    public void changePermissions(String filename, String permissions) throws IOException {
        FileAttributes attrs = new FileAttributes();
        attrs.setPermissions(permissions);
        this.setAttributes(filename, attrs);
    }

    public synchronized boolean initialize() throws IOException {
        log.info((Object)("Initializing SFTP protocol version " + String.valueOf(this.version)));
        if (!this.startSubsystem()) {
            return false;
        }
        boolean result = false;
        SshFxpInit msg = new SshFxpInit(new UnsignedInteger32(this.version), null);
        this.sendMessage(msg);
        SubsystemMessage reply = null;
        int i = 0;
        while (i < 30) {
            try {
                reply = this.messageStore.nextMessage(1000);
                break;
            }
            catch (MessageNotAvailableException messageNotAvailableException) {
            }
            catch (MessageStoreEOFException ex) {
                return false;
            }
            if (this.getState().getValue() != 2) {
                return false;
            }
            ++i;
        }
        if (reply instanceof SshFxpVersion) {
            result = true;
            this.version = ((SshFxpVersion)reply).getVersion().intValue();
            log.info((Object)("Server responded with version " + String.valueOf(this.version)));
        }
        return result;
    }

    private byte[] getHandleResponse(UnsignedInteger32 requestId) throws IOException {
        try {
            SubsystemMessage reply = this.messageStore.getMessage(requestId);
            if (reply instanceof SshFxpHandle) {
                byte[] handle = ((SshFxpHandle)reply).getHandle();
                this.handles.add(handle);
                return handle;
            }
            if (reply instanceof SshFxpStatus) {
                throw new IOException(((SshFxpStatus)reply).getErrorMessage());
            }
            throw new IOException("Unexpected server response " + reply.getMessageName());
        }
        catch (InterruptedException ex) {
            throw new IOException("The thread was interrupted");
        }
    }

    private void getOKRequestStatus(UnsignedInteger32 requestId) throws IOException {
        block5: {
            try {
                if (log.isDebugEnabled()) {
                    log.info((Object)"Waiting for response");
                }
                SubsystemMessage reply = this.messageStore.getMessage(requestId);
                log.info((Object)"Received response");
                if (reply instanceof SshFxpStatus) {
                    SshFxpStatus status = (SshFxpStatus)reply;
                    if (status.getErrorCode().intValue() != 0) {
                        throw new IOException(((SshFxpStatus)reply).getErrorMessage());
                    }
                    break block5;
                }
                throw new IOException("Unexpected server response " + reply.getMessageName());
            }
            catch (InterruptedException ex) {
                throw new IOException("The thread was interrupted");
            }
        }
    }

    private UnsignedInteger32 nextRequestId() {
        this.nextRequestId = UnsignedInteger32.add(this.nextRequestId, 1);
        return this.nextRequestId;
    }

    private void registerMessages() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("com.sshtools.j2ssh.sftp.SshFxpVersion");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.messageStore.registerMessage(2, clazz);
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("com.sshtools.j2ssh.sftp.SshFxpAttrs");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.messageStore.registerMessage(105, clazz2);
        Class<?> clazz3 = class$3;
        if (clazz3 == null) {
            try {
                clazz3 = class$3 = Class.forName("com.sshtools.j2ssh.sftp.SshFxpData");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.messageStore.registerMessage(103, clazz3);
        Class<?> clazz4 = class$4;
        if (clazz4 == null) {
            try {
                clazz4 = class$4 = Class.forName("com.sshtools.j2ssh.sftp.SshFxpHandle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.messageStore.registerMessage(102, clazz4);
        Class<?> clazz5 = class$5;
        if (clazz5 == null) {
            try {
                clazz5 = class$5 = Class.forName("com.sshtools.j2ssh.sftp.SshFxpStatus");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.messageStore.registerMessage(101, clazz5);
        Class<?> clazz6 = class$6;
        if (clazz6 == null) {
            try {
                clazz6 = class$6 = Class.forName("com.sshtools.j2ssh.sftp.SshFxpName");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.messageStore.registerMessage(104, clazz6);
    }

    protected int getMinimumWindowSpace() {
        return 1024;
    }

    protected int getMaximumWindowSpace() {
        return 131070;
    }

    protected int getMaximumPacketSize() {
        return 65535;
    }
}

