/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.sftp;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.io.UnsignedInteger32;
import com.sshtools.j2ssh.subsystem.SubsystemMessage;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SshFxpInit
extends SubsystemMessage {
    public static final int SSH_FXP_INIT = 1;
    private UnsignedInteger32 version;
    private Map extended;

    public SshFxpInit() {
        super(1);
    }

    public SshFxpInit(UnsignedInteger32 version, Map extended) {
        super(1);
        this.version = version;
        this.extended = extended;
    }

    public UnsignedInteger32 getVersion() {
        return this.version;
    }

    public Map getExtended() {
        return this.extended;
    }

    public void constructMessage(ByteArrayReader bar) throws IOException, InvalidMessageException {
        this.version = bar.readUINT32();
        this.extended = new HashMap();
        while (bar.available() > 0) {
            String key = bar.readString();
            String value = bar.readString();
            this.extended.put(key, value);
        }
    }

    public String getMessageName() {
        return "SSH_FXP_INIT";
    }

    public void constructByteArray(ByteArrayWriter baw) throws IOException, InvalidMessageException {
        baw.writeUINT32(this.version);
        if (this.extended != null && this.extended.size() > 0) {
            Iterator it = this.extended.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                baw.writeString((String)entry.getKey());
                baw.writeString((String)entry.getValue());
            }
        }
    }
}

