/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.subsystem;

import com.sshtools.j2ssh.connection.Channel;
import com.sshtools.j2ssh.connection.SshMsgChannelData;
import com.sshtools.j2ssh.connection.SshMsgChannelExtendedData;
import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.io.DynamicBuffer;
import com.sshtools.j2ssh.subsystem.SubsystemMessage;
import com.sshtools.j2ssh.subsystem.SubsystemMessageStore;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SubsystemChannel
extends Channel {
    private static Log log;
    Integer exitCode = null;
    String name;
    protected SubsystemMessageStore messageStore;
    DynamicBuffer buffer = new DynamicBuffer();
    int nextMessageLength = -1;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.sshtools.j2ssh.subsystem.SubsystemChannel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public SubsystemChannel(String name) {
        this.name = name;
        this.messageStore = new SubsystemMessageStore();
    }

    public SubsystemChannel(String name, SubsystemMessageStore messageStore) {
        this.name = name;
        this.messageStore = messageStore;
    }

    public String getChannelType() {
        return "session";
    }

    protected void sendMessage(SubsystemMessage msg) throws InvalidMessageException, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending " + msg.getMessageName() + " subsystem message"));
        }
        byte[] msgdata = msg.toByteArray();
        this.sendChannelData(ByteArrayWriter.encodeInt(msgdata.length));
        this.sendChannelData(msgdata);
    }

    protected void onChannelRequest(String requestType, boolean wantReply, byte[] requestData) throws IOException {
        log.debug((Object)("Channel Request received: " + requestType));
        if (requestType.equals("exit-status")) {
            this.exitCode = new Integer((int)ByteArrayReader.readInt(requestData, 0));
            log.debug((Object)("Exit code of " + this.exitCode.toString() + " received"));
        } else if (requestType.equals("exit-signal")) {
            ByteArrayReader bar = new ByteArrayReader(requestData);
            String signal = bar.readString();
            boolean coredump = bar.read() != 0;
            String message = bar.readString();
            String language = bar.readString();
            log.debug((Object)("Exit signal " + signal + " received"));
            log.debug((Object)("Signal message: " + message));
            log.debug((Object)("Core dumped: " + String.valueOf(coredump)));
        } else if (!requestType.equals("xon-xoff")) {
            if (requestType.equals("signal")) {
                String signal = ByteArrayReader.readString(requestData, 0);
                log.debug((Object)("Signal " + signal + " received"));
            } else if (wantReply) {
                this.connection.sendChannelRequestFailure(this);
            }
        }
    }

    protected void onChannelExtData(SshMsgChannelExtendedData msg) throws IOException {
    }

    protected void onChannelData(SshMsgChannelData msg) throws IOException {
        this.buffer.getOutputStream().write(msg.getChannelData());
        byte[] tmp = new byte[4];
        while (this.buffer.getInputStream().available() > 4) {
            if (this.nextMessageLength == -1) {
                int read = 0;
                while ((read += this.buffer.getInputStream().read(tmp)) < 4) {
                }
                this.nextMessageLength = (int)ByteArrayReader.readInt(tmp, 0);
            }
            if (this.buffer.getInputStream().available() < this.nextMessageLength) break;
            byte[] msgdata = new byte[this.nextMessageLength];
            this.buffer.getInputStream().read(msgdata);
            this.messageStore.addMessage(msgdata);
            this.nextMessageLength = -1;
        }
    }

    protected void onChannelEOF() throws IOException {
    }

    protected void onChannelClose() throws IOException {
    }

    public byte[] getChannelOpenData() {
        return null;
    }

    protected void onChannelOpen() throws IOException {
    }

    public boolean startSubsystem() throws IOException {
        log.info((Object)("Starting " + this.name + " subsystem"));
        ByteArrayWriter baw = new ByteArrayWriter();
        baw.writeString(this.name);
        return this.connection.sendChannelRequest(this, "subsystem", true, baw.toByteArray());
    }

    public byte[] getChannelConfirmationData() {
        return null;
    }
}

