/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport;

import com.sshtools.j2ssh.transport.HostKeyVerification;
import com.sshtools.j2ssh.transport.InvalidHostFileException;
import com.sshtools.j2ssh.transport.TransportProtocolException;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import com.sshtools.j2ssh.util.Base64;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractKnownHostsKeyVerification
implements HostKeyVerification {
    private static String defaultHostFile;
    private static Log log;
    private Map allowedHosts;
    private String knownhosts;
    private boolean hostFileWriteable;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.sshtools.j2ssh.transport.HostKeyVerification");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    /*
     * Exception decompiling
     */
    public AbstractKnownHostsKeyVerification(String knownhosts) throws InvalidHostFileException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 342->346)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean isHostFileWriteable() {
        return this.hostFileWriteable;
    }

    public abstract void onHostKeyMismatch(String var1, SshPublicKey var2, SshPublicKey var3) throws TransportProtocolException;

    public abstract void onUnknownHost(String var1, SshPublicKey var2) throws TransportProtocolException;

    public void allowHost(String host, SshPublicKey pk, boolean always) throws InvalidHostFileException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Allowing " + host + " with fingerprint " + pk.getFingerprint()));
        }
        this.putAllowedKey(host, pk);
        if (always) {
            this.saveHostFile();
        }
    }

    public Map allowedHosts() {
        return this.allowedHosts;
    }

    public void removeAllowedHost(String host) {
        Iterator it = this.allowedHosts.keySet().iterator();
        while (it.hasNext()) {
            StringTokenizer tokens = new StringTokenizer((String)it.next(), ",");
            while (tokens.hasMoreElements()) {
                String name = (String)tokens.nextElement();
                if (!name.equals(host)) continue;
                this.allowedHosts.remove(name);
            }
        }
    }

    public boolean verifyHost(String host, SshPublicKey pk) throws TransportProtocolException {
        String fingerprint = pk.getFingerprint();
        log.info((Object)("Verifying " + host + " host key"));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Fingerprint: " + fingerprint));
        }
        Iterator it = this.allowedHosts.keySet().iterator();
        while (it.hasNext()) {
            String names = (String)it.next();
            if (names.equals(host)) {
                return this.validateHost(names, pk);
            }
            StringTokenizer tokens = new StringTokenizer(names, ",");
            while (tokens.hasMoreElements()) {
                String name = (String)tokens.nextElement();
                if (!name.equalsIgnoreCase(host)) continue;
                return this.validateHost(names, pk);
            }
        }
        this.onUnknownHost(host, pk);
        return this.checkKey(host, pk);
    }

    private boolean validateHost(String names, SshPublicKey pk) throws TransportProtocolException {
        SshPublicKey pub = this.getAllowedKey(names, pk.getAlgorithmName());
        if (pub != null && pk.equals(pub)) {
            return true;
        }
        if (pub == null) {
            this.onUnknownHost(names, pk);
        } else {
            this.onHostKeyMismatch(names, pub, pk);
        }
        return this.checkKey(names, pk);
    }

    private boolean checkKey(String host, SshPublicKey key) {
        SshPublicKey pk = this.getAllowedKey(host, key.getAlgorithmName());
        return pk != null && pk.equals(key);
    }

    private SshPublicKey getAllowedKey(String names, String algorithm) {
        if (this.allowedHosts.containsKey(names)) {
            Map map = (Map)this.allowedHosts.get(names);
            return (SshPublicKey)map.get(algorithm);
        }
        return null;
    }

    private void putAllowedKey(String host, SshPublicKey key) {
        if (!this.allowedHosts.containsKey(host)) {
            this.allowedHosts.put(host, new HashMap());
        }
        Map map = (Map)this.allowedHosts.get(host);
        map.put(key.getAlgorithmName(), key);
    }

    public void saveHostFile() throws InvalidHostFileException {
        if (!this.hostFileWriteable) {
            throw new InvalidHostFileException("Host file is not writeable.");
        }
        log.info((Object)("Saving " + defaultHostFile));
        try {
            File f = new File(this.knownhosts);
            FileOutputStream out = new FileOutputStream(f);
            out.write(this.toString().getBytes());
            out.close();
        }
        catch (IOException e) {
            throw new InvalidHostFileException("Could not write to " + this.knownhosts);
        }
    }

    public String toString() {
        String knownhosts = "";
        Iterator it = this.allowedHosts.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Iterator it2 = ((Map)entry.getValue()).entrySet().iterator();
            while (it2.hasNext()) {
                Map.Entry entry2 = it2.next();
                SshPublicKey pk = (SshPublicKey)entry2.getValue();
                knownhosts = String.valueOf(knownhosts) + entry.getKey().toString() + " " + pk.getAlgorithmName() + " " + Base64.encodeBytes(pk.getEncoded(), true) + "\n";
            }
        }
        return knownhosts;
    }
}

