/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport;

import com.sshtools.j2ssh.SshThread;
import com.sshtools.j2ssh.transport.MessageStoreEOFException;
import com.sshtools.j2ssh.transport.Service;
import com.sshtools.j2ssh.transport.SshMessage;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AsyncService
extends Service
implements Runnable {
    private static Log log;
    protected SshThread thread;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.sshtools.j2ssh.transport.Service");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public AsyncService(String serviceName) {
        super(serviceName);
    }

    protected void onStart() throws IOException {
        this.thread = Thread.currentThread() instanceof SshThread ? ((SshThread)Thread.currentThread()).cloneThread(this, this.getServiceName()) : new SshThread(this, this.getServiceName(), true);
        log.info((Object)("Starting " + this.getServiceName() + " service thread"));
        this.thread.start();
    }

    public final void run() {
        int[] messageFilter = this.getAsyncMessageFilter();
        this.state.setValue(2);
        SshMessage msg = null;
        while (this.state.getValue() == 2 && this.transport.isConnected()) {
            try {
                msg = this.messageStore.getMessage(messageFilter);
                if (this.state.getValue() == 3) break;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Routing " + msg.getMessageName()));
                }
                this.onMessageReceived(msg);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Finished processing " + msg.getMessageName()));
            }
            catch (MessageStoreEOFException eof) {
                this.stop();
            }
            catch (Exception ex) {
                if (this.state.getValue() == 3 || !this.transport.isConnected()) continue;
                log.fatal((Object)"Service message loop failed!", (Throwable)ex);
                this.stop();
            }
        }
        this.onStop();
        log.info((Object)(String.valueOf(this.getServiceName()) + " thread is exiting"));
        this.thread = null;
    }

    protected abstract void onStop();

    protected abstract int[] getAsyncMessageFilter();

    protected abstract void onMessageReceived(SshMessage var1) throws IOException;
}

