/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport;

import com.sshtools.j2ssh.SshException;
import com.sshtools.j2ssh.transport.AlgorithmInitializationException;
import com.sshtools.j2ssh.transport.AlgorithmNotAgreedException;
import com.sshtools.j2ssh.transport.AlgorithmNotSupportedException;
import com.sshtools.j2ssh.transport.AlgorithmOperationException;
import com.sshtools.j2ssh.transport.HostKeyVerification;
import com.sshtools.j2ssh.transport.MessageAlreadyRegisteredException;
import com.sshtools.j2ssh.transport.Service;
import com.sshtools.j2ssh.transport.SshMessage;
import com.sshtools.j2ssh.transport.SshMessageStore;
import com.sshtools.j2ssh.transport.SshMsgKexInit;
import com.sshtools.j2ssh.transport.SshMsgServiceRequest;
import com.sshtools.j2ssh.transport.TransportProtocolCommon;
import com.sshtools.j2ssh.transport.TransportProtocolException;
import com.sshtools.j2ssh.transport.cipher.SshCipher;
import com.sshtools.j2ssh.transport.cipher.SshCipherFactory;
import com.sshtools.j2ssh.transport.hmac.SshHmac;
import com.sshtools.j2ssh.transport.hmac.SshHmacFactory;
import com.sshtools.j2ssh.transport.kex.KeyExchangeException;
import com.sshtools.j2ssh.transport.kex.SshKeyExchange;
import com.sshtools.j2ssh.transport.publickey.SshKeyPair;
import com.sshtools.j2ssh.transport.publickey.SshKeyPairFactory;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TransportProtocolClient
extends TransportProtocolCommon {
    protected SshPublicKey pk;
    private HostKeyVerification hosts;
    private Map services = new HashMap();
    private SshMessageStore ms = new SshMessageStore();
    static /* synthetic */ Class class$0;

    public TransportProtocolClient(HostKeyVerification hosts) throws TransportProtocolException {
        this.hosts = hosts;
    }

    public void onMessageReceived(SshMessage msg) throws IOException {
        throw new IOException("No messages are registered");
    }

    public void registerTransportMessages() throws MessageAlreadyRegisteredException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.sshtools.j2ssh.transport.SshMsgServiceAccept");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.ms.registerMessage(6, clazz);
        this.addMessageStore(this.ms);
    }

    public void requestService(Service service) throws IOException {
        if (service.getState().getValue() != 1) {
            throw new IOException("The service instance must be uninitialized");
        }
        if (this.state.getValue() != 4 && this.state.getValue() != 3) {
            throw new IOException("The transport protocol is not connected");
        }
        try {
            this.state.waitForState(4);
        }
        catch (InterruptedException ie) {
            throw new IOException("The operation was interrupted");
        }
        service.init(1, this);
        this.services.put(service.getServiceName(), service);
        SshMessage msg = new SshMsgServiceRequest(service.getServiceName());
        this.sendMessage(msg, this);
        try {
            msg = this.ms.getMessage(6);
        }
        catch (InterruptedException ex) {
            throw new SshException("The thread was interrupted whilst waiting for a transport protocol message");
        }
    }

    protected void onDisconnect() {
        Iterator it = this.services.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            ((Service)entry.getValue()).stop();
        }
        this.services.clear();
    }

    protected String getDecryptionAlgorithm() throws AlgorithmNotAgreedException {
        return this.determineAlgorithm(this.clientKexInit.getSupportedSCEncryption(), this.serverKexInit.getSupportedSCEncryption());
    }

    protected String getEncryptionAlgorithm() throws AlgorithmNotAgreedException {
        return this.determineAlgorithm(this.clientKexInit.getSupportedCSEncryption(), this.serverKexInit.getSupportedCSEncryption());
    }

    protected String getInputStreamCompAlgortihm() throws AlgorithmNotAgreedException {
        return this.determineAlgorithm(this.clientKexInit.getSupportedSCComp(), this.serverKexInit.getSupportedSCComp());
    }

    protected String getInputStreamMacAlgorithm() throws AlgorithmNotAgreedException {
        return this.determineAlgorithm(this.clientKexInit.getSupportedSCMac(), this.serverKexInit.getSupportedSCMac());
    }

    protected void setLocalIdent() {
        this.clientIdent = "SSH-2.0-" + SOFTWARE_VERSION_COMMENTS + " [CLIENT]";
    }

    public String getLocalId() {
        return this.clientIdent;
    }

    protected void setLocalKexInit(SshMsgKexInit msg) {
        log.debug((Object)msg.toString());
        this.clientKexInit = msg;
    }

    protected SshMsgKexInit getLocalKexInit() {
        return this.clientKexInit;
    }

    protected String getOutputStreamCompAlgorithm() throws AlgorithmNotAgreedException {
        return this.determineAlgorithm(this.clientKexInit.getSupportedCSComp(), this.serverKexInit.getSupportedCSComp());
    }

    protected String getOutputStreamMacAlgorithm() throws AlgorithmNotAgreedException {
        return this.determineAlgorithm(this.clientKexInit.getSupportedCSMac(), this.serverKexInit.getSupportedCSMac());
    }

    protected void setRemoteIdent(String ident) {
        this.serverIdent = ident;
    }

    public String getRemoteId() {
        return this.serverIdent;
    }

    protected void setRemoteKexInit(SshMsgKexInit msg) {
        this.serverKexInit = msg;
    }

    protected SshMsgKexInit getRemoteKexInit() {
        return this.serverKexInit;
    }

    public SshPublicKey getServerHostKey() {
        return this.pk;
    }

    protected void onStartTransportProtocol() throws IOException {
        while (this.state.getValue() != 4 && this.state.getValue() != 5) {
            try {
                this.state.waitForStateUpdate();
            }
            catch (InterruptedException ex) {
                throw new IOException("The operation was interrupted");
            }
        }
        if (this.state.getValue() == 5) {
            if (this.state.hasError()) {
                throw this.state.getLastError();
            }
            throw new TransportProtocolException("The connection did not complete");
        }
    }

    protected void performKeyExchange(SshKeyExchange kex) throws IOException {
        kex.performClientExchange(this.clientIdent, this.serverIdent, this.clientKexInit.toByteArray(), this.serverKexInit.toByteArray());
        if (!this.verifyHostKey(kex.getHostKey(), kex.getSignature(), kex.getExchangeHash())) {
            this.sendDisconnect(9, "The host key supplied was not valid", new KeyExchangeException("The host key is invalid or was not accepted!"));
        }
    }

    protected void setupNewKeys(byte[] encryptCSKey, byte[] encryptCSIV, byte[] encryptSCKey, byte[] encryptSCIV, byte[] macCSKey, byte[] macSCKey) throws AlgorithmNotAgreedException, AlgorithmOperationException, AlgorithmNotSupportedException, AlgorithmInitializationException {
        SshCipher sshCipher = SshCipherFactory.newInstance(this.getEncryptionAlgorithm());
        sshCipher.init(0, encryptCSIV, encryptCSKey);
        this.algorithmsOut.setCipher(sshCipher);
        sshCipher = SshCipherFactory.newInstance(this.getDecryptionAlgorithm());
        sshCipher.init(1, encryptSCIV, encryptSCKey);
        this.algorithmsIn.setCipher(sshCipher);
        SshHmac hmac = SshHmacFactory.newInstance(this.getOutputStreamMacAlgorithm());
        hmac.init(macCSKey);
        this.algorithmsOut.setHmac(hmac);
        hmac = SshHmacFactory.newInstance(this.getInputStreamMacAlgorithm());
        hmac.init(macSCKey);
        this.algorithmsIn.setHmac(hmac);
    }

    protected boolean verifyHostKey(byte[] key, byte[] sig, byte[] sigdata) throws TransportProtocolException {
        String host;
        SshKeyPair pair = SshKeyPairFactory.newInstance(this.determineAlgorithm(this.clientKexInit.getSupportedPublicKeys(), this.serverKexInit.getSupportedPublicKeys()));
        this.pk = pair.setPublicKey(key);
        try {
            InetAddress addr = InetAddress.getByName(this.properties.getHost());
            host = !addr.getHostAddress().equals(this.properties.getHost()) ? String.valueOf(addr.getHostName()) + "," + addr.getHostAddress() : addr.getHostAddress();
        }
        catch (UnknownHostException ex) {
            log.info((Object)("The host " + this.properties.getHost() + " could not be resolved"));
            host = this.properties.getHost();
        }
        if (!this.hosts.verifyHost(host, this.pk)) {
            log.info((Object)"The host key was not accepted");
            return false;
        }
        boolean result = this.pk.verifySignature(sig, sigdata);
        log.info((Object)("The host key signature is " + (result ? " valid" : "invalid")));
        return result;
    }
}

