/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport;

import com.sshtools.j2ssh.SshException;
import com.sshtools.j2ssh.SshThread;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.configuration.SshConnectionProperties;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.net.TransportProvider;
import com.sshtools.j2ssh.transport.AlgorithmInitializationException;
import com.sshtools.j2ssh.transport.AlgorithmNotAgreedException;
import com.sshtools.j2ssh.transport.AlgorithmNotSupportedException;
import com.sshtools.j2ssh.transport.AlgorithmOperationException;
import com.sshtools.j2ssh.transport.HostKeyVerification;
import com.sshtools.j2ssh.transport.MessageAlreadyRegisteredException;
import com.sshtools.j2ssh.transport.MessageNotRegisteredException;
import com.sshtools.j2ssh.transport.SshMessage;
import com.sshtools.j2ssh.transport.SshMessageStore;
import com.sshtools.j2ssh.transport.SshMsgDebug;
import com.sshtools.j2ssh.transport.SshMsgDisconnect;
import com.sshtools.j2ssh.transport.SshMsgIgnore;
import com.sshtools.j2ssh.transport.SshMsgKexInit;
import com.sshtools.j2ssh.transport.SshMsgNewKeys;
import com.sshtools.j2ssh.transport.SshMsgUnimplemented;
import com.sshtools.j2ssh.transport.TransportProtocol;
import com.sshtools.j2ssh.transport.TransportProtocolAlgorithmSync;
import com.sshtools.j2ssh.transport.TransportProtocolEventHandler;
import com.sshtools.j2ssh.transport.TransportProtocolException;
import com.sshtools.j2ssh.transport.TransportProtocolInputStream;
import com.sshtools.j2ssh.transport.TransportProtocolOutputStream;
import com.sshtools.j2ssh.transport.TransportProtocolState;
import com.sshtools.j2ssh.transport.kex.KeyExchangeException;
import com.sshtools.j2ssh.transport.kex.SshKeyExchange;
import com.sshtools.j2ssh.transport.kex.SshKeyExchangeFactory;
import com.sshtools.j2ssh.util.Hash;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class TransportProtocolCommon
implements TransportProtocol,
Runnable {
    protected static Log log;
    private static int nextThreadNo;
    public static final int EOL_CRLF = 1;
    public static final int EOL_LF = 2;
    public static final String PROTOCOL_VERSION = "2.0";
    public static String SOFTWARE_VERSION_COMMENTS;
    private int threadNo = nextThreadNo++;
    protected BigInteger k = null;
    protected Boolean completeOnNewKeys = new Boolean(false);
    protected HostKeyVerification hosts;
    protected Map kexs = new HashMap();
    private boolean sendIgnore = false;
    protected SshConnectionProperties properties;
    protected SshMessageStore messageStore = new SshMessageStore();
    protected SshMsgKexInit clientKexInit = null;
    protected SshMsgKexInit serverKexInit = null;
    protected String clientIdent = null;
    protected String serverIdent = null;
    protected TransportProtocolAlgorithmSync algorithmsIn;
    protected TransportProtocolAlgorithmSync algorithmsOut;
    protected TransportProtocolState state = new TransportProtocolState();
    private byte[] exchangeHash = null;
    protected byte[] sessionIdentifier = null;
    protected byte[] hostKey = null;
    protected byte[] signature = null;
    private Vector eventHandlers = new Vector();
    private List messageStack = new ArrayList();
    private Map messageNotifications = new HashMap();
    private Object kexLock = new Object();
    private Object keyLock = new Object();
    TransportProvider provider;
    private SshThread thread;
    private long kexTimeout = 3600000L;
    private long kexTransferLimit = 0x40000000L;
    private long startTime = System.currentTimeMillis();
    protected TransportProtocolInputStream sshIn;
    protected TransportProtocolOutputStream sshOut;
    private int remoteEOL = 1;
    private Vector messageStores = new Vector();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.sshtools.j2ssh.transport.TransportProtocolCommon");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
        nextThreadNo = 1;
        SOFTWARE_VERSION_COMMENTS = "http://www.sshtools.com " + ConfigurationLoader.getVersionString("J2SSH", "j2ssh.properties");
    }

    public int getConnectionId() {
        return this.threadNo;
    }

    public int getRemoteEOL() {
        return this.remoteEOL;
    }

    public TransportProtocolState getState() {
        return this.state;
    }

    public SshConnectionProperties getProperties() {
        return this.properties;
    }

    protected abstract void onDisconnect();

    public void disconnect(String description) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Disconnect: " + description));
        }
        try {
            this.state.setValue(5);
            this.state.setDisconnectReason(description);
            this.sendDisconnect(11, description);
        }
        catch (Exception e) {
            log.warn((Object)"Failed to send disconnect", (Throwable)e);
        }
    }

    public void setSendIgnore(boolean sendIgnore) {
        this.sendIgnore = sendIgnore;
    }

    public void setKexTimeout(long seconds) throws TransportProtocolException {
        if (seconds < 60L) {
            throw new TransportProtocolException("Keys can only be re-exchanged every minute or more");
        }
        this.kexTimeout = seconds * 1000L;
    }

    public void setKexTransferLimit(long kilobytes) throws TransportProtocolException {
        if (kilobytes < 10L) {
            throw new TransportProtocolException("Keys can only be re-exchanged after every 10k of data, or more");
        }
        this.kexTransferLimit = kilobytes * 1024L;
    }

    public long getOutgoingByteCount() {
        return this.sshOut.getNumBytesTransfered();
    }

    public long getIncomingByteCount() {
        return this.sshIn.getNumBytesTransfered();
    }

    public void addEventHandler(TransportProtocolEventHandler eventHandler) {
        if (eventHandler != null) {
            this.eventHandlers.add(eventHandler);
        }
    }

    public abstract void registerTransportMessages() throws MessageAlreadyRegisteredException;

    public byte[] getSessionIdentifier() {
        return (byte[])this.sessionIdentifier.clone();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            try {
                this.state.setValue(2);
                log.info((Object)"Registering transport protocol messages with inputstream");
                this.algorithmsOut = new TransportProtocolAlgorithmSync();
                this.algorithmsIn = new TransportProtocolAlgorithmSync();
                this.sshIn = new TransportProtocolInputStream(this, this.provider.getInputStream(), this.algorithmsIn);
                this.sshOut = new TransportProtocolOutputStream(this.provider.getOutputStream(), this, this.algorithmsOut);
                Class<?> clazz = class$1;
                if (clazz == null) {
                    Class<?> clazz2;
                    try {
                        clazz2 = Class.forName("com.sshtools.j2ssh.transport.SshMsgDisconnect");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz = class$1 = clazz2;
                }
                this.messageStore.registerMessage(1, clazz);
                Class<?> clazz3 = class$2;
                if (clazz3 == null) {
                    Class<?> clazz4;
                    try {
                        clazz4 = Class.forName("com.sshtools.j2ssh.transport.SshMsgIgnore");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz3 = class$2 = clazz4;
                }
                this.messageStore.registerMessage(2, clazz3);
                Class<?> clazz5 = class$3;
                if (clazz5 == null) {
                    Class<?> clazz6;
                    try {
                        clazz6 = Class.forName("com.sshtools.j2ssh.transport.SshMsgUnimplemented");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz5 = class$3 = clazz6;
                }
                this.messageStore.registerMessage(3, clazz5);
                Class<?> clazz7 = class$4;
                if (clazz7 == null) {
                    Class<?> clazz8;
                    try {
                        clazz8 = Class.forName("com.sshtools.j2ssh.transport.SshMsgDebug");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz7 = class$4 = clazz8;
                }
                this.messageStore.registerMessage(4, clazz7);
                Class<?> clazz9 = class$5;
                if (clazz9 == null) {
                    Class<?> clazz10;
                    try {
                        clazz10 = Class.forName("com.sshtools.j2ssh.transport.SshMsgKexInit");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz9 = class$5 = clazz10;
                }
                this.messageStore.registerMessage(20, clazz9);
                Class<?> clazz11 = class$6;
                if (clazz11 == null) {
                    Class<?> clazz12;
                    try {
                        clazz12 = Class.forName("com.sshtools.j2ssh.transport.SshMsgNewKeys");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz11 = class$6 = clazz12;
                }
                this.messageStore.registerMessage(21, clazz11);
                this.registerTransportMessages();
                List list = SshKeyExchangeFactory.getSupportedKeyExchanges();
                Iterator it = list.iterator();
                while (true) {
                    if (!it.hasNext()) {
                        this.setLocalIdent();
                        this.negotiateVersion();
                        this.startBinaryPacketProtocol();
                    }
                    String keyExchange = (String)it.next();
                    SshKeyExchange kex = SshKeyExchangeFactory.newInstance(keyExchange);
                    kex.init(this);
                    this.kexs.put(keyExchange, kex);
                }
            }
            catch (Throwable e) {
                if (e instanceof IOException) {
                    this.state.setLastError((IOException)e);
                }
                if (this.state.getValue() != 5) {
                    log.error((Object)"The Transport Protocol thread failed", e);
                    this.stop();
                }
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.thread = null;
            throw throwable;
        }
        {
            Object var5_8 = null;
            this.thread = null;
        }
        log.debug((Object)"The Transport Protocol has been stopped");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void sendMessage(SshMessage msg, Object sender) throws IOException {
        if (log.isDebugEnabled()) {
            log.info((Object)("Sending " + msg.getMessageName()));
        }
        int currentState = this.state.getValue();
        if (sender instanceof SshKeyExchange || sender instanceof TransportProtocolCommon || currentState == 4) {
            this.sshOut.sendMessage(msg);
            if (currentState == 4 && this.sendIgnore) {
                byte[] count = new byte[1];
                ConfigurationLoader.getRND().nextBytes(count);
                byte[] rand = new byte[(count[0] & 0xFF) + 1];
                ConfigurationLoader.getRND().nextBytes(rand);
                SshMsgIgnore ignore = new SshMsgIgnore(new String(rand));
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Sending " + ignore.getMessageName()));
                }
                this.sshOut.sendMessage(ignore);
            }
        } else if (currentState == 3) {
            log.debug((Object)"Adding to message queue whilst in key exchange");
            List list = this.messageStack;
            synchronized (list) {
                this.messageStack.add(msg);
            }
        } else {
            throw new TransportProtocolException("The transport protocol is disconnected");
        }
    }

    protected abstract void onStartTransportProtocol() throws IOException;

    public void startTransportProtocol(TransportProvider provider, SshConnectionProperties properties) throws IOException {
        this.provider = provider;
        this.properties = properties;
        log.info((Object)"Starting transport protocol");
        this.thread = new SshThread(this, "Transport protocol", true);
        this.thread.start();
        this.onStartTransportProtocol();
    }

    public String getUnderlyingProviderDetail() {
        return this.provider.getProviderDetail();
    }

    public void unregisterMessage(Integer messageId, SshMessageStore store) throws MessageNotRegisteredException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Unregistering message Id " + messageId.toString()));
        }
        if (!this.messageNotifications.containsKey(messageId)) {
            throw new MessageNotRegisteredException(messageId);
        }
        SshMessageStore actual = (SshMessageStore)this.messageNotifications.get(messageId);
        if (!store.equals(actual)) {
            throw new MessageNotRegisteredException(messageId, store);
        }
        this.messageNotifications.remove(messageId);
    }

    protected abstract String getDecryptionAlgorithm() throws AlgorithmNotAgreedException;

    protected abstract String getEncryptionAlgorithm() throws AlgorithmNotAgreedException;

    protected abstract String getInputStreamCompAlgortihm() throws AlgorithmNotAgreedException;

    protected abstract String getInputStreamMacAlgorithm() throws AlgorithmNotAgreedException;

    protected abstract void setLocalIdent();

    public abstract String getLocalId();

    protected abstract void setLocalKexInit(SshMsgKexInit var1);

    protected abstract SshMsgKexInit getLocalKexInit();

    protected abstract String getOutputStreamCompAlgorithm() throws AlgorithmNotAgreedException;

    protected abstract String getOutputStreamMacAlgorithm() throws AlgorithmNotAgreedException;

    protected abstract void setRemoteIdent(String var1);

    public abstract String getRemoteId();

    protected abstract void setRemoteKexInit(SshMsgKexInit var1);

    protected abstract SshMsgKexInit getRemoteKexInit();

    protected abstract void performKeyExchange(SshKeyExchange var1) throws IOException, KeyExchangeException;

    protected String getKexAlgorithm() throws AlgorithmNotAgreedException {
        return this.determineAlgorithm(this.clientKexInit.getSupportedKex(), this.serverKexInit.getSupportedKex());
    }

    public boolean isConnected() {
        return this.state.getValue() == 4 || this.state.getValue() == 3;
    }

    protected void beginKeyExchange() throws IOException, KeyExchangeException {
        log.info((Object)"Starting key exchange");
        String kexAlgorithm = "";
        try {
            kexAlgorithm = this.getKexAlgorithm();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Key exchange algorithm: " + kexAlgorithm));
            }
            SshKeyExchange kex = (SshKeyExchange)this.kexs.get(kexAlgorithm);
            this.performKeyExchange(kex);
            this.exchangeHash = kex.getExchangeHash();
            if (this.sessionIdentifier == null) {
                this.sessionIdentifier = new byte[this.exchangeHash.length];
                System.arraycopy(this.exchangeHash, 0, this.sessionIdentifier, 0, this.sessionIdentifier.length);
                this.thread.setSessionId(this.sessionIdentifier);
            }
            this.hostKey = kex.getHostKey();
            this.signature = kex.getSignature();
            this.k = kex.getSecret();
            this.sendNewKeys();
            kex.reset();
        }
        catch (AlgorithmNotAgreedException e) {
            this.sendDisconnect(3, "No suitable key exchange algorithm was agreed");
            throw new KeyExchangeException("No suitable key exchange algorithm could be agreed.");
        }
    }

    protected SshMsgKexInit createLocalKexInit() throws IOException {
        return new SshMsgKexInit(this.properties);
    }

    protected void onCorruptMac() {
        log.fatal((Object)"Corrupt Mac on Input");
        this.sendDisconnect(5, "Corrupt Mac on input", new SshException("Corrupt Mac on Imput"));
    }

    protected abstract void onMessageReceived(SshMessage var1) throws IOException;

    protected void sendDisconnect(int reason, String description) {
        SshMsgDisconnect msg = new SshMsgDisconnect(reason, description, "");
        try {
            this.sendMessage(msg, this);
            this.stop();
        }
        catch (Exception e) {
            log.warn((Object)"Failed to send disconnect", (Throwable)e);
        }
    }

    protected void sendDisconnect(int reason, String description, IOException error) {
        this.state.setLastError(error);
        this.sendDisconnect(reason, description);
    }

    protected void sendKeyExchangeInit() throws IOException {
        this.setLocalKexInit(this.createLocalKexInit());
        this.sendMessage(this.getLocalKexInit(), this);
        this.state.setValue(3);
    }

    protected void sendNewKeys() throws IOException {
        SshMsgNewKeys msg = new SshMsgNewKeys();
        this.sendMessage(msg, this);
        this.algorithmsOut.lock();
        int[] filter = new int[]{21};
        msg = (SshMsgNewKeys)this.readMessage(filter);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received " + msg.getMessageName()));
        }
        this.completeKeyExchange();
    }

    protected abstract void setupNewKeys(byte[] var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5, byte[] var6) throws AlgorithmNotAgreedException, AlgorithmOperationException, AlgorithmNotSupportedException, AlgorithmInitializationException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void completeKeyExchange() throws IOException {
        log.info((Object)"Completing key exchange");
        try {
            log.debug((Object)"Making keys from key exchange output");
            byte[] encryptionKey = this.makeSshKey('C');
            byte[] encryptionIV = this.makeSshKey('A');
            byte[] decryptionKey = this.makeSshKey('D');
            byte[] decryptionIV = this.makeSshKey('B');
            byte[] sendMac = this.makeSshKey('E');
            byte[] receiveMac = this.makeSshKey('F');
            log.debug((Object)"Creating algorithm objects");
            this.setupNewKeys(encryptionKey, encryptionIV, decryptionKey, decryptionIV, sendMac, receiveMac);
            this.clientKexInit = null;
            this.serverKexInit = null;
            this.algorithmsOut.release();
            this.state.setValue(4);
            List list = this.messageStack;
            synchronized (list) {
                Iterator it = this.messageStack.iterator();
                log.debug((Object)"Sending queued messages");
                while (it.hasNext()) {
                    SshMessage msg = (SshMessage)it.next();
                    this.sendMessage(msg, this);
                }
                this.messageStack.clear();
            }
        }
        catch (AlgorithmNotAgreedException anae) {
            this.sendDisconnect(3, "Algorithm not agreed");
            throw new TransportProtocolException("The connection was disconnected because an algorithm could not be agreed");
        }
        catch (AlgorithmNotSupportedException anse) {
            this.sendDisconnect(3, "Application error");
            throw new TransportProtocolException("The connection was disconnected because an algorithm class could not be loaded");
        }
        catch (AlgorithmOperationException aoe) {
            this.sendDisconnect(3, "Algorithm operation error");
            throw new TransportProtocolException("The connection was disconnected because of an algorithm operation error");
        }
        catch (AlgorithmInitializationException aie) {
            this.sendDisconnect(3, "Algorithm initialization error");
            throw new TransportProtocolException("The connection was disconnected because of an algorithm initialization error");
        }
    }

    protected List getEventHandlers() {
        return this.eventHandlers;
    }

    protected String determineAlgorithm(List clientAlgorithms, List serverAlgorithms) throws AlgorithmNotAgreedException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Determine Algorithm");
            log.debug((Object)("Client Algorithms: " + clientAlgorithms.toString()));
            log.debug((Object)("Server Algorithms: " + serverAlgorithms.toString()));
        }
        Iterator itClient = clientAlgorithms.iterator();
        while (itClient.hasNext()) {
            String algorithmClient = (String)itClient.next();
            Iterator itServer = serverAlgorithms.iterator();
            while (itServer.hasNext()) {
                String algorithmServer = (String)itServer.next();
                if (!algorithmClient.equals(algorithmServer)) continue;
                log.debug((Object)("Returning " + algorithmClient));
                return algorithmClient;
            }
        }
        throw new AlgorithmNotAgreedException("Could not agree algorithm");
    }

    protected void startBinaryPacketProtocol() throws IOException {
        this.sendKeyExchangeInit();
        while (this.state.getValue() != 5) {
            SshMessage msg = this.processMessages();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Received " + msg.getMessageName()));
            }
            switch (msg.getMessageId()) {
                case 20: {
                    this.onMsgKexInit((SshMsgKexInit)msg);
                    break;
                }
                case 1: {
                    this.onMsgDisconnect((SshMsgDisconnect)msg);
                    break;
                }
                case 2: {
                    this.onMsgIgnore((SshMsgIgnore)msg);
                    break;
                }
                case 3: {
                    this.onMsgUnimplemented((SshMsgUnimplemented)msg);
                    break;
                }
                case 4: {
                    this.onMsgDebug((SshMsgDebug)msg);
                    break;
                }
                default: {
                    this.onMessageReceived(msg);
                }
            }
        }
    }

    protected final void stop() {
        this.onDisconnect();
        Iterator it = this.eventHandlers.iterator();
        while (it.hasNext()) {
            TransportProtocolEventHandler eventHandler = (TransportProtocolEventHandler)it.next();
            eventHandler.onDisconnect(this);
        }
        if (this.messageStore != null) {
            this.messageStore.close();
        }
        it = this.messageStores.iterator();
        while (it != null && it.hasNext()) {
            SshMessageStore ms = (SshMessageStore)it.next();
            try {
                ms.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.messageStores.clear();
        this.messageStore = null;
        try {
            this.provider.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private byte[] makeSshKey(char chr) throws IOException {
        try {
            ByteArrayWriter keydata = new ByteArrayWriter();
            byte[] data = new byte[20];
            Hash hash = new Hash("SHA");
            hash.putBigInteger(this.k);
            hash.putBytes(this.exchangeHash);
            hash.putByte((byte)chr);
            hash.putBytes(this.sessionIdentifier);
            data = hash.doFinal();
            keydata.write(data);
            hash.reset();
            hash.putBigInteger(this.k);
            hash.putBytes(this.exchangeHash);
            hash.putBytes(data);
            data = hash.doFinal();
            keydata.write(data);
            return keydata.toByteArray();
        }
        catch (NoSuchAlgorithmException nsae) {
            this.sendDisconnect(3, "Application error");
            throw new TransportProtocolException("SHA algorithm not supported");
        }
        catch (IOException ioe) {
            this.sendDisconnect(3, "Application error");
            throw new TransportProtocolException("Error writing key data");
        }
    }

    /*
     * Unable to fully structure code
     */
    private void negotiateVersion() throws IOException {
        remoteVer = "";
        TransportProtocolCommon.log.info((Object)"Negotiating protocol version");
        TransportProtocolCommon.log.debug((Object)("Local identification: " + this.getLocalId()));
        data = String.valueOf(this.getLocalId()) + "\r\n";
        this.provider.getOutputStream().write(data.getBytes());
        buffer = new StringBuffer();
        MAX_BUFFER_LENGTH = 255;
        ** GOTO lbl17
        {
            buffer.append(ch);
            do {
                if ((ch = (char)this.provider.getInputStream().read()) != '\n' && buffer.length() < MAX_BUFFER_LENGTH) continue block0;
                remoteVer = buffer.toString();
                this.remoteEOL = remoteVer.endsWith("\r") != false ? 1 : 2;
                TransportProtocolCommon.log.debug((Object)("EOL is guessed at " + (this.remoteEOL == 1 ? "CR+LF" : "LF")));
                remoteVer = remoteVer.trim();
lbl17:
                // 2 sources

            } while (!remoteVer.startsWith("SSH-") && buffer.length() < MAX_BUFFER_LENGTH);
        }
        l = remoteVer.indexOf("-");
        r = remoteVer.indexOf("-", l + 1);
        this.setRemoteIdent(remoteVer.trim());
        if (TransportProtocolCommon.log.isDebugEnabled()) {
            TransportProtocolCommon.log.debug((Object)("Remote identification: " + this.getRemoteId()));
        }
        if (!(remoteVersion = remoteVer.substring(l + 1, r)).equals("2.0") && !remoteVersion.equals("1.99")) {
            TransportProtocolCommon.log.fatal((Object)"The remote computer does not support protocol version 2.0");
            throw new TransportProtocolException("The protocol version of the remote computer is not supported!");
        }
        TransportProtocolCommon.log.info((Object)"Protocol negotiation complete");
    }

    private void onMsgDebug(SshMsgDebug msg) {
        log.debug((Object)msg.getMessage());
    }

    private void onMsgDisconnect(SshMsgDisconnect msg) throws IOException {
        log.info((Object)("The remote computer disconnected: " + msg.getDescription()));
        this.state.setValue(5);
        this.state.setDisconnectReason(msg.getDescription());
        this.stop();
    }

    private void onMsgIgnore(SshMsgIgnore msg) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("SSH_MSG_IGNORE with " + String.valueOf(msg.getData().length()) + " bytes of data"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onMsgKexInit(SshMsgKexInit msg) throws IOException {
        log.debug((Object)"Received remote key exchange init message");
        log.debug((Object)msg.toString());
        Object object = this.kexLock;
        synchronized (object) {
            this.setRemoteKexInit(msg);
            if (this.state.getValue() != 3) {
                this.sendKeyExchangeInit();
            }
            this.beginKeyExchange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onMsgNewKeys(SshMsgNewKeys msg) throws IOException {
        log.debug((Object)"Received New Keys");
        this.algorithmsIn.lock();
        Boolean bl = this.completeOnNewKeys;
        synchronized (bl) {
            if (this.completeOnNewKeys.booleanValue()) {
                this.completeKeyExchange();
            } else {
                this.completeOnNewKeys = new Boolean(true);
            }
        }
    }

    private void onMsgUnimplemented(SshMsgUnimplemented msg) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("The message with sequence no " + msg.getSequenceNo() + " was reported as unimplemented by the remote end."));
        }
    }

    public SshMessage readMessage(int[] filter) throws IOException {
        byte[] msgdata = null;
        block6: while (this.state.getValue() != 5) {
            SshMessage msg;
            boolean hasmsg = false;
            while (!hasmsg) {
                msgdata = this.sshIn.readMessage();
                hasmsg = true;
            }
            Integer messageId = SshMessage.getMessageId(msgdata);
            int i = 0;
            while (i < filter.length) {
                if (filter[i] == messageId) {
                    if (this.messageStore.isRegisteredMessage(messageId)) {
                        return this.messageStore.createMessage(msgdata);
                    }
                    SshMessageStore ms = this.getMessageStore(messageId);
                    msg = ms.createMessage(msgdata);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Processing " + msg.getMessageName()));
                    }
                    return msg;
                }
                ++i;
            }
            if (this.messageStore.isRegisteredMessage(messageId)) {
                msg = this.messageStore.createMessage(msgdata);
                switch (messageId) {
                    case 1: {
                        this.onMsgDisconnect((SshMsgDisconnect)msg);
                        continue block6;
                    }
                    case 2: {
                        this.onMsgIgnore((SshMsgIgnore)msg);
                        continue block6;
                    }
                    case 3: {
                        this.onMsgUnimplemented((SshMsgUnimplemented)msg);
                        continue block6;
                    }
                    case 4: {
                        this.onMsgDebug((SshMsgDebug)msg);
                        continue block6;
                    }
                    default: {
                        throw new IOException("Unexpected transport protocol message");
                    }
                }
            }
            throw new IOException("Unexpected message received");
        }
        throw new IOException("The transport protocol disconnected");
    }

    /*
     * Unable to fully structure code
     */
    protected SshMessage processMessages() throws IOException {
        msgdata = null;
        while (this.state.getValue() != 5) {
            currentTime = System.currentTimeMillis();
            if (currentTime - this.startTime > this.kexTimeout || this.sshIn.getNumBytesTransfered() + this.sshOut.getNumBytesTransfered() > this.kexTransferLimit) {
                this.startTime = currentTime;
                this.sendKeyExchangeInit();
            }
            hasmsg = false;
            block5: while (!hasmsg) {
                try {
                    msgdata = this.sshIn.readMessage();
                    hasmsg = true;
                    continue;
                }
                catch (InterruptedIOException ex) {
                    TransportProtocolCommon.log.info((Object)"Possible timeout on transport inputstream");
                    it = this.eventHandlers.iterator();
                    ** while (it.hasNext())
                }
lbl-1000:
                // 1 sources

                {
                    eventHandler = (TransportProtocolEventHandler)it.next();
                    eventHandler.onSocketTimeout(this);
                    continue;
lbl20:
                    // 1 sources

                }
            }
            messageId = SshMessage.getMessageId(msgdata);
            if (!this.messageStore.isRegisteredMessage(messageId)) {
                try {
                    ms = this.getMessageStore(messageId);
                    msg = ms.createMessage(msgdata);
                    if (TransportProtocolCommon.log.isDebugEnabled()) {
                        TransportProtocolCommon.log.info((Object)("Received " + msg.getMessageName()));
                    }
                    ms.addMessage(msg);
                }
                catch (MessageNotRegisteredException mnre) {
                    TransportProtocolCommon.log.info((Object)("Unimplemented message received " + String.valueOf(messageId)));
                    msg = new SshMsgUnimplemented(this.sshIn.getSequenceNo());
                    this.sendMessage(msg, this);
                }
                continue;
            }
            return this.messageStore.createMessage(msgdata);
        }
        throw new IOException("The transport protocol has disconnected");
    }

    public void addMessageStore(SshMessageStore store) throws MessageAlreadyRegisteredException {
        this.messageStores.add(store);
    }

    private SshMessageStore getMessageStore(Integer messageId) throws MessageNotRegisteredException {
        Iterator it = this.messageStores.iterator();
        while (it != null && it.hasNext()) {
            SshMessageStore ms = (SshMessageStore)it.next();
            if (!ms.isRegisteredMessage(messageId)) continue;
            return ms;
        }
        throw new MessageNotRegisteredException(messageId);
    }

    public void removeMessageStore(SshMessageStore ms) {
        this.messageStores.remove(ms);
    }
}

