/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.cipher;

import com.sshtools.j2ssh.transport.AlgorithmOperationException;
import com.sshtools.j2ssh.transport.cipher.SshCipher;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BlowfishCbc
extends SshCipher {
    private static Log log;
    protected static String algorithmName;
    Cipher cipher;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.sshtools.j2ssh.transport.cipher.BlowfishCbc");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
        algorithmName = "blowfish-cbc";
    }

    public int getBlockSize() {
        return this.cipher.getBlockSize();
    }

    public void init(int mode, byte[] iv, byte[] keydata) throws AlgorithmOperationException {
        try {
            this.cipher = Cipher.getInstance("Blowfish/CBC/NoPadding");
            byte[] actualKey = new byte[16];
            System.arraycopy(keydata, 0, actualKey, 0, actualKey.length);
            SecretKeySpec keyspec = new SecretKeySpec(actualKey, "Blowfish");
            this.cipher.init(mode == 0 ? 1 : 2, (Key)keyspec, new IvParameterSpec(iv, 0, this.cipher.getBlockSize()));
        }
        catch (NoSuchPaddingException nspe) {
            log.error((Object)"Blowfish initialization failed", (Throwable)nspe);
            throw new AlgorithmOperationException("No Padding not supported");
        }
        catch (NoSuchAlgorithmException nsae) {
            log.error((Object)"Blowfish initialization failed", (Throwable)nsae);
            throw new AlgorithmOperationException("Algorithm not supported");
        }
        catch (InvalidKeyException ike) {
            log.error((Object)"Blowfish initialization failed", (Throwable)ike);
            throw new AlgorithmOperationException("Invalid encryption key");
        }
        catch (InvalidAlgorithmParameterException ape) {
            log.error((Object)"Blowfish initialization failed", (Throwable)ape);
            throw new AlgorithmOperationException("Invalid algorithm parameter");
        }
    }

    public byte[] transform(byte[] data, int offset, int len) throws AlgorithmOperationException {
        return this.cipher.update(data, offset, len);
    }
}

