/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.cipher;

import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.io.IOUtil;
import com.sshtools.j2ssh.transport.AlgorithmNotSupportedException;
import com.sshtools.j2ssh.transport.cipher.SshCipher;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshCipherFactory {
    private static HashMap ciphers;
    private static String defaultCipher;
    private static Log log;
    private static ArrayList supported;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.sshtools.j2ssh.transport.cipher.SshCipherFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
        ciphers = new HashMap();
        log.info((Object)"Loading supported cipher algorithms");
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("com.sshtools.j2ssh.transport.cipher.TripleDesCbc");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ciphers.put("3des-cbc", clazz2);
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("com.sshtools.j2ssh.transport.cipher.BlowfishCbc");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ciphers.put("blowfish-cbc", clazz3);
        defaultCipher = "blowfish-cbc";
        try {
            Enumeration<URL> enumeration = ConfigurationLoader.getExtensionClassLoader().getResources("j2ssh.cipher");
            Properties properties = new Properties();
            while (enumeration != null && enumeration.hasMoreElements()) {
                URL url = enumeration.nextElement();
                InputStream in = url.openStream();
                properties.load(in);
                IOUtil.closeStream(in);
                int num = 1;
                String name = "";
                while (properties.getProperty("cipher.name." + String.valueOf(num)) != null) {
                    try {
                        name = properties.getProperty("cipher.name." + String.valueOf(num));
                        Class<?> cls = ConfigurationLoader.getExtensionClassLoader().loadClass(properties.getProperty("cipher.class." + String.valueOf(num)));
                        cls.newInstance();
                        ciphers.put(name, cls);
                        log.info((Object)("Installed " + name + " cipher"));
                    }
                    catch (Throwable ex) {
                        log.info((Object)("Could not install cipher class for " + name), ex);
                    }
                    ++num;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        supported = new ArrayList(ciphers.keySet());
    }

    protected SshCipherFactory() {
    }

    public static void initialize() {
    }

    public static String getDefaultCipher() {
        return defaultCipher;
    }

    public static List getSupportedCiphers() {
        return supported;
    }

    public static SshCipher newInstance(String algorithmName) throws AlgorithmNotSupportedException {
        log.info((Object)("Creating new " + algorithmName + " cipher instance"));
        try {
            return (SshCipher)((Class)ciphers.get(algorithmName)).newInstance();
        }
        catch (Throwable t) {
            throw new AlgorithmNotSupportedException(String.valueOf(algorithmName) + " is not supported!");
        }
    }
}

