/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.compression;

import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.io.IOUtil;
import com.sshtools.j2ssh.transport.AlgorithmNotSupportedException;
import com.sshtools.j2ssh.transport.compression.SshCompression;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshCompressionFactory {
    public static final String COMP_NONE = "none";
    private static String defaultAlgorithm;
    private static Map comps;
    private static Log log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.sshtools.j2ssh.transport.compression.SshCompressionFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
        comps = new HashMap();
        log.info((Object)"Loading compression methods");
        comps.put(COMP_NONE, "");
        defaultAlgorithm = COMP_NONE;
        try {
            Enumeration<URL> enumeration = ConfigurationLoader.getExtensionClassLoader().getResources("j2ssh.compression");
            Properties properties = new Properties();
            while (enumeration != null && enumeration.hasMoreElements()) {
                URL url = enumeration.nextElement();
                InputStream in = url.openStream();
                properties.load(in);
                IOUtil.closeStream(in);
                int num = 1;
                String name = "";
                while (properties.getProperty("compression.name." + String.valueOf(num)) != null) {
                    try {
                        name = properties.getProperty("compression.name." + String.valueOf(num));
                        Class<?> cls = ConfigurationLoader.getExtensionClassLoader().loadClass(properties.getProperty("compression.class." + String.valueOf(num)));
                        cls.newInstance();
                        comps.put(name, cls);
                        log.info((Object)("Installed " + name + " compression"));
                    }
                    catch (Throwable ex) {
                        log.info((Object)("Could not install cipher class for " + name), ex);
                    }
                    ++num;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected SshCompressionFactory() {
    }

    public static void initialize() {
    }

    public static String getDefaultCompression() {
        return defaultAlgorithm;
    }

    public static List getSupportedCompression() {
        return new ArrayList(comps.keySet());
    }

    public static SshCompression newInstance(String algorithmName) throws AlgorithmNotSupportedException {
        try {
            if (algorithmName.equals(COMP_NONE)) {
                return null;
            }
            return (SshCompression)((Class)comps.get(algorithmName)).newInstance();
        }
        catch (Exception e) {
            throw new AlgorithmNotSupportedException(String.valueOf(algorithmName) + " is not supported!");
        }
    }
}

