/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.hmac;

import com.sshtools.j2ssh.transport.AlgorithmInitializationException;
import com.sshtools.j2ssh.transport.hmac.SshHmac;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HmacSha
implements SshHmac {
    private static Log log;
    private Mac mac;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.sshtools.j2ssh.transport.hmac.HmacSha");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public int getMacLength() {
        return this.mac.getMacLength();
    }

    public byte[] generate(long sequenceNo, byte[] data, int offset, int len) {
        byte[] sequenceBytes = new byte[]{(byte)(sequenceNo >> 24), (byte)(sequenceNo >> 16), (byte)(sequenceNo >> 8), (byte)(sequenceNo >> 0)};
        this.mac.update(sequenceBytes);
        this.mac.update(data, offset, len);
        return this.mac.doFinal();
    }

    public void init(byte[] keydata) throws AlgorithmInitializationException {
        try {
            this.mac = Mac.getInstance("HmacSha1");
            byte[] key = new byte[20];
            System.arraycopy(keydata, 0, key, 0, 20);
            SecretKeySpec keyspec = new SecretKeySpec(key, "HmacSha1");
            this.mac.init(keyspec);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new AlgorithmInitializationException("No provider exists for the HmacSha1 algorithm");
        }
        catch (InvalidKeyException ike) {
            throw new AlgorithmInitializationException("Invalid key");
        }
    }

    public boolean verify(long sequenceNo, byte[] data) {
        int len = this.getMacLength();
        byte[] generated = this.generate(sequenceNo, data, 0, data.length - len);
        String compare1 = new String(generated);
        String compare2 = new String(data, data.length - len, len);
        boolean result = compare1.equals(compare2);
        return result;
    }
}

