/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.kex;

import com.sshtools.j2ssh.configuration.ConfigurationException;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.configuration.ExtensionAlgorithm;
import com.sshtools.j2ssh.configuration.SshAPIConfiguration;
import com.sshtools.j2ssh.transport.AlgorithmNotSupportedException;
import com.sshtools.j2ssh.transport.kex.SshKeyExchange;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshKeyExchangeFactory {
    private static Map kexs;
    private static String defaultAlgorithm;
    private static Log log;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        block25: {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.sshtools.j2ssh.transport.kex.SshKeyExchangeFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            log = LogFactory.getLog((Class)clazz);
            kexs = new HashMap();
            log.info((Object)"Loading key exchange methods");
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("com.sshtools.j2ssh.transport.kex.DhGroup1Sha1");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            kexs.put("diffie-hellman-group1-sha1", clazz2);
            try {
                SshAPIConfiguration config;
                Class<?> clazz3 = class$2;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$2 = Class.forName("com.sshtools.j2ssh.configuration.SshAPIConfiguration");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!ConfigurationLoader.isConfigurationAvailable(clazz3)) break block25;
                Class<?> clazz4 = class$2;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$2 = Class.forName("com.sshtools.j2ssh.configuration.SshAPIConfiguration");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((config = (SshAPIConfiguration)ConfigurationLoader.getConfiguration(clazz4)) != null) {
                    List list = config.getKeyExchangeExtensions();
                    if (list != null) {
                        Iterator it = list.iterator();
                        while (it.hasNext()) {
                            ExtensionAlgorithm algorithm = (ExtensionAlgorithm)it.next();
                            String name = algorithm.getAlgorithmName();
                            if (kexs.containsKey(name)) {
                                log.debug((Object)("Standard key exchange " + name + " is being overidden by " + algorithm.getImplementationClass()));
                            } else {
                                log.debug((Object)(String.valueOf(algorithm.getAlgorithmName()) + " key exchange is implemented by " + algorithm.getImplementationClass()));
                            }
                            try {
                                kexs.put(algorithm.getAlgorithmName(), ConfigurationLoader.getExtensionClass(algorithm.getImplementationClass()));
                            }
                            catch (ClassNotFoundException cnfe) {
                                log.error((Object)("Could not locate " + algorithm.getImplementationClass()));
                            }
                        }
                    }
                    defaultAlgorithm = config.getDefaultKeyExchange();
                }
            }
            catch (ConfigurationException config) {
                // empty catch block
            }
        }
        if (defaultAlgorithm == null || !kexs.containsKey(defaultAlgorithm)) {
            log.debug((Object)"The default key exchange is not set! using first in list");
            Iterator it = kexs.keySet().iterator();
            defaultAlgorithm = (String)it.next();
        }
    }

    protected SshKeyExchangeFactory() {
    }

    public static void initialize() {
    }

    public static String getDefaultKeyExchange() {
        return defaultAlgorithm;
    }

    public static List getSupportedKeyExchanges() {
        return new ArrayList(kexs.keySet());
    }

    public static SshKeyExchange newInstance(String methodName) throws AlgorithmNotSupportedException {
        try {
            return (SshKeyExchange)((Class)kexs.get(methodName)).newInstance();
        }
        catch (Exception e) {
            throw new AlgorithmNotSupportedException(String.valueOf(methodName) + " is not supported!");
        }
    }
}

