/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.publickey;

import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.io.IOUtil;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKeyFormat;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshPrivateKeyFormatFactory {
    private static String defaultFormat;
    private static HashMap formatTypes;
    private static Log log;
    private static Vector types;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.sshtools.j2ssh.transport.publickey.SshPrivateKeyFormatFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
        log.info((Object)"Loading private key formats");
        ArrayList<String> formats = new ArrayList<String>();
        types = new Vector();
        formatTypes = new HashMap();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("com.sshtools.j2ssh.transport.publickey.SshtoolsPrivateKeyFormat");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        formats.add(clazz2.getName());
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("com.sshtools.j2ssh.openssh.OpenSSHPrivateKeyFormat");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        formats.add(clazz3.getName());
        defaultFormat = "SSHTools-PrivateKey-Base64Encoded";
        try {
            Enumeration<URL> enumeration = ConfigurationLoader.getExtensionClassLoader().getResources("j2ssh.privatekey");
            Properties properties = new Properties();
            while (enumeration != null && enumeration.hasMoreElements()) {
                URL url = enumeration.nextElement();
                InputStream in = url.openStream();
                properties.load(in);
                IOUtil.closeStream(in);
                int num = 1;
                String name = "";
                while (properties.getProperty("privatekey.name." + String.valueOf(num)) != null) {
                    name = properties.getProperty("privatekey.name." + String.valueOf(num));
                    formats.add(properties.getProperty("privatekey.class." + String.valueOf(num)));
                    ++num;
                }
            }
        }
        catch (Throwable enumeration) {
            // empty catch block
        }
        Iterator it = formats.iterator();
        while (it.hasNext()) {
            String classname = (String)it.next();
            try {
                Class cls = ConfigurationLoader.getExtensionClass(classname);
                SshPrivateKeyFormat f = (SshPrivateKeyFormat)cls.newInstance();
                log.debug((Object)("Installing " + f.getFormatType() + " private key format"));
                formatTypes.put(f.getFormatType(), cls);
                types.add(f.getFormatType());
            }
            catch (Throwable t) {
                log.warn((Object)("Private key format implemented by " + classname + " will not be available"), t);
            }
        }
    }

    public static List getSupportedFormats() {
        return types;
    }

    public static void initialize() {
    }

    public static SshPrivateKeyFormat newInstance(String type) throws InvalidSshKeyException {
        try {
            if (formatTypes.containsKey(type)) {
                return (SshPrivateKeyFormat)((Class)formatTypes.get(type)).newInstance();
            }
            throw new InvalidSshKeyException("The format type " + type + " is not supported");
        }
        catch (IllegalAccessException iae) {
            throw new InvalidSshKeyException("Illegal access to class implementation of " + type);
        }
        catch (InstantiationException ie) {
            throw new InvalidSshKeyException("Failed to create instance of format type " + type);
        }
    }

    public static String getDefaultFormatType() {
        return defaultFormat;
    }
}

