/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.publickey;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.SshKeyPair;
import com.sshtools.j2ssh.transport.publickey.SshKeyPairFactory;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import com.sshtools.j2ssh.transport.publickey.SshPublicKeyFormat;
import com.sshtools.j2ssh.transport.publickey.SshPublicKeyFormatFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshPublicKeyFile {
    private static Log log;
    private SshPublicKeyFormat format;
    private byte[] keyblob;
    private String comment;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.sshtools.j2ssh.transport.publickey.SshPublicKeyFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    protected SshPublicKeyFile(byte[] keyblob, SshPublicKeyFormat format) {
        this.keyblob = keyblob;
        this.format = format;
    }

    public byte[] getBytes() {
        return this.format.formatKey(this.keyblob);
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public byte[] getKeyBlob() {
        return this.keyblob;
    }

    public static SshPublicKeyFile create(SshPublicKey key, SshPublicKeyFormat format) {
        SshPublicKeyFile file = new SshPublicKeyFile(key.getEncoded(), format);
        file.setComment(format.getComment());
        return file;
    }

    public static SshPublicKeyFile parse(File keyfile) throws InvalidSshKeyException, IOException {
        FileInputStream in = new FileInputStream(keyfile);
        byte[] data = new byte[in.available()];
        in.read(data);
        in.close();
        return SshPublicKeyFile.parse(data);
    }

    public static SshPublicKeyFile parse(byte[] formattedKey) throws InvalidSshKeyException {
        log.info((Object)"Parsing public key file");
        SshPublicKeyFormat format = SshPublicKeyFormatFactory.newInstance(SshPublicKeyFormatFactory.getDefaultFormatType());
        boolean valid = format.isFormatted(formattedKey);
        if (!valid) {
            log.info((Object)"Public key is not in the default format, attempting parse with other supported formats");
            Iterator it = SshPublicKeyFormatFactory.getSupportedFormats().iterator();
            while (it.hasNext() && !valid) {
                String ft = (String)it.next();
                log.debug((Object)("Attempting " + ft));
                format = SshPublicKeyFormatFactory.newInstance(ft);
                valid = format.isFormatted(formattedKey);
            }
        }
        if (valid) {
            SshPublicKeyFile file = new SshPublicKeyFile(format.getKeyBlob(formattedKey), format);
            file.setComment(format.getComment());
            return file;
        }
        throw new InvalidSshKeyException("The key format is not a supported format");
    }

    public String getAlgorithm() {
        return ByteArrayReader.readString(this.keyblob, 0);
    }

    public void setFormat(SshPublicKeyFormat newFormat) throws InvalidSshKeyException {
        if (!newFormat.supportsAlgorithm(this.getAlgorithm())) {
            throw new InvalidSshKeyException("The format does not support the public key algorithm");
        }
        newFormat.setComment(this.format.getComment());
        this.format = newFormat;
    }

    public SshPublicKeyFormat getFormat() {
        return this.format;
    }

    public SshPublicKey toPublicKey() throws IOException {
        ByteArrayReader bar = new ByteArrayReader(this.keyblob);
        String type = bar.readString();
        SshKeyPair pair = SshKeyPairFactory.newInstance(type);
        return pair.decodePublicKey(this.keyblob);
    }

    public String toString() {
        return new String(this.format.formatKey(this.keyblob));
    }
}

