/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.publickey;

import com.sshtools.j2ssh.configuration.ConfigurationException;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.configuration.SshAPIConfiguration;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.SshPublicKeyFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshPublicKeyFormatFactory {
    private static String defaultFormat;
    private static HashMap formatTypes;
    private static Log log;
    private static Vector types;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        ArrayList<String> formats;
        block24: {
            formatTypes = new HashMap();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.sshtools.j2ssh.transport.publickey.SshPublicKeyFormatFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            log = LogFactory.getLog((Class)clazz);
            types = new Vector();
            formats = new ArrayList<String>();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("com.sshtools.j2ssh.transport.publickey.SECSHPublicKeyFormat");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            formats.add(clazz2.getName());
            Class<?> clazz3 = class$2;
            if (clazz3 == null) {
                try {
                    clazz3 = class$2 = Class.forName("com.sshtools.j2ssh.transport.publickey.OpenSSHPublicKeyFormat");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            formats.add(clazz3.getName());
            defaultFormat = "SECSH-PublicKey-Base64Encoded";
            try {
                Class<?> clazz4 = class$3;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$3 = Class.forName("com.sshtools.j2ssh.configuration.SshAPIConfiguration");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!ConfigurationLoader.isConfigurationAvailable(clazz4)) break block24;
                Class<?> clazz5 = class$3;
                if (clazz5 == null) {
                    try {
                        clazz5 = class$3 = Class.forName("com.sshtools.j2ssh.configuration.SshAPIConfiguration");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                SshAPIConfiguration config = (SshAPIConfiguration)ConfigurationLoader.getConfiguration(clazz5);
                defaultFormat = config.getDefaultPublicKeyFormat();
                formats.addAll(config.getPublicKeyFormats());
            }
            catch (ConfigurationException config) {
                // empty catch block
            }
        }
        log.debug((Object)("Default public key format will be " + defaultFormat));
        Iterator it = formats.iterator();
        while (it.hasNext()) {
            String classname = (String)it.next();
            try {
                Class cls = ConfigurationLoader.getExtensionClass(classname);
                SshPublicKeyFormat f = (SshPublicKeyFormat)cls.newInstance();
                log.debug((Object)("Installing " + f.getFormatType() + " public key format"));
                formatTypes.put(f.getFormatType(), cls);
                types.add(f.getFormatType());
            }
            catch (Exception iae) {
                log.warn((Object)("Public key format implemented by " + classname + " will not be available"), (Throwable)iae);
            }
        }
    }

    public static List getSupportedFormats() {
        return types;
    }

    public static SshPublicKeyFormat newInstance(String type) throws InvalidSshKeyException {
        try {
            if (formatTypes.containsKey(type)) {
                return (SshPublicKeyFormat)((Class)formatTypes.get(type)).newInstance();
            }
            throw new InvalidSshKeyException("The format type " + type + " is not supported");
        }
        catch (IllegalAccessException iae) {
            throw new InvalidSshKeyException("Illegal access to class implementation of " + type);
        }
        catch (InstantiationException ie) {
            throw new InvalidSshKeyException("Failed to create instance of format type " + type);
        }
    }

    public static String getDefaultFormatType() {
        return defaultFormat;
    }
}

